/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.builders;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.acceleo.common.internal.utils.AcceleoPackageRegistry;
import org.eclipse.acceleo.common.utils.ModelUtils;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.ide.ui.resources.AcceleoProject;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.builders.AcceleoBuilderSettings;
import org.eclipse.acceleo.internal.ide.ui.builders.AcceleoMarkerUtils;
import org.eclipse.acceleo.internal.ide.ui.builders.runner.CreateRunnableAcceleoOperation;
import org.eclipse.acceleo.internal.ide.ui.resource.AcceleoUIResourceSet;
import org.eclipse.acceleo.internal.parser.cst.utils.FileContent;
import org.eclipse.acceleo.internal.parser.cst.utils.Sequence;
import org.eclipse.acceleo.parser.AcceleoFile;
import org.eclipse.acceleo.parser.AcceleoParser;
import org.eclipse.acceleo.parser.AcceleoParserInfo;
import org.eclipse.acceleo.parser.AcceleoParserInfos;
import org.eclipse.acceleo.parser.AcceleoParserProblem;
import org.eclipse.acceleo.parser.AcceleoParserProblems;
import org.eclipse.acceleo.parser.AcceleoParserWarning;
import org.eclipse.acceleo.parser.AcceleoParserWarnings;
import org.eclipse.acceleo.parser.AcceleoSourceBuffer;
import org.eclipse.acceleo.parser.cst.Module;
import org.eclipse.acceleo.parser.cst.TypedModel;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.ocl.ecore.OperationCallExp;

public class AcceleoCompileOperation
implements IWorkspaceRunnable {
    private IProject project;
    private IFile[] files;
    private boolean isClean;

    public AcceleoCompileOperation(IProject project, IFile[] files, boolean isClean) throws CoreException {
        this.project = project;
        this.files = files;
        this.isClean = isClean;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(AcceleoUIMessages.getString("AcceleoCompileOperation.Task.Compile"), this.files.length);
        int i = 0;
        while (i < this.files.length) {
            this.checkCanceled(monitor);
            monitor.subTask(AcceleoUIMessages.getString("AcceleoCompileOperation.Task.Clean", this.files[0].getFullPath().toString()));
            if (this.files[i].isAccessible()) {
                this.files[i].deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                this.files[i].deleteMarkers("org.eclipse.core.resources.taskmarker", true, 2);
                this.files[i].deleteMarkers("org.eclipse.acceleo.ide.ui.override", true, 2);
            }
            ++i;
        }
        if (!this.isClean) {
            this.doCompileResources(monitor);
        } else {
            IFile[] iFileArray = this.files;
            int n = this.files.length;
            int n2 = 0;
            while (n2 < n) {
                AcceleoProject acceleoProject = new AcceleoProject(this.project);
                IFile file = iFileArray[n2];
                IPath outputPath = acceleoProject.getOutputFilePath(file);
                if (outputPath != null) {
                    URI platformURI = URI.createPlatformResourceURI((String)outputPath.toString(), (boolean)false);
                    try {
                        AcceleoUIResourceSet.removeResource(platformURI);
                    }
                    catch (IOException e) {
                        AcceleoUIActivator.log(e, true);
                    }
                }
                ++n2;
            }
        }
        monitor.done();
    }

    private void doCompileResources(IProgressMonitor monitor) throws CoreException {
        AcceleoProject acceleoProject = new AcceleoProject(this.project);
        List<URI> dependenciesURIs = acceleoProject.getAccessibleOutputFiles();
        ArrayList<AcceleoFile> iFiles = new ArrayList<AcceleoFile>();
        ArrayList<URI> oURIs = new ArrayList<URI>();
        int i = 0;
        while (i < this.files.length) {
            IPath outputPath;
            this.checkCanceled(monitor);
            if (acceleoProject.getOutputFilePath(this.files[i]) != null && (outputPath = acceleoProject.getOutputFilePath(this.files[i])) != null) {
                String javaPackageName = acceleoProject.getPackageName(this.files[i]);
                AcceleoFile acceleoFile = new AcceleoFile(this.files[i].getLocation().toFile(), AcceleoFile.javaPackageToFullModuleName((String)javaPackageName, (String)new Path(this.files[i].getName()).removeFileExtension().lastSegment()));
                iFiles.add(acceleoFile);
                URI platformURI = URI.createPlatformResourceURI((String)outputPath.toString(), (boolean)false);
                oURIs.add(platformURI);
            }
            ++i;
        }
        AcceleoParser parser = null;
        AcceleoBuilderSettings settings = new AcceleoBuilderSettings(this.project);
        String resourceKind = settings.getResourceKind();
        parser = "xmi".equals(resourceKind) ? new AcceleoParser(false, settings.isTrimmedPositions()) : new AcceleoParser(true, settings.isTrimmedPositions());
        parser.parse(iFiles, oURIs, dependenciesURIs, null, (Monitor)new BasicMonitor.EclipseSubProgress(monitor, 1));
        for (URI uri : oURIs) {
            try {
                AcceleoUIResourceSet.removeResource(uri);
            }
            catch (IOException e) {
                AcceleoUIActivator.log(e, true);
            }
        }
        for (AcceleoFile iFile : iFiles) {
            AcceleoParserProblems problems = parser.getProblems(iFile);
            AcceleoParserWarnings warnings = parser.getWarnings(iFile);
            AcceleoParserInfos infos = parser.getInfos(iFile);
            IFile workspaceFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(iFile.getMtlFile().getAbsolutePath()));
            if (workspaceFile == null || !workspaceFile.isAccessible()) continue;
            if (problems != null) {
                for (AcceleoParserProblem problem : problems.getList()) {
                    AcceleoMarkerUtils.createMarkerOnFile("org.eclipse.acceleo.ide.ui.problem", workspaceFile, problem.getLine(), problem.getPosBegin(), problem.getPosEnd(), problem.getMessage());
                }
            }
            if (warnings != null) {
                for (AcceleoParserWarning warning : warnings.getList()) {
                    AcceleoMarkerUtils.createMarkerOnFile("org.eclipse.acceleo.ide.ui.warning", workspaceFile, warning.getLine(), warning.getPosBegin(), warning.getPosEnd(), warning.getMessage());
                }
            }
            if (infos == null) continue;
            for (AcceleoParserInfo info : infos.getList()) {
                AcceleoMarkerUtils.createMarkerOnFile("org.eclipse.acceleo.ide.ui.info", workspaceFile, info.getLine(), info.getPosBegin(), info.getPosEnd(), info.getMessage());
            }
        }
        if (iFiles.size() > 0) {
            AcceleoFile acceleoFile = (AcceleoFile)iFiles.get(0);
            IFile workspaceFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(acceleoFile.getMtlFile().getAbsolutePath()));
            AcceleoSourceBuffer buffer = new AcceleoSourceBuffer(acceleoFile);
            buffer.createCST();
            Module module = buffer.getCST();
            this.checkDependenciesWithDynamicMetamodels(module, workspaceFile);
        }
        this.checkCanceled(monitor);
        ArrayList<IFile> filesWithMainTag = new ArrayList<IFile>();
        for (AcceleoFile iFile : iFiles) {
            IFile workspaceFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(iFile.getMtlFile().getAbsolutePath()));
            if (workspaceFile == null || !workspaceFile.isAccessible() || !this.hasMainTag(workspaceFile)) continue;
            filesWithMainTag.add(workspaceFile);
        }
        CreateRunnableAcceleoOperation createRunnableAcceleoOperation = new CreateRunnableAcceleoOperation(acceleoProject, filesWithMainTag);
        createRunnableAcceleoOperation.run(monitor);
        settings = new AcceleoBuilderSettings(this.project);
        if ("strict" == settings.getCompliance()) {
            Iterator itFiles = iFiles.iterator();
            Iterator itURIs = oURIs.iterator();
            while (!monitor.isCanceled() && itURIs.hasNext() && itFiles.hasNext()) {
                AcceleoFile iFile = (AcceleoFile)itFiles.next();
                URI oURI = (URI)itURIs.next();
                this.checkFullOMGCompliance(iFile.getMtlFile(), oURI);
            }
        }
    }

    private void checkDependenciesWithDynamicMetamodels(Module module, IFile inputFile) {
        EList input = module.getInput();
        for (TypedModel typedModel : input) {
            EList takesTypesFrom = typedModel.getTakesTypesFrom();
            for (EPackage ePackage : takesTypesFrom) {
                Map dynamicEcorePackagePaths = AcceleoPackageRegistry.INSTANCE.getDynamicEcorePackagePaths();
                String packagePath = (String)dynamicEcorePackagePaths.get(ePackage.getNsURI());
                if (packagePath == null) {
                    return;
                }
                Path path = new Path(packagePath);
                IFile metamodelFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
                if (metamodelFile == null || !metamodelFile.isAccessible()) continue;
                IProject metamodelProject = metamodelFile.getProject();
                IProject inputProject = inputFile.getProject();
                if (inputProject.equals((Object)metamodelProject)) continue;
                boolean foundProject = false;
                AcceleoProject acceleoProject = new AcceleoProject(inputProject);
                List<IProject> recursivelyAccessibleProjects = acceleoProject.getRecursivelyAccessibleProjects();
                for (IProject iProject : recursivelyAccessibleProjects) {
                    if (!iProject.equals((Object)metamodelProject)) continue;
                    foundProject = true;
                }
                if (foundProject) continue;
                try {
                    AcceleoMarkerUtils.createMarkerOnFile("org.eclipse.acceleo.ide.ui.warning", inputFile, 0, typedModel.getStartPosition(), typedModel.getEndPosition(), AcceleoUIMessages.getString("AcceleoCompileOperation.NoDependencyWithDynamicMetamodelProject", metamodelProject.getName(), inputProject.getName()));
                }
                catch (CoreException e) {
                    AcceleoUIActivator.log((Exception)((Object)e), true);
                }
            }
        }
    }

    private void checkFullOMGCompliance(File iFile, URI oURI) {
        try {
            AcceleoSourceBuffer buffer = new AcceleoSourceBuffer(iFile);
            ResourceSetImpl oResourceSet = new ResourceSetImpl();
            EObject oRoot = ModelUtils.load((URI)oURI, (ResourceSet)oResourceSet);
            TreeIterator oAllContents = oRoot.eAllContents();
            while (oAllContents.hasNext()) {
                IFile workspaceFile;
                OperationCallExp oOperationCallExp;
                EObject oNext = (EObject)oAllContents.next();
                if (!(oNext instanceof OperationCallExp) || (oOperationCallExp = (OperationCallExp)oNext).getReferredOperation() == null || ((EOperation)oOperationCallExp.getReferredOperation()).getEAnnotation("MTL non-standard") == null || (workspaceFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(iFile.getAbsolutePath()))) == null || !workspaceFile.isAccessible() || oOperationCallExp.getStartPosition() <= -1) continue;
                int line = buffer.getLineOfOffset(oOperationCallExp.getStartPosition());
                AcceleoMarkerUtils.createMarkerOnFile("org.eclipse.acceleo.ide.ui.problem", workspaceFile, line, oOperationCallExp.getStartPosition(), oOperationCallExp.getEndPosition(), AcceleoUIMessages.getString("AcceleoCompileOperation.NotFullyCompliant", ((EOperation)oOperationCallExp.getReferredOperation()).getName()));
            }
        }
        catch (IOException e) {
            Status status = new Status(2, "org.eclipse.acceleo.ide.ui", e.getMessage(), (Throwable)e);
            AcceleoUIActivator.getDefault().getLog().log((IStatus)status);
        }
        catch (CoreException e) {
            AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
        }
    }

    private boolean hasMainTag(IFile file) {
        Sequence pattern = new Sequence("@main");
        StringBuffer contents = FileContent.getFileContent((File)file.getLocation().toFile());
        return pattern.search(contents).b() > -1;
    }

    private void checkCanceled(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }
}

