package org.mandas.docker.client.messages;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

/**
 * Immutable implementation of {@link RegistryConfigs}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRegistryConfigs.builder()}.
 */
@SuppressWarnings({"all"})
final class ImmutableRegistryConfigs implements RegistryConfigs {
  private final Map<String, RegistryAuth> configs;

  private ImmutableRegistryConfigs(Map<String, RegistryAuth> configs) {
    this.configs = configs;
  }

  /**
   * @return The value of the {@code configs} attribute
   */
  @Override
  public Map<String, RegistryAuth> configs() {
    return configs;
  }

  /**
   * Copy the current immutable object by replacing the {@link RegistryConfigs#configs() configs} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the configs map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRegistryConfigs withConfigs(Map<String, ? extends RegistryAuth> entries) {
    if (this.configs == entries) return this;
    Map<String, RegistryAuth> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableRegistryConfigs(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRegistryConfigs} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRegistryConfigs
        && equalTo((ImmutableRegistryConfigs) another);
  }

  private boolean equalTo(ImmutableRegistryConfigs another) {
    return configs.equals(another.configs);
  }

  /**
   * Computes a hash code from attributes: {@code configs}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + configs.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RegistryConfigs} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RegistryConfigs{"
        + "configs=" + configs
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link RegistryConfigs} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RegistryConfigs instance
   */
  public static ImmutableRegistryConfigs copyOf(RegistryConfigs instance) {
    if (instance instanceof ImmutableRegistryConfigs) {
      return (ImmutableRegistryConfigs) instance;
    }
    return ImmutableRegistryConfigs.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRegistryConfigs ImmutableRegistryConfigs}.
   * <pre>
   * ImmutableRegistryConfigs.builder()
   *    .addConfig|putAllConfigs(String =&gt; org.mandas.docker.client.messages.RegistryAuth) // {@link RegistryConfigs#configs() configs} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableRegistryConfigs builder
   */
  public static ImmutableRegistryConfigs.Builder builder() {
    return new ImmutableRegistryConfigs.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRegistryConfigs ImmutableRegistryConfigs}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder implements RegistryConfigs.Builder {
    private Map<String, RegistryAuth> configs = new LinkedHashMap<String, RegistryAuth>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RegistryConfigs} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RegistryConfigs instance) {
      Objects.requireNonNull(instance, "instance");
      putAllConfigs(instance.configs());
      return this;
    }

    /**
     * Put one entry to the {@link RegistryConfigs#configs() configs} map.
     * @param key The key in the configs map
     * @param value The associated value in the configs map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addConfig(String key, RegistryAuth value) {
      this.configs.put(
          Objects.requireNonNull(key, "configs key"),
          Objects.requireNonNull(value, "configs value"));
      return this;
    }

    /**
     * Put one entry to the {@link RegistryConfigs#configs() configs} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addConfig(Map.Entry<String, ? extends RegistryAuth> entry) {
      String k = entry.getKey();
      RegistryAuth v = entry.getValue();
      this.configs.put(
          Objects.requireNonNull(k, "configs key"),
          Objects.requireNonNull(v, "configs value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link RegistryConfigs#configs() configs} map. Nulls are not permitted
     * @param entries The entries that will be added to the configs map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder configs(Map<String, ? extends RegistryAuth> entries) {
      this.configs.clear();
      return putAllConfigs(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link RegistryConfigs#configs() configs} map. Nulls are not permitted
     * @param entries The entries that will be added to the configs map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllConfigs(Map<String, ? extends RegistryAuth> entries) {
      for (Map.Entry<String, ? extends RegistryAuth> e : entries.entrySet()) {
        String k = e.getKey();
        RegistryAuth v = e.getValue();
        this.configs.put(
            Objects.requireNonNull(k, "configs key"),
            Objects.requireNonNull(v, "configs value"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableRegistryConfigs ImmutableRegistryConfigs}.
     * @return An immutable instance of RegistryConfigs
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRegistryConfigs build() {
      return new ImmutableRegistryConfigs(createUnmodifiableMap(false, false, configs));
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
