/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.unittest.internal.model;

import java.time.Duration;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.unittest.internal.launcher.TestListenerRegistry;
import org.eclipse.unittest.internal.launcher.TestRunListener;
import org.eclipse.unittest.internal.model.ITestSessionListener;
import org.eclipse.unittest.internal.model.TestRunSession;
import org.eclipse.unittest.model.ITestCaseElement;
import org.eclipse.unittest.model.ITestElement;

public class TestRunListenerAdapter
implements ITestSessionListener {
    private final TestRunSession fSession;

    public TestRunListenerAdapter(TestRunSession session) {
        this.fSession = session;
    }

    private ListenerList<TestRunListener> getListenerList() {
        return TestListenerRegistry.getDefault().getUnitTestRunListeners();
    }

    private void fireSessionStarted() {
        for (TestRunListener listener : this.getListenerList()) {
            listener.sessionStarted(this.fSession);
        }
    }

    private void fireSessionFinished() {
        for (TestRunListener listener : this.getListenerList()) {
            listener.sessionFinished(this.fSession);
        }
    }

    private void fireTestCaseStarted(ITestCaseElement testCaseElement) {
        for (TestRunListener listener : this.getListenerList()) {
            listener.testCaseStarted(testCaseElement);
        }
    }

    private void fireTestCaseFinished(ITestCaseElement testCaseElement) {
        for (TestRunListener listener : this.getListenerList()) {
            listener.testCaseFinished(testCaseElement);
        }
    }

    @Override
    public void sessionStarted() {
    }

    @Override
    public void sessionCompleted(Duration duration) {
        this.fireSessionFinished();
    }

    @Override
    public void sessionAborted(Duration duration) {
        this.fireSessionFinished();
    }

    @Override
    public void testAdded(ITestElement testElement) {
    }

    @Override
    public void runningBegins() {
        this.fireSessionStarted();
    }

    @Override
    public void testStarted(ITestCaseElement testCaseElement) {
        this.fireTestCaseStarted(testCaseElement);
    }

    @Override
    public void testEnded(ITestCaseElement testCaseElement) {
        this.fireTestCaseFinished(testCaseElement);
    }

    @Override
    public void testFailed(ITestElement testElement, ITestElement.Result status, ITestElement.FailureTrace trace) {
    }
}

