/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.rcptt.ui.actions.RenameAction;
import org.eclipse.rcptt.ui.actions.ResourceSelectionUtil;
import org.eclipse.rcptt.ui.actions.edit.MoveAction;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.RenameResourceAction;

public class RefactorActionGroup
extends ActionGroup {
    private RenameResourceAction renameAction;
    private MoveAction moveAction;
    private Shell shell;
    private Tree tree;

    public RefactorActionGroup(Shell aShell, Tree aTree) {
        this.shell = aShell;
        this.tree = aTree;
        this.makeActions();
    }

    public void fillContextMenu(IMenuManager menu) {
        boolean anyResourceSelected;
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        boolean bl = anyResourceSelected = !selection.isEmpty() && ResourceSelectionUtil.allResourcesAreOfType(selection, 7);
        if (anyResourceSelected) {
            this.moveAction.selectionChanged(selection);
            menu.appendToGroup("group.reorganize", (IAction)this.moveAction);
            this.renameAction.selectionChanged(selection);
            menu.insertAfter(this.moveAction.getId(), (IAction)this.renameAction);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        this.updateActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.MOVE.getId(), (IAction)this.moveAction);
        actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.renameAction);
    }

    public void handleKeyPressed(KeyEvent event) {
        if (event.keyCode == 0x100000B && event.stateMask == 0) {
            if (this.renameAction.isEnabled()) {
                this.renameAction.run();
            }
            event.doit = false;
        }
    }

    protected void makeActions() {
        IShellProvider sp = new IShellProvider(){

            public Shell getShell() {
                return RefactorActionGroup.this.shell;
            }
        };
        this.moveAction = new MoveAction(sp);
        this.moveAction.setActionDefinitionId("org.eclipse.ui.edit.move");
        this.renameAction = new RenameAction(sp, this.tree);
    }

    public void updateActionBars() {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        this.moveAction.selectionChanged(selection);
        this.renameAction.selectionChanged(selection);
    }
}

