/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.launching;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.debug.core.debugger.launching.ILaunchDelegateListener;
import org.eclipse.php.debug.core.debugger.parameters.IDebugParametersInitializer;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.PHPDebugUtil;
import org.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org.eclipse.php.internal.debug.core.launching.PHPProcess;
import org.eclipse.php.internal.debug.core.launching.XDebugLaunch;
import org.eclipse.php.internal.debug.core.launching.XDebugLaunchListener;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapperRegistry;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.xdebug.IDELayerFactory;
import org.eclipse.php.internal.debug.core.xdebug.XDebugPreferenceMgr;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpBreakpointFacade;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpProxyHandler;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpProxyHandlersManager;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.XDebugDebuggerSettingsUtil;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpElement;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpMultiSessionTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.session.DBGpSessionHandler;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.session.IDBGpSessionListener;
import org.eclipse.php.internal.debug.core.zend.debugger.DebugParametersInitializersRegistry;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.manager.ServersManager;
import org.eclipse.php.internal.server.core.tunneling.SSHTunnel;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class XDebugWebLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    private static final String LAUNCH_LISTENERS_EXTENSION_ID = "org.eclipse.php.debug.core.phpLaunchDelegateListener";
    private List<ILaunchDelegateListener> preLaunchListeners = new ArrayList<ILaunchDelegateListener>();

    public XDebugWebLaunchConfigurationDelegate() {
        this.registerLaunchListeners();
    }

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return new XDebugLaunch(configuration, mode, null);
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String[] startStopURLs;
        IProject proj;
        Server server;
        block20: {
            int resultCode = this.notifyPreLaunch(configuration, mode, launch, monitor);
            if (resultCode != 0) {
                monitor.setCanceled(true);
                monitor.done();
                return;
            }
            if (mode.equals("debug")) {
                if (XDebugLaunchListener.getInstance().isWebLaunchActive()) {
                    this.displayErrorMessage(PHPDebugCoreMessages.XDebug_WebLaunchConfigurationDelegate_0);
                    DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
                    return;
                }
                PHPLaunchUtilities.showDebugView();
            }
            if ((server = ServersManager.getServer((String)configuration.getAttribute("name", ""))) == null) {
                Logger.log(4, "Launch configuration could not find server");
                this.displayErrorMessage(PHPDebugCoreMessages.XDebug_WebLaunchConfigurationDelegate_1);
                DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
                return;
            }
            String fileName = configuration.getAttribute("file_name", null);
            Path filePath = new Path(fileName);
            proj = null;
            try {
                proj = ResourcesPlugin.getWorkspace().getRoot().getProject(filePath.segment(0));
            }
            catch (Throwable t) {
                if (proj != null) break block20;
                Logger.logException("Could not execute the debug (Project is null).", t);
                DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
                return;
            }
        }
        ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
        String project = proj.getFullPath().toString();
        wc.setAttribute("org.eclipse.php.debug.core.PHP_Project", project);
        wc.setAttribute("debugTransferEncoding", PHPProjectPreferences.getTransferEncoding(proj));
        wc.setAttribute("debugOutputEncoding", PHPProjectPreferences.getOutputEncoding(proj));
        wc.doSave();
        boolean stopAtFirstLine = PHPProjectPreferences.getStopAtFirstLine(proj);
        stopAtFirstLine = wc.getAttribute("firstLineBreakpoint", stopAtFirstLine);
        String baseURL = new String(configuration.getAttribute("base_url", "").getBytes());
        IDebugParametersInitializer parametersInitializer = DebugParametersInitializersRegistry.getBestMatchDebugParametersInitializer(launch);
        Hashtable<String, String> params = parametersInitializer.getDebugParameters(launch);
        DBGpElement target = null;
        SSHTunnel tunnel = null;
        if (mode.equals("debug")) {
            String sessionId = DBGpSessionHandler.getInstance().generateSessionId();
            String ideKey = null;
            DBGpProxyHandler proxyHandler = DBGpProxyHandlersManager.INSTANCE.getHandler(server.getUniqueId());
            if (proxyHandler != null && proxyHandler.useProxy()) {
                ideKey = proxyHandler.getCurrentIdeKey();
                if (!proxyHandler.registerWithProxy()) {
                    this.displayErrorMessage(String.valueOf(PHPDebugCoreMessages.XDebug_WebLaunchConfigurationDelegate_2) + proxyHandler.getErrorMsg());
                    DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
                    return;
                }
            } else {
                ideKey = DBGpSessionHandler.getInstance().getIDEKey();
            }
            startStopURLs = this.generateStartStopDebugURLs(baseURL, sessionId, ideKey, params);
            String launchScript = configuration.getAttribute("file_name", null);
            tunnel = PHPLaunchUtilities.getSSHTunnel(configuration);
            if (XDebugPreferenceMgr.useMultiSession()) {
                target = new DBGpMultiSessionTarget(launch, launchScript, startStopURLs[1], ideKey, stopAtFirstLine);
                target.setPathMapper(PathMapperRegistry.getByServer(server));
                launch.addDebugTarget((IDebugTarget)target);
            } else {
                target = new DBGpTarget(launch, launchScript, startStopURLs[1], ideKey, null, stopAtFirstLine);
                target.setPathMapper(PathMapperRegistry.getByServer(server));
                PHPProcess process = new PHPProcess(launch, PHPDebugCoreMessages.XDebugWebLaunchConfigurationDelegate_PHP_process);
                process.setAttribute(IProcess.ATTR_PROCESS_TYPE, "org.eclipse.php.debug.core.launching.PHPProcess");
                ((DBGpTarget)target).setProcess(process);
                process.setDebugTarget((IDebugTarget)target);
                launch.addProcess((IProcess)process);
            }
            DBGpSessionHandler.getInstance().addSessionListener((IDBGpSessionListener)((Object)target));
            int requestPort = this.getDebugPort(server);
            if (!PHPLaunchUtilities.isDebugDaemonActive(requestPort, "org.eclipse.php.debug.core.xdebugDebugger")) {
                PHPLaunchUtilities.showLaunchErrorMessage(NLS.bind((String)PHPDebugCoreMessages.WebLaunchConfigurationDelegate_PortInUse, (Object)requestPort, (Object)server.getName()));
                monitor.setCanceled(true);
                monitor.done();
                return;
            }
        } else {
            startStopURLs = this.generateStartStopDebugURLs(baseURL, null, null, params);
        }
        String startURL = startStopURLs[0];
        SSHTunnel sshTunnel = tunnel;
        monitor.beginTask("", 10);
        monitor.subTask(PHPDebugCoreMessages.XDebug_WebLaunchConfigurationDelegate_3);
        try {
            PHPDebugUtil.openLaunchURL(startURL);
        }
        catch (Exception e) {
            if (mode.equals("debug")) {
                DBGpSessionHandler.getInstance().removeSessionListener((IDBGpSessionListener)((Object)target));
            }
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
            monitor.done();
            return;
        }
        monitor.worked(5);
        if (mode.equals("debug")) {
            launch.addDebugTarget(target);
            monitor.subTask(PHPDebugCoreMessages.XDebug_WebLaunchConfigurationDelegate_4);
            if (target != null) {
                target.waitForInitialSession((DBGpBreakpointFacade)((Object)IDELayerFactory.getIDELayer()), XDebugPreferenceMgr.createSessionPreferences(), monitor);
            }
        } else {
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
        }
        monitor.worked(5);
        monitor.done();
    }

    protected String[] generateStartStopDebugURLs(String baseURL, String sessionId, String ideKey, Hashtable<String, String> params) {
        String[] startStopURLs = new String[2];
        StringBuilder sb = new StringBuilder(baseURL);
        if (sessionId != null || params.size() > 0) {
            if (baseURL.indexOf("?") > -1) {
                sb.append('&');
            } else {
                sb.append('?');
            }
            Enumeration<String> e = params.keys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                sb.append(key).append('=');
                try {
                    sb.append(URLEncoder.encode(params.get(key), "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                sb.append('&');
            }
            if (sessionId == null) {
                sb.setLength(sb.length() - 1);
            }
        }
        if (sessionId == null) {
            startStopURLs[0] = sb.toString();
        } else {
            baseURL = sb.toString();
            startStopURLs[0] = String.valueOf(baseURL) + "XDEBUG_SESSION_START=" + ideKey + "&KEY=" + sessionId;
            startStopURLs[1] = String.valueOf(baseURL) + "XDEBUG_SESSION_STOP_NO_EXEC=" + ideKey + "&KEY=" + sessionId;
        }
        return startStopURLs;
    }

    protected int getDebugPort(Server server) {
        int customRequestPort = XDebugDebuggerSettingsUtil.getDebugPort(server.getUniqueId());
        if (customRequestPort != -1) {
            return customRequestPort;
        }
        return PHPDebugPlugin.getDebugPort("org.eclipse.php.debug.core.xdebugDebugger");
    }

    protected void displayErrorMessage(final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)PHPDebugCoreMessages.XDebugMessage_debugError, (String)message);
            }
        });
    }

    protected int notifyPreLaunch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) {
        for (ILaunchDelegateListener listener : this.preLaunchListeners) {
            int returnCode = listener.preLaunch(configuration, mode, launch, monitor);
            if (returnCode == 0) continue;
            return returnCode;
        }
        return 0;
    }

    private void registerLaunchListeners() {
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(LAUNCH_LISTENERS_EXTENSION_ID);
        try {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                final Object o = e.createExecutableExtension("class");
                if (o instanceof ILaunchDelegateListener) {
                    ISafeRunnable runnable = new ISafeRunnable(){

                        public void run() throws Exception {
                            ILaunchDelegateListener listener = (ILaunchDelegateListener)o;
                            Assert.isNotNull((Object)listener);
                            XDebugWebLaunchConfigurationDelegate.this.preLaunchListeners.add(listener);
                        }

                        public void handleException(Throwable exception) {
                            Logger.logException(exception);
                        }
                    };
                    SafeRunner.run((ISafeRunnable)runnable);
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            Logger.logException(ex);
        }
    }
}

