/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.ui.internal.validation;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jst.jsf.common.internal.JSPUtil;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.jsfappconfig.JSFAppConfigUtils;
import org.eclipse.jst.jsf.ui.internal.validation.ValidationReporter;
import org.eclipse.jst.jsf.validation.internal.IJSFViewValidator;
import org.eclipse.jst.jsf.validation.internal.JSFValidatorFactory;
import org.eclipse.jst.jsf.validation.internal.ValidationPreferences;
import org.eclipse.jst.jsp.core.internal.validation.JSPValidator;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.ISourceValidator;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class JSFValidator
extends JSPValidator
implements ISourceValidator {
    static final boolean DEBUG;
    private IDocument fDocument;

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.jst.jsf.ui/validation");
        DEBUG = value != null && value.equalsIgnoreCase("true");
    }

    public void connect(IDocument document) {
        this.fDocument = document;
    }

    public void disconnect(IDocument document) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validate(IRegion dirtyRegion, IValidationContext helper, IReporter reporter) {
        IStructuredDocument sDoc;
        IStructuredDocumentRegion[] regions;
        if (DEBUG) {
            System.out.println("exec JSPSemanticsValidator.validateRegion");
        }
        IFile file = this.getFile(helper);
        if (!(this.fDocument instanceof IStructuredDocument) || file == null || (regions = (sDoc = (IStructuredDocument)this.fDocument).getStructuredDocumentRegions(dirtyRegion.getOffset(), dirtyRegion.getLength())) == null) return;
        IJSFViewValidator validator = JSFValidatorFactory.createDefaultXMLValidator();
        ValidationPreferences prefs = new ValidationPreferences(JSFCorePlugin.getDefault().getPreferenceStore());
        prefs.load();
        IStructuredModel model = null;
        try {
            try {
                model = StructuredModelManager.getModelManager().getModelForRead(file);
                ValidationReporter jsfReporter = new ValidationReporter((IValidator)this, reporter, file, prefs, model);
                validator.validateView(file, regions, (IJSFViewValidator.IValidationReporter)jsfReporter);
                return;
            }
            catch (CoreException e) {
                JSFCorePlugin.log((String)"Error validating JSF", (Throwable)e);
                if (model == null) return;
                model.releaseFromRead();
                return;
            }
            catch (IOException e) {
                JSFCorePlugin.log((String)"Error validating JSF", (Throwable)e);
                if (model == null) return;
                model.releaseFromRead();
                return;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    private IFile getFile(IValidationContext helper) {
        String[] uris = helper.getURIs();
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (uris.length > 0) {
            return wsRoot.getFile((IPath)new Path(uris[0]));
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void validateFile(IFile file, IReporter reporter) {
        if (!this.shouldValidate(file)) return;
        IJSFViewValidator validator = JSFValidatorFactory.createDefaultXMLValidator();
        ValidationPreferences prefs = new ValidationPreferences(JSFCorePlugin.getDefault().getPreferenceStore());
        prefs.load();
        IStructuredModel model = null;
        try {
            try {
                model = StructuredModelManager.getModelManager().getModelForRead(file);
                ValidationReporter jsfReporter = new ValidationReporter((IValidator)this, reporter, file, prefs, model);
                validator.validateView(file, (IJSFViewValidator.IValidationReporter)jsfReporter);
                return;
            }
            catch (CoreException e) {
                JSFCorePlugin.log((String)"Error validating JSF", (Throwable)e);
                if (model == null) return;
                model.releaseFromRead();
                return;
            }
            catch (IOException e) {
                JSFCorePlugin.log((String)"Error validating JSF", (Throwable)e);
                if (model == null) return;
                model.releaseFromRead();
                return;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    private boolean shouldValidate(IFile file) {
        return JSPUtil.isJSPContentType((IFile)file) && JSFAppConfigUtils.isValidJSFProject((IProject)file.getProject());
    }
}

