/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.sync.ui;

import java.lang.reflect.Constructor;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.internal.rdt.sync.ui.RDTSyncUIPlugin;
import org.eclipse.ptp.rdt.sync.ui.ISynchronizeProperties;
import org.eclipse.ptp.rdt.sync.ui.ISynchronizePropertiesDescriptor;

public class SynchronizePropertiesDescriptor
implements ISynchronizePropertiesDescriptor {
    public static final String ATTR_NATURE = "nature";
    public static final String ATTR_CLASS = "class";
    private final String fNature;
    private final String fClass;
    private final String fContributorName;
    private ISynchronizeProperties fProperties;

    public SynchronizePropertiesDescriptor(IConfigurationElement configElement) {
        this.fNature = configElement.getAttribute(ATTR_NATURE);
        this.fClass = configElement.getAttribute(ATTR_CLASS);
        this.fContributorName = configElement.getDeclaringExtension().getContributor().getName();
    }

    @Override
    public String getNature() {
        return this.fNature;
    }

    @Override
    public ISynchronizeProperties getProperties() {
        if (this.fProperties == null) {
            try {
                Class cls = Platform.getBundle((String)this.fContributorName).loadClass(this.fClass);
                Constructor cons = cls.getConstructor(ISynchronizePropertiesDescriptor.class);
                this.fProperties = (ISynchronizeProperties)cons.newInstance(this);
            }
            catch (Exception e) {
                RDTSyncUIPlugin.log(NLS.bind((String)"Class {0} does not implement ISynchronizeProperties", (Object)this.fClass), e);
                return null;
            }
        }
        return this.fProperties;
    }
}

