/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.ICodeAssist;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.ui.ModelElementLabelProvider;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class SelectionConverter {
    private static final IModelElement[] EMPTY_RESULT = new IModelElement[0];

    private SelectionConverter() {
    }

    public static IStructuredSelection getStructuredSelection(IWorkbenchPart part) throws ModelException {
        ISelection selection;
        if (part instanceof PHPStructuredEditor) {
            return new StructuredSelection((Object[])SelectionConverter.codeResolve((PHPStructuredEditor)part));
        }
        ISelectionProvider provider = part.getSite().getSelectionProvider();
        if (provider != null && (selection = provider.getSelection()) instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }

    public static IModelElement[] getElements(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            IModelElement[] result = new IModelElement[selection.size()];
            int i = 0;
            for (Object element : selection) {
                if (!(element instanceof IModelElement)) {
                    return EMPTY_RESULT;
                }
                result[i] = (IModelElement)element;
                ++i;
            }
            return result;
        }
        return EMPTY_RESULT;
    }

    public static boolean canOperateOn(PHPStructuredEditor editor) {
        if (editor == null) {
            return false;
        }
        return SelectionConverter.getInput(editor) != null;
    }

    public static IModelElement[] codeResolveOrInputForked(PHPStructuredEditor editor) throws InvocationTargetException, InterruptedException {
        ISourceModule input = SelectionConverter.getInput(editor);
        if (input == null) {
            return EMPTY_RESULT;
        }
        ITextSelection selection = (ITextSelection)editor.getSelectionProvider().getSelection();
        IModelElement[] result = SelectionConverter.performForkedCodeResolve(input, selection);
        if (result.length == 0) {
            result = new IModelElement[]{input};
        }
        return result;
    }

    public static IModelElement[] codeResolve(PHPStructuredEditor editor) throws ModelException {
        return SelectionConverter.codeResolve(editor, true);
    }

    public static IModelElement[] codeResolve(PHPStructuredEditor editor, boolean primaryOnly) throws ModelException {
        ISourceModule input = SelectionConverter.getInput(editor, primaryOnly);
        if (input != null) {
            return SelectionConverter.codeResolve((IModelElement)input, (ITextSelection)editor.getSelectionProvider().getSelection());
        }
        return EMPTY_RESULT;
    }

    public static IModelElement[] codeResolveForked(PHPStructuredEditor editor, boolean primaryOnly) throws InvocationTargetException, InterruptedException {
        ISourceModule input = SelectionConverter.getInput(editor, primaryOnly);
        if (input != null) {
            return SelectionConverter.performForkedCodeResolve(input, (ITextSelection)editor.getSelectionProvider().getSelection());
        }
        return EMPTY_RESULT;
    }

    public static IModelElement getElementAtOffset(PHPStructuredEditor editor) throws ModelException {
        return SelectionConverter.getElementAtOffset(editor, true);
    }

    private static IModelElement getElementAtOffset(PHPStructuredEditor editor, boolean primaryOnly) throws ModelException {
        ISourceModule input = SelectionConverter.getInput(editor, primaryOnly);
        if (input != null) {
            return SelectionConverter.getElementAtOffset(input, (ITextSelection)editor.getSelectionProvider().getSelection());
        }
        return null;
    }

    public static IType getTypeAtOffset(PHPStructuredEditor editor) throws ModelException {
        IType[] allTypes;
        ISourceModule unit;
        IModelElement element = SelectionConverter.getElementAtOffset(editor);
        IType type = (IType)element.getAncestor(7);
        if (type == null && (unit = SelectionConverter.getInputAsCompilationUnit(editor)) != null && (allTypes = unit.getAllTypes()) != null && allTypes.length > 0) {
            type = allTypes[0];
        }
        return type;
    }

    public static ISourceModule getInput(PHPStructuredEditor editor) {
        return SelectionConverter.getInput(editor, true);
    }

    private static ISourceModule getInput(PHPStructuredEditor editor, boolean primaryOnly) {
        if (editor == null) {
            return null;
        }
        return EditorUtility.getEditorInputModelElement((IEditorPart)editor, (boolean)primaryOnly);
    }

    public static ISourceModule getInputAsTypeRoot(PHPStructuredEditor editor) {
        return SelectionConverter.getInput(editor);
    }

    public static ISourceModule getInputAsCompilationUnit(PHPStructuredEditor editor) {
        return SelectionConverter.getInput(editor);
    }

    private static IModelElement[] performForkedCodeResolve(ISourceModule input, ITextSelection selection) throws InvocationTargetException, InterruptedException {
        final class CodeResolveRunnable
        implements IRunnableWithProgress {
            IModelElement[] result;
            private final /* synthetic */ ISourceModule val$input;
            private final /* synthetic */ ITextSelection val$selection;

            CodeResolveRunnable(ISourceModule iSourceModule, ITextSelection iTextSelection) {
                this.val$input = iSourceModule;
                this.val$selection = iTextSelection;
            }

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    this.result = SelectionConverter.codeResolve((IModelElement)this.val$input, this.val$selection);
                }
                catch (ModelException e) {
                    throw new InvocationTargetException(e);
                }
            }
        }
        CodeResolveRunnable runnable = new CodeResolveRunnable(input, selection);
        PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)runnable);
        return runnable.result;
    }

    public static IModelElement[] codeResolve(IModelElement input, ITextSelection selection) throws ModelException {
        if (input instanceof ICodeAssist) {
            IModelElement[] elements;
            if (input instanceof ISourceModule) {
                ScriptModelUtil.reconcile((ISourceModule)((ISourceModule)input));
            }
            if ((elements = ((ICodeAssist)input).codeSelect(selection.getOffset() + selection.getLength(), 0)).length > 0) {
                return elements;
            }
        }
        return EMPTY_RESULT;
    }

    public static IModelElement getElementAtOffset(ISourceModule input, ITextSelection selection) throws ModelException {
        if (input != null) {
            ScriptModelUtil.reconcile((ISourceModule)input);
            IModelElement ref = input.getElementAt(selection.getOffset());
            if (ref == null) {
                return input;
            }
            return ref;
        }
        return null;
    }

    public static IModelElement resolveEnclosingElement(PHPStructuredEditor editor, ITextSelection selection) throws ModelException {
        ISourceModule input = SelectionConverter.getInput(editor);
        if (input != null) {
            return SelectionConverter.resolveEnclosingElement((IModelElement)input, selection);
        }
        return null;
    }

    public static IModelElement resolveEnclosingElement(IModelElement input, ITextSelection selection) throws ModelException {
        IModelElement atOffset = null;
        if (!(input instanceof ISourceModule)) {
            return null;
        }
        ISourceModule cunit = (ISourceModule)input;
        ScriptModelUtil.reconcile((ISourceModule)cunit);
        atOffset = cunit.getElementAt(selection.getOffset());
        if (atOffset == null) {
            return input;
        }
        int selectionEnd = selection.getOffset() + selection.getLength();
        IModelElement result = atOffset;
        if (atOffset instanceof ISourceReference) {
            ISourceRange range = ((ISourceReference)atOffset).getSourceRange();
            while (range.getOffset() + range.getLength() < selectionEnd) {
                if (!((result = result.getParent()) instanceof ISourceReference)) {
                    result = input;
                    break;
                }
                range = ((ISourceReference)result).getSourceRange();
            }
        }
        return result;
    }

    public static IModelElement selectJavaElement(IModelElement[] elements, Shell shell, String title, String message) {
        int nResults = elements.length;
        if (nResults == 0) {
            return null;
        }
        if (nResults == 1) {
            return elements[0];
        }
        int flags = ModelElementLabelProvider.SHOW_DEFAULT | 0x400 | 0x40;
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new ModelElementLabelProvider(flags));
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setElements((Object[])elements);
        if (dialog.open() == 0) {
            return (IModelElement)dialog.getFirstResult();
        }
        return null;
    }
}

