/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.editor;

import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.tools.util.CoreExecutors;
import org.eclipse.papyrus.infra.tools.util.PlatformHelper;
import org.eclipse.papyrus.infra.ui.Activator;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.ui.editor.reload.IEditorReloadListener;
import org.eclipse.papyrus.infra.ui.messages.Messages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public interface IReloadableEditor {
    public void reloadEditor(Collection<? extends Resource> var1, ReloadReason var2, DirtyPolicy var3) throws CoreException;

    public void addEditorReloadListener(IEditorReloadListener var1);

    public void removeEditorReloadListener(IEditorReloadListener var1);

    public static class Adapter
    implements IReloadableEditor {
        private final IEditorPart editor;

        public Adapter(IEditorPart editor) {
            this.editor = editor;
        }

        public static IReloadableEditor getAdapter(IMultiDiagramEditor editor) {
            return (IReloadableEditor)PlatformHelper.getAdapter((Object)editor, IReloadableEditor.class, () -> new Adapter(editor));
        }

        @Override
        public void reloadEditor(Collection<? extends Resource> triggeringResources, ReloadReason reason, DirtyPolicy dirtyPolicy) throws CoreException {
            boolean save;
            final IWorkbenchPage page = this.editor.getSite().getPage();
            final IEditorInput currentInput = this.editor.getEditorInput();
            Display display = this.editor.getSite().getShell().getDisplay();
            final String editorId = this.editor.getSite().getId();
            DirtyPolicy action = dirtyPolicy.resolve(this.editor, triggeringResources, reason);
            boolean bl = save = action == DirtyPolicy.SAVE;
            if (save && this.editor.isDirty()) {
                this.editor.doSave((IProgressMonitor)new NullProgressMonitor());
            }
            if (action != DirtyPolicy.IGNORE) {
                page.closeEditor(this.editor, save);
                if (reason.shouldReload(triggeringResources)) {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                IDE.openEditor((IWorkbenchPage)page, (IEditorInput)currentInput, (String)editorId);
                            }
                            catch (PartInitException ex) {
                                Activator.log.error((Throwable)ex);
                            }
                        }
                    });
                }
            }
        }

        @Override
        public void addEditorReloadListener(IEditorReloadListener listener) {
        }

        @Override
        public void removeEditorReloadListener(IEditorReloadListener listener) {
        }
    }

    public static enum DirtyPolicy {
        SAVE,
        DO_NOT_SAVE,
        IGNORE,
        PROMPT_TO_SAVE{

            @Override
            public DirtyPolicy resolve(IEditorPart editor, Collection<? extends Resource> triggeringResources, ReloadReason reason) throws CoreException {
                String saveOption;
                String promptIntro;
                String promptTitle;
                final boolean dirty = editor.isDirty();
                if (!dirty) {
                    if (reason.shouldReload(triggeringResources)) {
                        return DO_NOT_SAVE;
                    }
                    if (this.isPrincipalResourceAffected(editor, triggeringResources)) {
                        return DO_NOT_SAVE;
                    }
                }
                String editorName = this.getEditorName(editor);
                final String ignoreOption = Messages.IReloadableEditor_do_not_save_do_not_reload;
                String resourceNames = "";
                for (Resource resource : triggeringResources) {
                    resourceNames = String.valueOf(resourceNames) + " " + resource.getURI().lastSegment();
                }
                switch (reason) {
                    case RESOURCES_DELETED: {
                        promptTitle = Messages.IReloadableEditor_Resources_Deleted;
                        promptIntro = NLS.bind((String)Messages.IReloadableEditor_Some_resources_used_by, (Object)editorName);
                        saveOption = Messages.IReloadableEditor_Save_and_Close;
                        break;
                    }
                    default: {
                        promptTitle = Messages.IReloadableEditor_Resources_Changed;
                        promptIntro = NLS.bind((String)Messages.IReloadableEditor_Some_resources_used_by_have_changed, (Object)resourceNames, (Object)editorName);
                        saveOption = Messages.IReloadableEditor_Save_and_Reopen;
                    }
                }
                Callable<DirtyPolicy> callable = new Callable<DirtyPolicy>(){

                    @Override
                    public DirtyPolicy call() {
                        Shell parentShell = Display.getCurrent().getActiveShell();
                        String message = String.valueOf(promptIntro) + Messages.IReloadableEditor_continue_to_work;
                        String[] options = new String[]{ignoreOption, saveOption};
                        int answer = MessageDialog.open((int)3, (Shell)parentShell, (String)promptTitle, (String)message, (int)0, (String[])options);
                        DirtyPolicy result = answer == -1 ? IGNORE : (dirty ? (answer == 0 ? IGNORE : SAVE) : 1.values()[answer + 1]);
                        return result;
                    }
                };
                try {
                    return (DirtyPolicy)((Object)CoreExecutors.getUIExecutorService().syncCall((Callable)callable));
                }
                catch (ExecutionException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.infra.ui", Messages.IReloadableEditor_Failed_to_determine, (Throwable)e));
                }
                catch (InterruptedException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.infra.ui", Messages.IReloadableEditor_Interrupted_in_determining, (Throwable)e));
                }
            }
        };


        public static DirtyPolicy getDefault() {
            return PROMPT_TO_SAVE;
        }

        public DirtyPolicy resolve(IEditorPart editor, Collection<? extends Resource> triggeringResources, ReloadReason reason) throws CoreException {
            return this;
        }

        String getEditorName(IEditorPart editor) {
            ModelSet modelSet = this.getModelSet(editor);
            return modelSet == null ? editor.getTitle() : modelSet.getURIWithoutExtension().lastSegment();
        }

        private ModelSet getModelSet(IEditorPart editor) {
            ModelSet result = null;
            if (editor instanceof IMultiDiagramEditor) {
                try {
                    result = (ModelSet)((IMultiDiagramEditor)editor).getServicesRegistry().getService(ModelSet.class);
                }
                catch (ServiceException e) {
                    Activator.log.error((Throwable)e);
                }
            }
            return result;
        }

        boolean isPrincipalResourceAffected(IEditorPart editor, Collection<? extends Resource> triggeringResources) {
            boolean result;
            block2: {
                block3: {
                    result = false;
                    ModelSet modelSet = this.getModelSet(editor);
                    if (modelSet == null) break block3;
                    URI principalURI = modelSet.getURIWithoutExtension();
                    for (Resource resource : triggeringResources) {
                        if (!resource.getURI().trimFileExtension().equals(principalURI)) continue;
                        result = true;
                        break block2;
                    }
                    break block2;
                }
                URI principalURI = this.getURI(editor.getEditorInput());
                if (principalURI == null) break block2;
                for (Resource resource : triggeringResources) {
                    if (!resource.getURI().equals(principalURI)) continue;
                    result = true;
                    break;
                }
            }
            return result;
        }

        private URI getURI(IEditorInput input) {
            URI result = null;
            if (input instanceof URIEditorInput) {
                result = ((URIEditorInput)input).getURI();
            } else if (input instanceof IURIEditorInput) {
                result = URI.createURI((String)((IURIEditorInput)input).getURI().toString());
            }
            return result;
        }

        protected boolean allReadOnly(Collection<? extends Resource> resources) {
            for (Resource resource : resources) {
                TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((Resource)resource);
                if (domain != null && domain.isReadOnly(resource)) continue;
                return false;
            }
            return true;
        }
    }

    public static enum ReloadReason {
        RESOURCES_CHANGED,
        RESOURCES_DELETED;


        public boolean shouldReload(Collection<? extends Resource> triggeringResources) {
            return this != RESOURCES_DELETED;
        }
    }
}

