/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.java.discoverer.internal.serialization;

import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.modisco.facet.util.emf.core.serialization.ISerializationRegistry;
import org.eclipse.modisco.facet.util.emf.core.serialization.ISerializationService;
import org.eclipse.modisco.facet.util.emf.core.serialization.ISerializer;
import org.eclipse.modisco.infra.common.core.internal.utils.StringUtils;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.java.discoverer.ElementsToAnalyze;
import org.eclipse.modisco.java.discoverer.internal.JavaActivator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementsToAnalyzeSerializer
implements ISerializer<ElementsToAnalyze> {
    private static final String ELEMENT_PREFIX = "E:";
    private static final String PROJECT_PREFIX = "P:";
    private static final char SEPARATOR1 = ',';
    private static final char SEPARATOR1_REPLACEMENT = '1';
    private static final char SEPARATOR2 = ';';
    private static final char SEPARATOR2_REPLACEMENT = '2';
    private static final char SEPARATOR3 = '|';
    private static final char SEPARATOR3_REPLACEMENT = '3';
    private static final char ESCAPE_CHAR = '\\';

    public Class<ElementsToAnalyze> getType() {
        return ElementsToAnalyze.class;
    }

    private static String escape(String str) {
        return StringUtils.escape((String)str, (char)'\\', (char[])new char[]{',', ';', '|'}, (char[])new char[]{'1', '2', '3'});
    }

    private static String unescape(String str) {
        return StringUtils.unescape((String)str, (char)'\\', (char[])new char[]{',', ';', '|'}, (char[])new char[]{'1', '2', '3'});
    }

    public String serialize(ElementsToAnalyze elementsToAnalyze) {
        IJavaProject javaProject;
        StringBuilder builder;
        block11: {
            builder = new StringBuilder();
            javaProject = elementsToAnalyze.getJavaProject();
            if (javaProject != null) break block11;
            return "";
        }
        try {
            builder.append(ElementsToAnalyzeSerializer.escape(javaProject.getElementName()));
            builder.append(',');
            Set<Object> elementsToDiscover = elementsToAnalyze.getElementsToDiscover();
            boolean first = true;
            for (Object object : elementsToDiscover) {
                if (!first) {
                    builder.append(',');
                }
                first = false;
                if (object instanceof IJavaProject) {
                    IJavaProject javaProject2 = (IJavaProject)object;
                    builder.append(PROJECT_PREFIX);
                    builder.append(ElementsToAnalyzeSerializer.escape(javaProject2.getElementName()));
                } else if (object instanceof IJavaElement) {
                    IJavaElement javaElement = (IJavaElement)object;
                    builder.append(ELEMENT_PREFIX);
                    builder.append(ElementsToAnalyzeSerializer.escape(javaElement.getJavaProject().getElementName()));
                    builder.append('|');
                    builder.append(ElementsToAnalyzeSerializer.escape(javaElement.getElementName()));
                    builder.append('|');
                    builder.append(ElementsToAnalyzeSerializer.escape(javaElement.getPath().toString()));
                } else {
                    MoDiscoLogger.logError((String)("Unexpected element: " + object.getClass().getName()), (Plugin)JavaActivator.getDefault());
                    continue;
                }
                Map<String, Object> discoveryOptions = elementsToAnalyze.getDiscoveryOptions(object);
                for (Map.Entry<String, Object> entry : discoveryOptions.entrySet()) {
                    builder.append(';');
                    builder.append(ElementsToAnalyzeSerializer.escape(entry.getKey()));
                    builder.append(';');
                    ISerializer serializer2 = ISerializationRegistry.INSTANCE.getSerializerFor(entry.getValue().getClass());
                    if (serializer2 != null) {
                        String serialized2 = ISerializationService.INSTANCE.serialize(entry.getValue());
                        if (serialized2 == null) continue;
                        builder.append(ElementsToAnalyzeSerializer.escape(serialized2));
                        continue;
                    }
                    MoDiscoLogger.logError((String)("No serializer for: " + entry.getValue().getClass().getName()), (Plugin)JavaActivator.getDefault());
                }
            }
            return builder.toString();
        }
        catch (Exception e) {
            MoDiscoLogger.logError((Throwable)e, (String)"Error serializing elements to analyze", (Plugin)JavaActivator.getDefault());
            return "";
        }
    }

    public ElementsToAnalyze deserialize(String serializedValue) {
        try {
            String[] elements = serializedValue.split("\\,");
            ElementsToAnalyze elementsToAnalyze = new ElementsToAnalyze(ElementsToAnalyzeSerializer.getJavaProject(ElementsToAnalyzeSerializer.unescape(elements[0])));
            int i = 1;
            while (i < elements.length) {
                String[] elementParts;
                String element = elements[i];
                if (element.startsWith(PROJECT_PREFIX)) {
                    elementParts = element.substring(PROJECT_PREFIX.length()).split("\\;");
                    String projectName2 = ElementsToAnalyzeSerializer.unescape(elementParts[0]);
                    IJavaProject javaProject = ElementsToAnalyzeSerializer.getJavaProject(projectName2);
                    elementsToAnalyze.addElementToDiscover(javaProject);
                    ElementsToAnalyzeSerializer.fillMapWithRemainingParts(elementParts, elementsToAnalyze.getDiscoveryOptions(javaProject));
                } else if (element.startsWith(ELEMENT_PREFIX)) {
                    elementParts = element.substring(ELEMENT_PREFIX.length()).split("\\;");
                    String elementName = elementParts[0];
                    String[] parts = elementName.split("\\|");
                    IJavaProject containingProject = ElementsToAnalyzeSerializer.getJavaProject(ElementsToAnalyzeSerializer.unescape(parts[0]));
                    IJavaElement[] iJavaElementArray = containingProject.getChildren();
                    int n = iJavaElementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IJavaElement javaElement = iJavaElementArray[n2];
                        if (ElementsToAnalyzeSerializer.unescape(parts[1]).equals(javaElement.getElementName()) && new Path(ElementsToAnalyzeSerializer.unescape(parts[2])).equals((Object)javaElement.getPath())) {
                            elementsToAnalyze.addElementToDiscover(javaElement);
                            ElementsToAnalyzeSerializer.fillMapWithRemainingParts(elementParts, elementsToAnalyze.getDiscoveryOptions(javaElement));
                            break;
                        }
                        ++n2;
                    }
                } else {
                    MoDiscoLogger.logError((String)"unhandled element", (Plugin)JavaActivator.getDefault());
                }
                ++i;
            }
            return elementsToAnalyze;
        }
        catch (Exception e) {
            MoDiscoLogger.logError((Throwable)e, (String)"Error deserializing elements to analyze", (Plugin)JavaActivator.getDefault());
            return new ElementsToAnalyze(null);
        }
    }

    private static void fillMapWithRemainingParts(String[] elementParts, Map<String, Object> discoveryOptions) {
        int i = 1;
        while (i < elementParts.length) {
            String strKey = elementParts[i];
            String strValue = elementParts[i + 1];
            Object deserialized = ISerializationService.INSTANCE.deserialize(strValue);
            discoveryOptions.put(strKey, deserialized);
            i += 2;
        }
    }

    private static IJavaProject getJavaProject(String projectName) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        return JavaCore.create((IProject)project);
    }
}

