/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.editor.ui.internal.overview;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.libra.framework.editor.core.model.IBundle;
import org.eclipse.libra.framework.editor.ui.dependencies.BundleDependencyEditorPage;
import org.eclipse.libra.framework.editor.ui.internal.overview.BundleInformationDetailsPart;
import org.eclipse.libra.framework.editor.ui.internal.overview.BundleInformationMasterPart;
import org.eclipse.libra.framework.editor.ui.overview.BundleInformationEditorPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IDetailsPageProvider;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.MasterDetailsBlock;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.wst.server.core.IServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleInformationMasterDetailsBlock
extends MasterDetailsBlock {
    private BundleInformationDetailsPart detailsPart;
    private BundleInformationMasterPart masterPart;
    private final MultiPageEditorPart serverEditor;
    private final BundleInformationEditorPage editorPage;
    private final IServer server;

    public BundleInformationMasterDetailsBlock(BundleInformationEditorPage bundleInformationEditorPage, MultiPageEditorPart serverEditor, IServer server) {
        this.editorPage = bundleInformationEditorPage;
        this.serverEditor = serverEditor;
        this.server = server;
    }

    public void createContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        form.getBody().setLayout((Layout)layout);
        this.sashForm = new MDSashForm(form.getBody(), 0);
        this.sashForm.setData("form", (Object)managedForm);
        toolkit.adapt((Control)this.sashForm, false, false);
        this.sashForm.setMenu(form.getBody().getMenu());
        this.sashForm.setLayoutData((Object)new GridData(1808));
        this.createMasterPart(managedForm, (Composite)this.sashForm);
        this.createDetailsPart(managedForm, (Composite)this.sashForm);
        this.hookResizeListener();
        this.createToolBarActions(managedForm);
        form.updateToolBar();
        layout = new GridLayout(1, true);
        layout.marginTop = 6;
        layout.marginLeft = 6;
        managedForm.getForm().getBody().setLayout((Layout)layout);
    }

    private void createDetailsPart(IManagedForm mform, Composite parent) {
        ((MasterDetailsBlock)this).detailsPart = new DetailsPart(mform, mform.getToolkit().createPageBook(parent, 512));
        mform.addPart((IFormPart)((MasterDetailsBlock)this).detailsPart);
        this.registerPages(((MasterDetailsBlock)this).detailsPart);
    }

    protected void createMasterPart(IManagedForm managedForm, Composite parent) {
        this.masterPart = new BundleInformationMasterPart(parent, managedForm.getToolkit(), 458, this);
        managedForm.addPart((IFormPart)this.masterPart);
        this.masterPart.createContents();
    }

    protected void createToolBarActions(IManagedForm managedForm) {
    }

    protected void registerPages(DetailsPart detailsPart) {
        this.detailsPart = new BundleInformationDetailsPart(this);
        detailsPart.setPageProvider(new IDetailsPageProvider(){

            public Object getPageKey(Object object) {
                if (object instanceof IBundle) {
                    return IBundle.class;
                }
                return object.getClass();
            }

            public IDetailsPage getPage(Object key) {
                if (key.equals(IBundle.class)) {
                    return BundleInformationMasterDetailsBlock.this.detailsPart;
                }
                return null;
            }
        });
    }

    public void refresh(Map<Long, IBundle> bundles) {
        if (this.masterPart.refresh(bundles)) {
            this.detailsPart.refresh(bundles);
            BundleDependencyEditorPage depPage = this.getDependencyPage();
            if (depPage != null) {
                depPage.refresh(bundles);
            }
        }
    }

    private void hookResizeListener() {
        Control[] children;
        Listener listener = ((MDSashForm)this.sashForm).listener;
        Control[] controlArray = children = this.sashForm.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control element = controlArray[n2];
            if (!(element instanceof Sash)) {
                element.addListener(11, listener);
            }
            ++n2;
        }
    }

    private void onSashPaint(Event e) {
        Sash sash = (Sash)e.widget;
        IManagedForm form = (IManagedForm)sash.getParent().getData("form");
        FormColors colors = form.getToolkit().getColors();
        boolean vertical = (sash.getStyle() & 0x200) != 0;
        GC gc = e.gc;
        Boolean hover = (Boolean)sash.getData("hover");
        gc.setBackground(colors.getColor("org.eclipse.ui.forms.TB_BG"));
        gc.setForeground(colors.getColor("org.eclipse.ui.forms.TB_BORDER"));
        Point size = sash.getSize();
        if (vertical) {
            if (hover != null) {
                gc.fillRectangle(0, 0, size.x, size.y);
            }
        } else if (hover != null) {
            gc.fillRectangle(0, 0, size.x, size.y);
        }
    }

    public void clear() {
        this.masterPart.clear();
    }

    private BundleDependencyEditorPage getDependencyPage() {
        IEditorPart[] parts;
        IEditorPart[] iEditorPartArray = parts = this.serverEditor.findEditors(this.editorPage.getEditorInput());
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorPart part = iEditorPartArray[n2];
            if (part instanceof BundleDependencyEditorPage) {
                return (BundleDependencyEditorPage)part;
            }
            ++n2;
        }
        return null;
    }

    public void openDependencyPage(String bundle, String version) {
        BundleDependencyEditorPage depPage = this.getDependencyPage();
        if (depPage != null) {
            this.serverEditor.setActiveEditor((IEditorPart)depPage);
            depPage.showDependenciesForBundle(bundle, version);
        }
    }

    public IServer getServer() {
        return this.server;
    }

    public void setSelectedBundle(IBundle bundle) {
        this.masterPart.setSelectedBundle(bundle);
    }

    public void refresh() {
        this.masterPart.updateButtonState();
    }

    public BundleInformationEditorPage getEditorPage() {
        return this.editorPage;
    }

    class MDSashForm
    extends SashForm {
        List<Sash> sashes;
        Listener listener;

        public MDSashForm(Composite parent, int style) {
            super(parent, style);
            this.sashes = new ArrayList<Sash>();
            this.listener = new Listener(){

                public void handleEvent(Event e) {
                    switch (e.type) {
                        case 6: {
                            e.widget.setData("hover", (Object)Boolean.TRUE);
                            ((Control)e.widget).redraw();
                            break;
                        }
                        case 7: {
                            e.widget.setData("hover", null);
                            ((Control)e.widget).redraw();
                            break;
                        }
                        case 9: {
                            BundleInformationMasterDetailsBlock.this.onSashPaint(e);
                            break;
                        }
                        case 11: {
                            MDSashForm.this.hookSashListeners();
                        }
                    }
                }
            };
        }

        public void layout(boolean changed) {
            super.layout(changed);
            this.hookSashListeners();
        }

        public void layout(Control[] children) {
            super.layout(children);
            this.hookSashListeners();
        }

        private void hookSashListeners() {
            Control[] children;
            this.purgeSashes();
            Control[] controlArray = children = this.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Sash sash;
                Control element = controlArray[n2];
                if (element instanceof Sash && !this.sashes.contains(sash = (Sash)element)) {
                    sash.addListener(9, this.listener);
                    sash.addListener(6, this.listener);
                    sash.addListener(7, this.listener);
                    this.sashes.add(sash);
                }
                ++n2;
            }
        }

        private void purgeSashes() {
            Iterator<Sash> iter = this.sashes.iterator();
            while (iter.hasNext()) {
                Sash sash = iter.next();
                if (!sash.isDisposed()) continue;
                iter.remove();
            }
        }
    }
}

