/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobGroup;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.EclipseGitProgressTransformer;
import org.eclipse.egit.core.JobFamilies;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.internal.util.ProjectUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.RebaseResult;
import org.eclipse.jgit.api.errors.DetachedHeadException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidConfigurationException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.lib.BranchConfig;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.transport.CredentialsProvider;

public class PullOperation
implements IEGitOperation {
    private final Repository[] repositories;
    private Map<Repository, PullReferenceConfig> configs;
    private final Map<Repository, PullResult> results;
    private final int timeout;
    private CredentialsProvider credentialsProvider;

    public PullOperation(Set<Repository> repositories, int timeout) {
        this.timeout = timeout;
        this.repositories = repositories.toArray(new Repository[0]);
        this.configs = Collections.emptyMap();
        this.results = new LinkedHashMap<Repository, PullResult>();
    }

    public PullOperation(@NonNull Map<Repository, PullReferenceConfig> repositories, int timeout) {
        this(repositories.keySet(), timeout);
        this.configs = repositories;
    }

    @Override
    public void execute(IProgressMonitor m) throws CoreException {
        if (!this.results.isEmpty()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.egit.core", CoreText.OperationAlreadyExecuted));
        }
        int workers = this.repositories.length;
        String taskName = MessageFormat.format(CoreText.PullOperation_TaskName, workers);
        int maxThreads = this.getMaxPullThreadsCount();
        PullJobGroup jobGroup = new PullJobGroup(taskName, maxThreads, workers);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)m, (int)workers);
        Repository[] repositoryArray = this.repositories;
        int n = this.repositories.length;
        int n2 = 0;
        while (n2 < n) {
            Repository repository = repositoryArray[n2];
            PullJob pullJob = new PullJob(repository, this.configs.get(repository));
            pullJob.setJobGroup(jobGroup);
            pullJob.schedule();
            ++n2;
        }
        long noTimeout = 0L;
        try {
            jobGroup.join(noTimeout, (IProgressMonitor)progress);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CoreException(Activator.cancel(e.getMessage(), e));
        }
        catch (OperationCanceledException e) {
            throw new CoreException(Activator.cancel(e.getMessage(), e));
        }
    }

    private int getMaxPullThreadsCount() {
        String key = "core_max_pull_threads_count";
        int defaultValue = 1;
        int value = Platform.getPreferencesService().getInt("org.eclipse.egit.core", key, defaultValue, null);
        return Math.max(defaultValue, value);
    }

    static String getPullTaskName(Repository repo, PullReferenceConfig rc) {
        String remoteUri;
        String branchName;
        StoredConfig config = repo.getConfig();
        if (rc != null) {
            String remoteUri2 = config.getString("remote", rc.remote, "url");
            return "Pulling " + rc.remote + " from " + remoteUri2;
        }
        try {
            String fullBranch = repo.getFullBranch();
            branchName = fullBranch != null ? fullBranch.substring("refs/heads/".length()) : "";
        }
        catch (IOException e) {
            return "Pulling from " + repo.toString();
        }
        String remote = config.getString("branch", branchName, "remote");
        if (remote == null) {
            remote = "origin";
        }
        if ((remoteUri = config.getString("remote", remote, "url")) != null) {
            return "Pulling " + remote + " from " + remoteUri;
        }
        return "Pulling from " + repo.getDirectory();
    }

    boolean refreshNeeded(PullResult pullResult) {
        if (pullResult == null) {
            return true;
        }
        RebaseResult rebaseResult = pullResult.getRebaseResult();
        if (rebaseResult != null && rebaseResult.getStatus() == RebaseResult.Status.UP_TO_DATE) {
            return false;
        }
        MergeResult mergeResult = pullResult.getMergeResult();
        return mergeResult == null || mergeResult.getMergeStatus() != MergeResult.MergeStatus.ALREADY_UP_TO_DATE;
    }

    public Map<Repository, PullResult> getResults() {
        return this.results;
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return null;
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    private final class PullJob
    extends Job {
        private final Repository repository;
        private final PullReferenceConfig config;

        PullJob(Repository repository, PullReferenceConfig config) {
            super(PullOperation.getPullTaskName(repository, config));
            this.repository = repository;
            this.config = config;
            this.setRule(RuleUtil.getRule(repository));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus run(IProgressMonitor mymonitor) {
            PullResult pullResult = null;
            try {
                IStatus iStatus;
                block31: {
                    Throwable throwable = null;
                    Object var4_9 = null;
                    Git git = new Git(this.repository);
                    try {
                        MergeStrategy strategy;
                        PullCommand pull = git.pull();
                        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)mymonitor, (int)4);
                        pull.setProgressMonitor((ProgressMonitor)new EclipseGitProgressTransformer((IProgressMonitor)monitor.newChild(3)));
                        pull.setTimeout(PullOperation.this.timeout);
                        pull.setCredentialsProvider(PullOperation.this.credentialsProvider);
                        if (this.config != null) {
                            if (this.config.getRemote() != null) {
                                pull.setRemote(this.config.getRemote());
                            }
                            if (this.config.getReference() != null) {
                                pull.setRemoteBranchName(this.config.getReference());
                            }
                            pull.setRebase(this.config.getUpstreamConfig());
                        }
                        if ((strategy = Activator.getDefault().getPreferredMergeStrategy()) != null) {
                            pull.setStrategy(strategy);
                        }
                        pullResult = pull.call();
                        Map map = PullOperation.this.results;
                        synchronized (map) {
                            PullOperation.this.results.put(this.repository, pullResult);
                        }
                        IProject[] projects = ProjectUtil.getValidOpenProjects(this.repository);
                        if (PullOperation.this.refreshNeeded(pullResult)) {
                            ProjectUtil.refreshValidProjects(projects, (IProgressMonitor)monitor.newChild(1));
                        } else {
                            monitor.worked(1);
                        }
                        iStatus = Status.OK_STATUS;
                        if (git == null) break block31;
                    }
                    catch (Throwable throwable2) {
                        try {
                            try {
                                if (git != null) {
                                    git.close();
                                }
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                throw throwable;
                            }
                        }
                        catch (DetachedHeadException e) {
                            IStatus iStatus2 = Activator.error(CoreText.PullOperation_DetachedHeadMessage, e);
                            return iStatus2;
                        }
                        catch (InvalidConfigurationException e) {
                            IStatus iStatus3 = Activator.error(CoreText.PullOperation_PullNotConfiguredMessage, e);
                            return iStatus3;
                        }
                        catch (CoreException | GitAPIException e) {
                            IStatus iStatus4 = Activator.error(e.getMessage(), e);
                            return iStatus4;
                        }
                        catch (JGitInternalException e) {
                            Throwable cause = e.getCause();
                            if (cause == null || !(cause instanceof TransportException)) {
                                cause = e;
                            }
                            IStatus iStatus5 = Activator.error(cause.getMessage(), cause);
                            return iStatus5;
                        }
                    }
                    git.close();
                }
                return iStatus;
            }
            finally {
                mymonitor.done();
            }
        }

        public boolean belongsTo(Object family) {
            return JobFamilies.PULL.equals(family);
        }
    }

    private static class PullJobGroup
    extends JobGroup {
        public PullJobGroup(String name, int maxThreads, int initialJobCount) {
            super(name, maxThreads, initialJobCount);
        }

        protected boolean shouldCancel(IStatus lastCompletedJobResult, int numberOfFailedJobs, int numberOfCancelledJobs) {
            return false;
        }
    }

    public static class PullReferenceConfig {
        private String remote;
        private String reference;
        private BranchConfig.BranchRebaseMode upstreamConfig;

        public PullReferenceConfig(@Nullable String remote, @Nullable String reference, @Nullable BranchConfig.BranchRebaseMode upstreamConfig) {
            this.remote = remote;
            this.reference = reference;
            this.upstreamConfig = upstreamConfig;
        }

        @Nullable
        public String getRemote() {
            return this.remote;
        }

        @Nullable
        public String getReference() {
            return this.reference;
        }

        @Nullable
        public BranchConfig.BranchRebaseMode getUpstreamConfig() {
            return this.upstreamConfig;
        }
    }
}

