/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.js.cli.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.wst.jsdt.js.cli.CLIPlugin;
import org.eclipse.wst.jsdt.js.cli.Messages;
import org.eclipse.wst.jsdt.js.cli.core.CLICommand;
import org.eclipse.wst.jsdt.js.cli.core.CLIResult;
import org.eclipse.wst.jsdt.js.cli.core.CLIStreamListener;
import org.eclipse.wst.jsdt.js.cli.internal.util.ExternalProcessUtility;
import org.eclipse.wst.jsdt.js.cli.internal.util.ProcessUtil;

public class CLI {
    private static Map<String, Lock> projectLock = Collections.synchronizedMap(new HashMap());
    private IProject project;
    private IPath workingDir;
    private CLICommand command;
    IDebugEventSetListener processTerminateListener = new IDebugEventSetListener(){

        public void handleDebugEvents(DebugEvent[] events) {
            DebugEvent[] debugEventArray = events;
            int n = events.length;
            int n2 = 0;
            while (n2 < n) {
                block7: {
                    ILaunchConfiguration lc;
                    ILaunch launch;
                    Object source;
                    DebugEvent event = debugEventArray[n2];
                    if (event.getKind() == 8 && (source = event.getSource()) instanceof IProcess && (launch = ((IProcess)source).getLaunch()) != null && (lc = launch.getLaunchConfiguration()) != null && CLI.this.project != null && CLI.this.project.exists()) {
                        try {
                            try {
                                CLI.this.project.refreshLocal(2, null);
                            }
                            catch (CoreException e) {
                                CLIPlugin.logError(e);
                                DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                                break block7;
                            }
                        }
                        catch (Throwable throwable) {
                            DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                            throw throwable;
                        }
                        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                    }
                }
                ++n2;
            }
        }
    };

    public CLI(IProject project, IPath workingDir, CLICommand command) {
        if (project == null) {
            throw new IllegalArgumentException(Messages.Error_NoProjectSpecified);
        }
        this.project = project;
        this.workingDir = workingDir == null ? project.getLocation() : workingDir;
        this.command = command;
    }

    public CLIResult execute(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        CLIStreamListener streamListener = new CLIStreamListener();
        IProcess process = this.startShell(streamListener, monitor, this.getLaunchConfiguration(this.command));
        this.sendCLICommand(process, this.command, monitor);
        CLIResult result = new CLIResult(streamListener.getErrorMessage(), streamListener.getMessage());
        this.throwExceptionIfError(result);
        return result;
    }

    private ILaunchConfiguration getLaunchConfiguration(CLICommand command) {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType("org.eclipse.ui.externaltools.ProgramLaunchConfigurationType");
        try {
            ILaunchConfigurationWorkingCopy cfg = type.newInstance(null, command.getToolName());
            ILaunchConfigurationWorkingCopy wc = cfg.getWorkingCopy();
            wc.setAttribute(IProcess.ATTR_PROCESS_LABEL, String.valueOf(command.getToolName()) + " " + command.getCommandName());
            wc.setAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING", "UTF-8");
            cfg = wc.doSave();
            return cfg;
        }
        catch (CoreException e) {
            CLIPlugin.logError(e);
            return null;
        }
    }

    protected void sendCLICommand(IProcess process, CLICommand command, IProgressMonitor monitor) throws CoreException {
        try {
            try {
                DebugPlugin.getDefault().addDebugEventListener(this.processTerminateListener);
                IStreamsProxy streamProxy = process.getStreamsProxy();
                streamProxy.write(command.toString());
                while (!process.isTerminated()) {
                    streamProxy.write("exit\n");
                    if (monitor.isCanceled()) {
                        process.terminate();
                        break;
                    }
                    Thread.sleep(100L);
                }
            }
            catch (IOException | InterruptedException e) {
                throw new CoreException((IStatus)new Status(4, "org.jboss.tools.jst.js.cli", Messages.Error_FatalInvokingCLI, (Throwable)e));
            }
        }
        finally {
            String pid;
            if (process.getExitValue() != 0 && (pid = ProcessUtil.getPID(command, this.workingDir.toOSString())) != null) {
                ProcessUtil.terminateProcessById(pid, false, true);
            }
        }
    }

    public IProcess startShell(IStreamListener listener, IProgressMonitor monitor, ILaunchConfiguration launchConfiguration) throws CoreException {
        ArrayList<String> commandList = new ArrayList<String>();
        if (this.isWindows()) {
            commandList.add("cmd");
        } else {
            commandList.add("/bin/bash");
            commandList.add("-l");
        }
        ExternalProcessUtility ep = new ExternalProcessUtility();
        IProcess process = ep.exec(commandList.toArray(new String[commandList.size()]), this.workingDir.toFile(), monitor, null, launchConfiguration);
        if (listener != null) {
            process.getStreamsProxy().getOutputStreamMonitor().addListener(listener);
            process.getStreamsProxy().getErrorStreamMonitor().addListener(listener);
        }
        return process;
    }

    private boolean isWindows() {
        String OS = System.getProperty("os.name", "unknown");
        return OS.toLowerCase().indexOf("win") > -1;
    }

    private Lock projectLock() {
        String projectName = this.project.getProject().getName();
        Lock l = projectLock.get(this.project.getProject().getName());
        if (l == null) {
            l = new ReentrantLock();
            projectLock.put(projectName, l);
        }
        return l;
    }

    protected void throwExceptionIfError(CLIResult result) throws CoreException {
        if (result.hasError()) {
            throw result.asCoreException();
        }
    }
}

