/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.actions.analysis;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelection;
import org.eclipse.sirius.ui.tools.api.actions.analysis.IAddModelDependencyWizard;
import org.eclipse.sirius.ui.tools.internal.actions.analysis.IAddModelDependencyWizardRegistry;
import org.eclipse.sirius.ui.tools.internal.dialogs.SemanticResourceDialog;
import org.eclipse.sirius.ui.tools.internal.operations.SemanticResourceAdditionOperation;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class AddModelDependencyAction
extends Action {
    Session session;
    private boolean openViewpointSelectionAfterAddition;

    public AddModelDependencyAction(Session session) {
        this(session, true);
    }

    public AddModelDependencyAction(Session session, boolean openViewpointSelectionAfterAddition) {
        super(Messages.AddModelDependencyAction_title);
        ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.ui", (String)"/icons/full/others/add.gif");
        this.setImageDescriptor(descriptor);
        this.session = session;
        this.openViewpointSelectionAfterAddition = openViewpointSelectionAfterAddition;
    }

    public void run() {
        super.run();
        IAddModelDependencyWizard wizard = IAddModelDependencyWizardRegistry.getCreateOrAddModelDependencyWizard(new ArrayList<Session>(Arrays.asList(this.session)));
        if (wizard != null) {
            wizard.setSessions(new ArrayList<Session>(Arrays.asList(this.session)));
            WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (IWizard)wizard);
            dialog.create();
            dialog.getShell().setText(wizard.getWizardTitle());
            dialog.open();
        } else {
            this.createSemanticResourceDialog();
        }
    }

    private void createSemanticResourceDialog() {
        List uris;
        SemanticResourceDialog resourceDialog = new SemanticResourceDialog(Display.getCurrent().getActiveShell(), Messages.AddModelDependencyAction_resourceSelectionMessage, 4098);
        if (resourceDialog.open() == 0 && !(uris = resourceDialog.getURIs()).isEmpty()) {
            SemanticResourceAdditionOperation semanticResourceAdditionOperation = new SemanticResourceAdditionOperation(Collections.singleton(this.session), uris);
            try {
                new ProgressMonitorDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell()).run(true, false, (IRunnableWithProgress)semanticResourceAdditionOperation);
                Collection<Object> results = semanticResourceAdditionOperation.getResults();
                for (Object result : results) {
                    if (!(result instanceof Session) || !this.openViewpointSelectionAfterAddition) continue;
                    ViewpointSelection.openViewpointsSelectionDialog((Session)result);
                }
            }
            catch (InvocationTargetException e) {
                SiriusPlugin.getDefault().error(Messages.AddModelDependencyAction_error, (Throwable)e);
            }
            catch (InterruptedException e) {
                SiriusPlugin.getDefault().error(Messages.AddModelDependencyAction_error, (Throwable)e);
            }
        }
    }
}

