/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractNodeEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.CombinedFragment;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Execution;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InteractionUse;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Lifeline;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Message;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Operand;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.State;
import org.eclipse.sirius.diagram.sequence.util.Range;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public final class ParentOperandFinder {
    private static Collection<Class<?>> types = new ArrayList();
    private Function<ISequenceEvent, Range> rangeFunction;
    private ISequenceEvent event;

    public ParentOperandFinder(ISequenceEvent event) {
        types.add(Lifeline.class);
        types.add(AbstractNodeEvent.class);
        types.add(Execution.class);
        types.add(State.class);
        types.add(InteractionUse.class);
        types.add(CombinedFragment.class);
        types.add(Message.class);
        this.rangeFunction = ISequenceEvent.VERTICAL_RANGE;
        Preconditions.checkArgument((boolean)types.contains(event.getClass()));
        Preconditions.checkNotNull((Object)event);
        this.event = event;
    }

    public ParentOperandFinder(ISequenceEvent event, Function<ISequenceEvent, Range> rangeFunction) {
        this(event);
        Preconditions.checkNotNull(rangeFunction);
        this.rangeFunction = rangeFunction;
    }

    public Option<Operand> getParentOperand() {
        Range verticalRange = (Range)this.rangeFunction.apply((Object)this.event);
        return this.getParentOperand(verticalRange);
    }

    public Option<Operand> getParentOperand(final Range verticalRange) {
        SequenceDiagram diagram = this.event.getDiagram();
        Set<Operand> allOperands = diagram.getAllOperands();
        final HashMap combinedFragmentToCoveredLifelines = new HashMap();
        Predicate<Operand> coveredLifeline = new Predicate<Operand>(){

            public boolean apply(Operand input) {
                CombinedFragment parentCombinedFragment = input.getCombinedFragment();
                Collection<Lifeline> computeCoveredLifelines = (Collection<Lifeline>)combinedFragmentToCoveredLifelines.get(parentCombinedFragment);
                if (computeCoveredLifelines == null) {
                    computeCoveredLifelines = parentCombinedFragment.computeCoveredLifelines();
                    combinedFragmentToCoveredLifelines.put(parentCombinedFragment, computeCoveredLifelines);
                }
                return computeCoveredLifelines != null && computeCoveredLifelines.contains(ParentOperandFinder.this.event.getLifeline().get());
            }
        };
        Predicate<Operand> includingExecutionRange = new Predicate<Operand>(){

            public boolean apply(Operand input) {
                return ((Range)ParentOperandFinder.this.rangeFunction.apply((Object)input)).includes(new Range(verticalRange.getLowerBound(), verticalRange.getLowerBound()));
            }
        };
        Operand deepestCoveringOperand = null;
        for (Operand operand : Iterables.filter(allOperands, (Predicate)Predicates.and((Predicate)includingExecutionRange, (Predicate)coveredLifeline))) {
            if (deepestCoveringOperand != null && !((Range)this.rangeFunction.apply((Object)deepestCoveringOperand)).includes((Range)this.rangeFunction.apply((Object)operand))) continue;
            deepestCoveringOperand = operand;
        }
        if (deepestCoveringOperand != null) {
            return Options.newSome(deepestCoveringOperand);
        }
        return Options.newNone();
    }
}

