/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.jsch.core.commands;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.remote.internal.jsch.core.JSchConnection;
import org.eclipse.remote.internal.jsch.core.commands.AbstractRemoteCommand;

public class ChildInfosCommand
extends AbstractRemoteCommand<IFileInfo[]> {
    private final IPath fRemotePath;

    public ChildInfosCommand(JSchConnection connection, IPath path) {
        super(connection);
        this.fRemotePath = path;
    }

    @Override
    public IFileInfo[] getResult(IProgressMonitor monitor) throws RemoteConnectionException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)20);
        Vector<ChannelSftp.LsEntry> files = this.getResult(this.fRemotePath.toString(), (IProgressMonitor)subMon.newChild(10));
        ArrayList<IFileInfo> result = new ArrayList<IFileInfo>();
        if (files != null && !subMon.isCanceled()) {
            Enumeration<ChannelSftp.LsEntry> enumeration = files.elements();
            while (enumeration.hasMoreElements() && !subMon.isCanceled()) {
                ChannelSftp.LsEntry entry = enumeration.nextElement();
                String fileName = entry.getFilename();
                if (fileName.equals(".") || fileName.equals("..")) continue;
                result.add(this.convertToFileInfo(fileName, this.fRemotePath, entry.getAttrs(), (IProgressMonitor)subMon.newChild(10)));
            }
        }
        return result.toArray(new IFileInfo[result.size()]);
    }

    private Vector<ChannelSftp.LsEntry> getResult(String path, IProgressMonitor monitor) throws RemoteConnectionException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        AbstractRemoteCommand.SftpCallable<Vector<ChannelSftp.LsEntry>> c = new AbstractRemoteCommand.SftpCallable<Vector<ChannelSftp.LsEntry>>((AbstractRemoteCommand)this){

            @Override
            public Vector<ChannelSftp.LsEntry> call() throws JSchException, SftpException {
                return this.getChannel().ls(ChildInfosCommand.this.quote(ChildInfosCommand.this.fRemotePath.toString(), true));
            }
        };
        try {
            return (Vector)c.getResult((IProgressMonitor)subMon.newChild(10));
        }
        catch (SftpException e) {
            throw new RemoteConnectionException(e.getMessage());
        }
    }
}

