/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.command;

import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SemanticCreateCommand;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequestFactory;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.commands.DestroyElementPapyrusCommand;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.NodeEditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.IPapyrusNodeFigure;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.AbstractExecutionSpecificationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CustomActionExecutionSpecificationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.messages.Messages;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.sequence.preferences.CustomDiagramGeneralPreferencePage;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceDeleteHelper;
import org.eclipse.papyrus.uml.service.types.element.UMLDIElementTypes;
import org.eclipse.uml2.uml.DestructionOccurrenceSpecification;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.UMLPackage;

public class CreateExecutionSpecificationWithMessage
extends AbstractTransactionalCommand {
    protected CreateConnectionViewAndElementRequest request;
    protected EditPart graphicalContainer;
    protected String preference;
    protected IHintedType type;
    protected boolean createReply;
    private ExecutionSpecification createdExecutionSpecification;
    private Message createdMessageReply;

    public CreateExecutionSpecificationWithMessage(TransactionalEditingDomain domain, CreateConnectionViewAndElementRequest request, EditPart graphicalContainer) {
        super(domain, Messages.Commands_CreateExecutionSpecification_Label, null);
        this.request = request;
        this.graphicalContainer = graphicalContainer;
        this.createReply = false;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Message message = this.getMessage();
        if (message == null) {
            throw new ExecutionException("null message");
        }
        this.retrievePreferences();
        if (this.type == null && this.preference == null) {
            throw new ExecutionException("undefined preference");
        }
        if (this.type != null && !"CHOICE_NONE".equals(this.preference)) {
            this.createExecutionSpecification();
        }
        return CommandResult.newOKCommandResult();
    }

    protected IStatus doUndo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        EObject container;
        CompositeTransactionalCommand compositeCommand;
        CompoundCommand compoundCommand;
        if (this.createdMessageReply != null) {
            MessageEnd sendEvent = this.createdMessageReply.getSendEvent();
            MessageEnd receiveEvent = this.createdMessageReply.getReceiveEvent();
            compoundCommand = new CompoundCommand();
            SequenceDeleteHelper.destroyMessageEvent(compoundCommand, sendEvent, this.getEditingDomain());
            if (!(receiveEvent instanceof DestructionOccurrenceSpecification)) {
                SequenceDeleteHelper.destroyMessageEvent(compoundCommand, receiveEvent, this.getEditingDomain());
            }
            if (!compoundCommand.isEmpty() && compoundCommand.canExecute()) {
                compoundCommand.execute();
            }
            compositeCommand = new CompositeTransactionalCommand(this.getEditingDomain(), "Remove message view");
            SequenceDeleteHelper.deleteView(compositeCommand, (Element)this.createdMessageReply, this.getEditingDomain());
            compositeCommand.execute(monitor, info);
            container = this.createdMessageReply.eContainer();
            if (container instanceof Interaction) {
                ((Interaction)container).getMessages().remove((Object)this.createdMessageReply);
            }
        }
        if (this.createdExecutionSpecification != null) {
            OccurrenceSpecification start = this.createdExecutionSpecification.getStart();
            OccurrenceSpecification finish = this.createdExecutionSpecification.getFinish();
            compoundCommand = new CompoundCommand();
            if (start != null) {
                DestroyElementRequest delStart = new DestroyElementRequest(this.getEditingDomain(), (EObject)start, false);
                compoundCommand.add((Command)new ICommandProxy((ICommand)new DestroyElementCommand(delStart)));
            }
            if (finish != null) {
                DestroyElementRequest delEnd = new DestroyElementRequest(this.getEditingDomain(), (EObject)finish, false);
                compoundCommand.add((Command)new ICommandProxy((ICommand)new DestroyElementCommand(delEnd)));
            }
            if (!compoundCommand.isEmpty() && compoundCommand.canExecute()) {
                compoundCommand.execute();
            }
            compositeCommand = new CompositeTransactionalCommand(this.getEditingDomain(), "Remove execution specification view");
            SequenceDeleteHelper.deleteView(compositeCommand, (Element)this.createdExecutionSpecification, this.getEditingDomain());
            compositeCommand.execute(monitor, info);
            container = this.createdExecutionSpecification.eContainer();
            if (container instanceof Interaction) {
                ((Interaction)container).getFragments().remove((Object)this.createdExecutionSpecification);
            } else if (container instanceof InteractionOperand) {
                ((InteractionOperand)container).getFragments().remove((Object)this.createdExecutionSpecification);
            }
        }
        this.createdExecutionSpecification = null;
        this.createdMessageReply = null;
        this.setResult(new CommandResult(Status.OK_STATUS));
        return Status.OK_STATUS;
    }

    protected IStatus doRedo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        CommandResult result = this.doExecuteWithResult(monitor, info);
        this.setResult(result);
        return result.getStatus();
    }

    private void createExecutionSpecification() {
        LifelineEditPart lifelineEditPart = (LifelineEditPart)this.graphicalContainer;
        CreateViewRequest requestcreation = CreateViewRequestFactory.getCreateShapeRequest((IElementType)this.type, (PreferencesHint)lifelineEditPart.getDiagramPreferencesHint());
        Point point = this.request.getLocation().getCopy();
        requestcreation.setLocation(point);
        Command command = lifelineEditPart.getCommand((Request)requestcreation);
        command.execute();
        this.createdExecutionSpecification = this.getCreatedElement(command, ExecutionSpecification.class);
        if (this.createReply && this.createdExecutionSpecification != null) {
            Point replysourcepoint = point.getCopy();
            replysourcepoint.setY(replysourcepoint.y + CustomActionExecutionSpecificationEditPart.DEFAULT_HEIGHT);
            this.createReplyMessage(lifelineEditPart, this.createdExecutionSpecification, replysourcepoint);
        }
    }

    private void createReplyMessage(LifelineEditPart lifelineEditPart, ExecutionSpecification executionSpecification, Point replysourcepoint) {
        CreateConnectionViewRequest requestreplycreation = CreateViewRequestFactory.getCreateConnectionRequest((IElementType)UMLDIElementTypes.MESSAGE_REPLY_EDGE, (PreferencesHint)lifelineEditPart.getDiagramPreferencesHint());
        requestreplycreation.setLocation(replysourcepoint);
        requestreplycreation.setSourceEditPart(null);
        requestreplycreation.setTargetEditPart((EditPart)lifelineEditPart);
        requestreplycreation.setType((Object)"connection start");
        Command replycommand = lifelineEditPart.getCommand((Request)requestreplycreation);
        requestreplycreation.setSourceEditPart((EditPart)lifelineEditPart);
        NodeEditPart target = (NodeEditPart)this.request.getSourceEditPart();
        while (target instanceof AbstractExecutionSpecificationEditPart) {
            target = (NodeEditPart)target.getParent();
        }
        requestreplycreation.setTargetEditPart((EditPart)target);
        requestreplycreation.setType((Object)"connection end");
        IPapyrusNodeFigure f = target.getPrimaryShape();
        Rectangle b = f.getBounds().getCopy();
        f.translateToAbsolute((Translatable)b);
        Point c = b.getCenter().getCopy();
        Point replytargetpoint = replysourcepoint.getCopy();
        replytargetpoint.setX(c.x);
        requestreplycreation.setLocation(replytargetpoint);
        replycommand = target.getCommand((Request)requestreplycreation);
        replycommand.execute();
        this.createdMessageReply = this.getCreatedElement(replycommand, Message.class);
        if (this.createdMessageReply != null) {
            MessageEnd sendEvent = this.createdMessageReply.getSendEvent();
            OccurrenceSpecification finish = executionSpecification.getFinish();
            SetCommand setSendEventCommand = new SetCommand((EditingDomain)this.getEditingDomain(), (EObject)executionSpecification, (EStructuralFeature)UMLPackage.eINSTANCE.getExecutionSpecification_Finish(), (Object)sendEvent);
            setSendEventCommand.execute();
            DestroyElementPapyrusCommand destroyElementPapyrusCommand = new DestroyElementPapyrusCommand(new DestroyElementRequest((EObject)finish, false));
            if (destroyElementPapyrusCommand != null && destroyElementPapyrusCommand.canExecute()) {
                new GMFtoEMFCommandWrapper((ICommand)destroyElementPapyrusCommand).execute();
            }
        }
    }

    private Message getMessage() {
        Message message = null;
        CreateConnectionViewAndElementRequest.ConnectionViewAndElementDescriptor connectionViewAndElementDescriptor = this.request.getConnectionViewAndElementDescriptor();
        if (connectionViewAndElementDescriptor != null) {
            CreateElementRequestAdapter createElementRequestAdapter = connectionViewAndElementDescriptor.getCreateElementRequestAdapter();
            message = (Message)createElementRequestAdapter.getAdapter(Message.class);
        }
        return message;
    }

    private void retrievePreferences() {
        this.type = null;
        IPreferenceStore store = UMLDiagramEditorPlugin.getInstance().getPreferenceStore();
        if (this.request.getConnectionViewAndElementDescriptor().getSemanticHint().equals(UMLDIElementTypes.MESSAGE_ASYNCH_EDGE.getSemanticHint())) {
            this.preference = store.getString(CustomDiagramGeneralPreferencePage.PREF_EXECUTION_SPECIFICATION_ASYNC_MSG);
        }
        if (this.request.getConnectionViewAndElementDescriptor().getSemanticHint().equals(UMLDIElementTypes.MESSAGE_SYNCH_EDGE.getSemanticHint())) {
            this.preference = store.getString(CustomDiagramGeneralPreferencePage.PREF_EXECUTION_SPECIFICATION_SYNC_MSG);
        }
        if ("CHOICE_BEHAVIOR".equals(this.preference) || "CHOICE_BEHAVIOR_AND_REPLY".equals(this.preference)) {
            this.type = UMLDIElementTypes.BEHAVIOR_EXECUTION_SPECIFICATION_SHAPE;
        }
        if ("CHOICE_ACTION".equals(this.preference) || "CHOICE_ACTION_AND_REPLY".equals(this.preference)) {
            this.type = UMLDIElementTypes.ACTION_EXECUTION_SPECIFICATION_SHAPE;
        }
        if ("CHOICE_BEHAVIOR_AND_REPLY".equals(this.preference) || "CHOICE_ACTION_AND_REPLY".equals(this.preference)) {
            this.createReply = true;
        }
    }

    private Stream<Object> getAllCommands(Object parent) {
        Object command = null;
        command = parent instanceof ICommandProxy ? ((ICommandProxy)parent).getICommand() : parent;
        if (command instanceof CompoundCommand) {
            return ((CompoundCommand)command).getCommands().stream().flatMap(childNode -> this.getAllCommands(childNode));
        }
        if (command instanceof CompositeCommand) {
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(((CompositeCommand)command).iterator(), 16), false).flatMap(childNode -> this.getAllCommands(childNode));
        }
        return Stream.of(command);
    }

    private <T> T getCreatedElement(Command command, Class<T> type) {
        Object element = null;
        try {
            SemanticCreateCommand semanticCreateCommand = this.getAllCommands(command).filter(SemanticCreateCommand.class::isInstance).map(SemanticCreateCommand.class::cast).findFirst().get();
            CommandResult commandResult = semanticCreateCommand.getCommandResult();
            if (commandResult != null && commandResult.getReturnValue() instanceof CreateElementRequestAdapter) {
                element = ((CreateElementRequestAdapter)commandResult.getReturnValue()).getAdapter(type);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return (T)element;
    }
}

