/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.tcp;

import java.nio.ByteBuffer;
import java.text.MessageFormat;
import org.eclipse.internal.net4j.buffer.BufferUtil;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.buffer.IBuffer;
import org.eclipse.net4j.channel.ChannelException;
import org.eclipse.net4j.channel.IChannelMultiplexer;
import org.eclipse.net4j.connector.ConnectorException;
import org.eclipse.net4j.internal.tcp.TCPConnector;
import org.eclipse.net4j.internal.tcp.bundle.OM;
import org.eclipse.net4j.internal.tcp.messages.Messages;
import org.eclipse.net4j.protocol.IProtocol;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;
import org.eclipse.net4j.util.concurrent.ISynchronizer;
import org.eclipse.net4j.util.concurrent.SynchronizingCorrelator;
import org.eclipse.net4j.util.concurrent.TimeoutRuntimeException;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.spi.net4j.Channel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlChannel
extends Channel {
    public static final short CONTROL_CHANNEL_INDEX = 0;
    public static final byte OPCODE_NEGOTIATION = 1;
    @Deprecated
    public static final byte OPCODE_REGISTRATION = 2;
    public static final byte OPCODE_REGISTRATION_ACK = 3;
    public static final byte OPCODE_DEREGISTRATION = 4;
    public static final byte OPCODE_REGISTRATION_VERSIONED = 5;
    private static final String SUCCESS = "Success";
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, ControlChannel.class);
    private SynchronizingCorrelator<Short, String> acknowledgements = new SynchronizingCorrelator();

    public ControlChannel(TCPConnector connector) {
        this.setID((short)0);
        this.setMultiplexer((IChannelMultiplexer)connector);
        this.setUserID(connector.getUserID());
    }

    public TCPConnector getConnector() {
        return (TCPConnector)this.getMultiplexer();
    }

    public void registerChannel(short channelID, long timeout, IProtocol<?> protocol) {
        if (TRACER.isEnabled()) {
            TRACER.format("Registering channel {0} with protocol {1}", new Object[]{channelID, protocol});
        }
        this.assertValidChannelID(channelID);
        ISynchronizer acknowledgement = this.acknowledgements.correlate((Object)channelID);
        int protocolVersion = Net4jUtil.getProtocolVersion(protocol);
        String protocolID = Net4jUtil.getProtocolID(protocol);
        IBuffer buffer = this.provideBuffer();
        ByteBuffer byteBuffer = buffer.startPutting((short)0);
        byteBuffer.put((byte)5);
        byteBuffer.putShort(channelID);
        byteBuffer.putInt(protocolVersion);
        BufferUtil.putString((ByteBuffer)byteBuffer, (String)protocolID, (boolean)false);
        this.handleBuffer(buffer);
        String error = (String)acknowledgement.get(timeout);
        if (error == null) {
            throw new TimeoutRuntimeException(MessageFormat.format(Messages.getString("ControlChannel_0"), timeout));
        }
        if (error != SUCCESS) {
            throw new ChannelException("Failed to register channel with peer: " + error);
        }
    }

    public void deregisterChannel(short channelID) {
        if (TRACER.isEnabled()) {
            TRACER.format("Deregistering channel {0}", new Object[]{channelID});
        }
        this.assertValidChannelID(channelID);
        IBuffer buffer = this.provideBuffer();
        ByteBuffer byteBuffer = buffer.startPutting((short)0);
        byteBuffer.put((byte)4);
        byteBuffer.putShort(channelID);
        this.handleBuffer(buffer);
    }

    /*
     * Unable to fully structure code
     */
    public void handleBufferFromMultiplexer(IBuffer buffer) {
        try {
            opcode = buffer.get();
            switch (opcode) {
                case 1: {
                    this.assertNegotiating();
                    negotiationContext = this.getConnector().getNegotiationContext();
                    while (negotiationContext == null) {
                        ConcurrencyUtil.sleep((long)20L);
                        negotiationContext = this.getConnector().getNegotiationContext();
                    }
                    receiver = negotiationContext.getReceiver();
                    receiver.receiveBuffer(negotiationContext, buffer.getByteBuffer());
                    break;
                }
                case 2: {
                    OM.LOG.error("Deprecated opcode: Client should use newer Net4j version");
                    this.getConnector().deactivate();
                    break;
                }
                case 5: {
                    this.assertConnected();
                    channelID = buffer.getShort();
                    this.assertValidChannelID(channelID);
                    error = null;
                    try {
                        protocolVersion = buffer.getInt();
                        protocolID = buffer.getString();
                        channel = this.getConnector().inverseOpenChannel(channelID, protocolID, protocolVersion);
                        if (channel == null) {
                            throw new ConnectorException(Messages.getString("ControlChannel_4"));
                        }
                    }
                    catch (Exception ex) {
                        error = ex.getMessage();
                        if (!ControlChannel.TRACER.isEnabled()) ** GOTO lbl35
                        ControlChannel.TRACER.trace("Problem during channel registration", (Throwable)ex);
                    }
lbl35:
                    // 3 sources

                    this.sendStatus((byte)3, channelID, error);
                    break;
                }
                case 4: {
                    this.assertConnected();
                    channelID = buffer.getShort();
                    if (channelID == 0) {
                        throw new ImplementationError();
                    }
                    try {
                        this.getConnector().inverseCloseChannel(channelID);
                    }
                    catch (Exception ex) {
                        if (ControlChannel.TRACER.isEnabled()) {
                            ControlChannel.TRACER.trace("Problem during channel deregistration", (Throwable)ex);
                        }
                        break;
                    }
                }
                case 3: {
                    this.assertConnected();
                    channelID = buffer.getShort();
                    error = buffer.getString();
                    if (error == null) {
                        error = "Success";
                    }
                    this.acknowledgements.put((Object)channelID, (Object)error);
                    break;
                }
                default: {
                    OM.LOG.error("Invalid opcode: " + opcode);
                    this.getConnector().deactivate();
                    break;
                }
            }
        }
        finally {
            buffer.release();
        }
    }

    public String toString() {
        return MessageFormat.format("Channel[Control, {0}]", this.getLocation());
    }

    protected void unregisterFromMultiplexer() {
    }

    private void sendStatus(byte opcode, short channelID, String error) {
        IBuffer buffer = this.provideBuffer();
        ByteBuffer byteBuffer = buffer.startPutting((short)0);
        byteBuffer.put(opcode);
        byteBuffer.putShort(channelID);
        BufferUtil.putString((ByteBuffer)byteBuffer, (String)error, (boolean)true);
        this.handleBuffer(buffer);
    }

    private void assertNegotiating() {
        if (!this.getConnector().isNegotiating()) {
            this.getConnector().deactivate();
            throw new IllegalStateException("Connector is not negotiating");
        }
    }

    private void assertConnected() {
        if (!this.getConnector().isConnected()) {
            throw new IllegalStateException("Connector is not connected");
        }
    }

    private void assertValidChannelID(short channelID) {
        if (channelID == 0) {
            throw new IllegalArgumentException("Bad channelID");
        }
    }
}

