/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.sourcelookup.IPersistableSourceLocator2;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.linuxtools.internal.valgrind.core.ValgrindError;
import org.eclipse.linuxtools.internal.valgrind.core.ValgrindStackFrame;
import org.eclipse.linuxtools.valgrind.core.IValgrindMessage;
import org.eclipse.linuxtools.valgrind.core.ValgrindParserUtils;

public class ValgrindCoreParser {
    private static final String AT = "at";
    private static final String BY = "by";
    private List<IValgrindMessage> messages;
    private int pid;
    private ILaunch launch;
    private ISourceLocator locator;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ValgrindCoreParser(File inputFile, ILaunch launch, ISourceLocator locator) throws IOException {
        this.launch = launch;
        this.locator = locator;
        Stack<IValgrindMessage> messageStack = new Stack<IValgrindMessage>();
        Stack<Integer> indentStack = new Stack<Integer>();
        this.messages = new ArrayList<IValgrindMessage>();
        Throwable throwable = null;
        Object var7_8 = null;
        try (BufferedReader br = new BufferedReader(new FileReader(inputFile));){
            this.pid = ValgrindParserUtils.parsePID(inputFile.getName(), "valgrind_");
            block5: while (true) {
                IValgrindMessage message;
                String line;
                if ((line = br.readLine()) == null) {
                    return;
                }
                line = line.replaceFirst("==([\\d:\\.]+\\s)?\\d+==|\\*\\*\\d+\\*\\*", "");
                int indent = 0;
                while (true) {
                    if (indent >= line.length() || line.charAt(indent) != ' ') {
                        if ((line = line.trim()).isEmpty()) continue block5;
                        if (indent != 1) break;
                        message = this.getMessage(null, line);
                        this.messages.add(message);
                        messageStack.clear();
                        messageStack.push(message);
                        indentStack.clear();
                        indentStack.push(indent);
                        continue block5;
                    }
                    ++indent;
                }
                if (indent <= 1) continue;
                if (indentStack.isEmpty()) {
                    message = this.getMessage(null, line);
                    this.messages.add(message);
                    messageStack.clear();
                    messageStack.push(message);
                    indentStack.clear();
                    indentStack.push(1);
                    continue;
                }
                while (true) {
                    if (indent > (Integer)indentStack.peek()) {
                        messageStack.push(this.getMessage((IValgrindMessage)messageStack.peek(), line));
                        indentStack.push(indent);
                        continue block5;
                    }
                    messageStack.pop();
                    indentStack.pop();
                }
                break;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    private IValgrindMessage getMessage(IValgrindMessage message, String line) {
        if (line.startsWith(AT) || line.startsWith(BY)) {
            Object[] parsed = ValgrindParserUtils.parseFilename(line);
            String filename = (String)parsed[0];
            int lineNo = (Integer)parsed[1];
            return new ValgrindStackFrame(message, line, this.launch, this.locator, filename, lineNo);
        }
        return new ValgrindError(message, line, this.launch, this.pid);
    }

    public IValgrindMessage[] getMessages() {
        return this.messages.toArray(new IValgrindMessage[this.messages.size()]);
    }

    public ValgrindCoreParser(File inputFile, ILaunch launch) throws IOException {
        this(inputFile, launch, ValgrindCoreParser.copyLaunchSourceLocator(launch));
    }

    public static ISourceLocator copyLaunchSourceLocator(ILaunch launch) {
        if (launch == null) {
            return null;
        }
        ISourceLocator sourceLocator = launch.getSourceLocator();
        ILaunchConfiguration launchConfiguration = launch.getLaunchConfiguration();
        if (sourceLocator instanceof ISourceLookupDirector) {
            try {
                ISourceLookupDirector director = (ISourceLookupDirector)sourceLocator;
                String id = director.getId();
                String memento = director.getMemento();
                IPersistableSourceLocator sourceLocatorCopy = DebugPlugin.getDefault().getLaunchManager().newSourceLocator(id);
                if (sourceLocatorCopy instanceof IPersistableSourceLocator2) {
                    ((IPersistableSourceLocator2)sourceLocatorCopy).initializeFromMemento(memento, launchConfiguration);
                } else {
                    sourceLocatorCopy.initializeFromMemento(memento);
                }
                return sourceLocatorCopy;
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return sourceLocator;
    }
}

