/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.parts.view;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.jwt.meta.model.core.GraphicalElement;
import org.eclipse.jwt.meta.model.core.PackageableElement;
import org.eclipse.jwt.we.editors.WEEditor;
import org.eclipse.jwt.we.misc.logging.Logger;
import org.eclipse.jwt.we.misc.util.GeneralHelper;
import org.eclipse.jwt.we.misc.views.Views;
import org.eclipse.jwt.we.model.view.Reference;
import org.eclipse.jwt.we.parts.core.GraphicalElementEditPartHelper;
import org.eclipse.jwt.we.parts.core.NodeModelElementEditPart;
import org.eclipse.jwt.we.parts.core.ReferenceableElementEditPart;
import org.eclipse.jwt.we.parts.core.ReferenceableElementProxyEditPart;
import org.eclipse.jwt.we.parts.processes.policies.DelegatingEditPolicy;
import org.eclipse.jwt.we.parts.view.policies.ReferenceGraphicalNodeEditPolicy;

public class ReferenceEditPart
extends NodeModelElementEditPart {
    Logger logger = Logger.getLogger(ReferenceEditPart.class);
    private final GraphicalElementEditPartHelper graphicalElementEditPartHelper = new GraphicalElementEditPartHelper(this);

    public Class getModelClass() {
        return Reference.class;
    }

    public PackageableElement getReference() {
        return ((Reference)this.getModel()).getReference();
    }

    public GraphicalElement getGraphicalElementModel() {
        return (GraphicalElement)super.getModel();
    }

    protected List getModelChildren() {
        if (this.getReference() == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.singletonList(this.getReference());
    }

    protected List getModelTargetConnections() {
        if (!Views.getInstance().displayObject((EObject)((EObject)this.getModel()).eClass())) {
            return null;
        }
        return ((Reference)this.getModel()).getReferenceEdges();
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new ReferenceGraphicalNodeEditPolicy());
        this.installEditPolicy("Delegating", (EditPolicy)new DelegatingEditPolicy());
    }

    protected ConnectionAnchor createConnectionAnchor() {
        return new ChopboxAnchor(this.getFigure());
    }

    public void performRequest(Request request) {
        if (request.getType() == "direct edit") {
            Iterator children = this.getChildren().iterator();
            while (children.hasNext()) {
                ((EditPart)children.next()).performRequest(request);
            }
        } else {
            super.performRequest(request);
        }
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        this.graphicalElementEditPartHelper.notifyChanged(notification);
        int featureId = notification.getFeatureID(Reference.class);
        switch (notification.getEventType()) {
            case 1: 
            case 2: {
                switch (featureId) {
                    case 2: {
                        this.refreshChildren();
                    }
                }
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                switch (featureId) {
                    case 3: {
                        this.refreshTargetConnections();
                    }
                }
            }
        }
    }

    protected void addChild(EditPart child, int index) {
        super.addChild((EditPart)new ReferenceableElementProxyEditPart((ReferenceableElementEditPart)child), index);
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.graphicalElementEditPartHelper.refreshVisuals();
    }

    public WEEditor getWEEditor() {
        if (this.weeditor == null) {
            this.weeditor = GeneralHelper.getInstanceForEObject((EObject)this.getReference());
        }
        return this.weeditor;
    }
}

