/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.editors.model;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.jwt.we.Plugin;
import org.eclipse.jwt.we.misc.extensions.ExtensionsHelper;
import org.eclipse.jwt.we.misc.logging.Logger;
import org.eclipse.ui.WorkbenchException;

public class RootAdapterFactoryExtensionPoint {
    public static final String EXTENSION_POINT = String.valueOf(Plugin.getId()) + "editorRootAdapterFactory";
    private static final String CLASS = "class";
    private static Logger log = Logger.getLogger(RootAdapterFactoryExtensionPoint.class);
    private static ComposedAdapterFactory.Descriptor rootAdapterFactoryDescriptor = null;
    private static boolean initialized = false;

    private static synchronized void init() {
        if (!initialized) {
            try {
                RootAdapterFactoryExtensionPoint.processExtensionPoint();
            }
            catch (WorkbenchException workbenchException) {
                log.severe("Error processing extension point for custom RootAdapterFactory");
            }
            initialized = true;
        }
    }

    public static AdapterFactory getAdapterFactory() {
        RootAdapterFactoryExtensionPoint.init();
        return rootAdapterFactoryDescriptor.createAdapterFactory();
    }

    private static void processExtensionPoint() throws WorkbenchException {
        log.debug("Processing extension point " + EXTENSION_POINT);
        IConfigurationElement[] confElements = ExtensionsHelper.findConfigurationElements(EXTENSION_POINT);
        if (confElements != null && confElements.length == 1) {
            Object factory;
            IConfigurationElement confElement = confElements[0];
            try {
                factory = confElement.createExecutableExtension(CLASS);
            }
            catch (CoreException e) {
                log.severe("JWT Extension at " + EXTENSION_POINT + " - error while instanciating AdapterFactoryDescriptor", e);
                return;
            }
            if (factory instanceof ComposedAdapterFactory.Descriptor) {
                rootAdapterFactoryDescriptor = (ComposedAdapterFactory.Descriptor)factory;
                log.info("JWT Extension at " + EXTENSION_POINT + " - found custom AdapterFactoryDescriptor : " + rootAdapterFactoryDescriptor);
            } else {
                log.warning("JWT Extension at " + EXTENSION_POINT + " - " + factory + " is not a AdapterFactoryDescriptor");
            }
        } else {
            log.warning("JWT Extension at " + EXTENSION_POINT + " - found no custom AdapterFactoryDescriptor");
        }
    }
}

