/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.editors.actions.handlers;

import java.io.File;
import java.util.Iterator;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.jwt.we.Plugin;
import org.eclipse.jwt.we.PluginProperties;
import org.eclipse.jwt.we.editors.WEEditor;
import org.eclipse.jwt.we.editors.actions.WEActionHandler;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class OpenFileHandler
extends WEActionHandler {
    public OpenFileHandler() {
        super(false);
    }

    public static String openFilePathDialog(Shell shell, String fileExtensionFilter, int style) {
        FileDialog fileDialog = new FileDialog(shell, style);
        if (fileExtensionFilter == null) {
            fileExtensionFilter = "*." + WEEditor.getWorkflowExtension() + ";*.agilpro;*.conf;*.view";
        }
        fileDialog.setFilterExtensions(new String[]{fileExtensionFilter});
        fileDialog.setFilterNames(new String[]{PluginProperties.wizards_Files_files});
        fileDialog.open();
        if (fileDialog.getFileName() != null && fileDialog.getFileName().length() > 0) {
            return String.valueOf(fileDialog.getFilterPath()) + File.separator + fileDialog.getFileName();
        }
        return null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        LoadResourceAction.LoadResourceDialog loadResourceDialog;
        String commandName = "";
        try {
            commandName = event.getCommand().getName();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (commandName.equals(PluginProperties.menu_Open_item)) {
            String filePath = OpenFileHandler.openFilePathDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), null, 4096);
            if (filePath != null) {
                Plugin.openEditor(HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getWorkbench(), URI.createFileURI((String)filePath));
            }
        } else if (commandName.equals(PluginProperties.menu_OpenUri_item) && (loadResourceDialog = new LoadResourceAction.LoadResourceDialog(HandlerUtil.getActiveShell((ExecutionEvent)event))).open() == 0) {
            Iterator i = loadResourceDialog.getURIs().iterator();
            while (i.hasNext()) {
                Plugin.openEditor(HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getWorkbench(), (URI)i.next());
            }
        }
        return null;
    }
}

