/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.activestatedebugger;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.IExternalSourceModule;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.tcl.activestatedebugger.InstrumentationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstrumentationSetup {
    final IEnvironment environment;
    protected final Map<IPath, Entry> entries = new HashMap<IPath, Entry>();
    protected final Entry root = new Entry((IPath)Path.ROOT, null);

    public InstrumentationSetup(IEnvironment environment) {
        this.environment = environment;
    }

    public void addWorkspace(IPath path, boolean isDirectory, boolean include) {
        IResource resource = InstrumentationUtils.getWorkspaceRoot().findMember(path);
        if (resource != null) {
            URI uri = resource.getLocationURI();
            IFileHandle file = this.environment.getFile(uri);
            this.addFileHandle(file, isDirectory, include);
        }
    }

    public void addExternal(IPath path, boolean isDirectory, boolean include) {
        this.addFileHandle(this.environment.getFile(EnvironmentPathUtils.getLocalPath((IPath)path)), isDirectory, include);
    }

    protected void addFileHandle(IFileHandle file, boolean isDirectory, boolean include) {
        if (file != null) {
            IPath path = file.getPath();
            Entry entry = this.entries.get(path);
            if (entry != null) {
                entry.leaf = include;
                if (include) {
                    entry.include = true;
                } else {
                    entry.exclude = true;
                }
                return;
            }
            entry = new Entry(path, file);
            entry.leaf = include;
            this.entries.put(path, entry);
            entry.directory = isDirectory;
            if (include) {
                entry.include = true;
            } else {
                entry.exclude = true;
            }
            while (true) {
                if ((file = file.getParent()) == null) {
                    this.root.children.put(entry.getPath(), entry);
                    break;
                }
                path = file.getPath();
                Entry dirEntry = this.entries.get(path);
                if (dirEntry == null) {
                    dirEntry = new Entry(path, file);
                    this.entries.put(path, dirEntry);
                }
                dirEntry.children.put(entry.getPath(), entry);
                dirEntry.directory = true;
                if (include) {
                    dirEntry.include = true;
                } else {
                    dirEntry.exclude = true;
                }
                entry = dirEntry;
            }
        }
    }

    private static void walk(Entry entry, List<PatternEntry> patterns) {
        if (entry.fileHandle == null || entry.leaf == null) {
            for (Entry e : entry.children.values()) {
                InstrumentationSetup.walk(e, patterns);
            }
        } else if (entry.include && entry.exclude) {
            IFileHandle[] children = entry.fileHandle.getChildren();
            if (children != null) {
                IFileHandle[] iFileHandleArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IFileHandle child = iFileHandleArray[n2];
                    IPath path = child.getPath();
                    Entry childEntry = entry.children.get(path);
                    if (childEntry == null) {
                        patterns.add(new PatternEntry(path, child.isDirectory(), entry.leaf));
                    } else {
                        InstrumentationSetup.walk(childEntry, patterns);
                    }
                    ++n2;
                }
            }
        } else if (entry.exclude) {
            patterns.add(new PatternEntry(entry.getPath(), entry.directory, false));
        } else if (entry.include) {
            patterns.add(new PatternEntry(entry.getPath(), entry.directory, true));
        }
    }

    public IPath[] getExcludes() {
        ArrayList<PatternEntry> patterns = new ArrayList<PatternEntry>();
        InstrumentationSetup.walk(this.root, patterns);
        Collections.sort(patterns, InstrumentationSetup.createPatternEntryComparator());
        ArrayList<IPath> result = new ArrayList<IPath>();
        for (PatternEntry entry : patterns) {
            if (entry.include) continue;
            result.add(entry.path);
        }
        return result.toArray(new IPath[result.size()]);
    }

    public IPath[] getIncludes() {
        ArrayList<PatternEntry> patterns = new ArrayList<PatternEntry>();
        InstrumentationSetup.walk(this.root, patterns);
        Collections.sort(patterns, InstrumentationSetup.createPatternEntryComparator());
        ArrayList<IPath> result = new ArrayList<IPath>();
        for (PatternEntry entry : patterns) {
            if (!entry.include) continue;
            result.add(entry.path);
        }
        return result.toArray(new IPath[result.size()]);
    }

    private static Comparator<PatternEntry> createPatternEntryComparator() {
        return new Comparator<PatternEntry>(){

            @Override
            public int compare(PatternEntry o1, PatternEntry o2) {
                return o1.path.toString().compareTo(o2.path.toString());
            }
        };
    }

    public List<PatternEntry> getPatterns() {
        ArrayList<PatternEntry> patterns = new ArrayList<PatternEntry>();
        InstrumentationSetup.walk(this.root, patterns);
        Collections.sort(patterns, InstrumentationSetup.createPatternEntryComparator());
        return patterns;
    }

    public void addSourceModule(ISourceModule module, boolean include) {
        if (module instanceof IExternalSourceModule) {
            if (!module.isBuiltin()) {
                return;
            }
            this.addExternal(module.getPath(), false, include);
        } else {
            this.addWorkspace(module.getPath(), false, include);
        }
    }

    public void addScriptFolder(IScriptFolder folder, boolean include) {
        if (folder.isReadOnly()) {
            this.addExternal(folder.getPath(), true, include);
        } else {
            this.addWorkspace(folder.getPath(), true, include);
        }
    }

    public void addProjectFragment(IProjectFragment fragment, boolean include) {
        if (fragment.isExternal()) {
            if (fragment.isBuiltin()) {
                return;
            }
            this.addExternal(fragment.getPath(), true, include);
        } else {
            this.addWorkspace(fragment.getPath(), true, include);
        }
    }

    public void addProject(IScriptProject project, boolean include) {
        this.addWorkspace(project.getPath(), true, include);
    }

    protected static class Entry {
        final IPath path;
        final IFileHandle fileHandle;
        boolean include;
        boolean exclude;
        Boolean leaf;
        public final Map<IPath, Entry> children = new HashMap<IPath, Entry>();
        public boolean directory;

        public Entry(IPath path, IFileHandle fileHandle) {
            this.path = path;
            this.fileHandle = fileHandle;
        }

        public IPath getPath() {
            return this.path;
        }

        public String toString() {
            return String.valueOf(this.path.toString()) + (this.include ? "[include]" : "") + (this.exclude ? "[exclude]" : "");
        }
    }

    public static class PatternEntry {
        private final IPath path;
        private final boolean directory;
        private final boolean include;

        public PatternEntry(IPath path, boolean directory, boolean include) {
            this.path = path;
            this.directory = directory;
            this.include = include;
        }

        public boolean isInclude() {
            return this.include;
        }

        public String getPatternText() {
            return this.directory ? String.valueOf(this.path.toString()) + "/*" : this.path.toString();
        }

        public String toString() {
            return String.valueOf(this.include ? "+" : "-") + this.getPatternText();
        }
    }
}

