/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.ui.launcher;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.debug.ui.messages.ScriptLaunchMessages;
import org.eclipse.dltk.internal.launching.DLTKLaunchingPlugin;
import org.eclipse.dltk.launching.LaunchingMessages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public abstract class AbstractScriptLaunchShortcut
implements ILaunchShortcut {
    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            this.searchAndLaunch(((IStructuredSelection)selection).toArray(), mode, this.getScriptSelectionTitle(), this.getSelectionEmptyMessage());
        }
    }

    public void searchAndLaunch(Object[] search, String mode, String selectMessage, String emptyMessage) {
        IResource[] scripts = null;
        try {
            scripts = this.findScripts(search, (IRunnableContext)PlatformUI.getWorkbench().getProgressService());
        }
        catch (InterruptedException e) {
            return;
        }
        catch (CoreException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)LaunchingMessages.ScriptLaunchShortcut_0, (String)e.getMessage());
            return;
        }
        IResource script = null;
        if (scripts.length == 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)LaunchingMessages.ScriptLaunchShortcut_1, (String)emptyMessage);
        } else {
            script = scripts.length > 1 ? this.chooseScript(scripts, selectMessage) : scripts[0];
        }
        if (script != null) {
            this.launch(script, mode);
        }
    }

    protected IResource chooseScript(IResource[] scripts, String title) {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider());
        dialog.setElements((Object[])scripts);
        dialog.setMessage(LaunchingMessages.ScriptLaunchShortcut_Choose_a_main_script_to_launch);
        dialog.setTitle(title);
        if (dialog.open() == 0) {
            return (IResource)dialog.getResult()[0];
        }
        return null;
    }

    protected void reportErorr(CoreException exception) {
        MessageDialog.openError((Shell)this.getShell(), (String)LaunchingMessages.ScriptLaunchShortcut_3, (String)exception.getStatus().getMessage());
    }

    public void launch(IEditorPart editor, String mode) {
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput == null) {
            return;
        }
        IFile script = ((IFileEditorInput)editorInput).getFile();
        if (script != null) {
            this.launch((IResource)script, mode);
        }
    }

    protected void launch(IResource script, String mode) {
        ILaunchConfiguration config = this.findLaunchConfiguration(script, this.getConfigurationType());
        if (config != null) {
            DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
        }
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected abstract ILaunchConfigurationType getConfigurationType();

    protected ILaunchConfiguration findLaunchConfiguration(IResource script, ILaunchConfigurationType configType) {
        List<ILaunchConfiguration> candidateConfigs = Collections.emptyList();
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(configType);
            candidateConfigs = new ArrayList(configs.length);
            int i = 0;
            while (i < configs.length) {
                ILaunchConfiguration config = configs[i];
                if (config.getAttribute("mainScript", "").equals(script.getProjectRelativePath().toString()) && config.getAttribute("project", "").equals(script.getProject().getName())) {
                    candidateConfigs.add(config);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            DLTKLaunchingPlugin.log((Throwable)e);
        }
        int candidateCount = candidateConfigs.size();
        if (candidateCount < 1) {
            return this.createConfiguration(script);
        }
        if (candidateCount == 1) {
            return (ILaunchConfiguration)candidateConfigs.get(0);
        }
        ILaunchConfiguration config = this.chooseConfiguration(candidateConfigs);
        if (config != null) {
            return config;
        }
        return null;
    }

    protected abstract String getNatureId();

    protected ILaunchConfiguration createConfiguration(IResource script) {
        ILaunchConfiguration config = null;
        ILaunchConfigurationWorkingCopy wc = null;
        try {
            ILaunchConfigurationType configType = this.getConfigurationType();
            wc = configType.newInstance(null, this.getLaunchManager().generateLaunchConfigurationName(script.getName()));
            wc.setAttribute("nature", this.getNatureId());
            wc.setAttribute("project", script.getProject().getName());
            wc.setAttribute("mainScript", script.getProjectRelativePath().toPortableString());
            wc.setAttribute("process_factory_id", "org.eclipse.dltk.launching.scriptProcessFactory");
            wc.setMappedResources(new IResource[]{script});
            config = wc.doSave();
        }
        catch (CoreException exception) {
            exception.printStackTrace();
        }
        return config;
    }

    protected Shell getShell() {
        return DLTKDebugUIPlugin.getActiveWorkbenchShell();
    }

    protected ILaunchConfiguration chooseConfiguration(List<ILaunchConfiguration> configList) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle(ScriptLaunchMessages.scriptLaunchShortcut2_title);
        dialog.setMessage(ScriptLaunchMessages.scriptLaunchShortcut2);
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    private IResource[] getScriptResources(Object[] objects, IProgressMonitor pm) {
        ArrayList<Object> list = new ArrayList<Object>(objects.length);
        int i = 0;
        while (i < objects.length) {
            Object object = objects[i];
            try {
                int j;
                IResource[] res;
                IFile f;
                if (object instanceof IFile) {
                    f = (IFile)object;
                    if (!f.getName().startsWith(".")) {
                        list.add(f);
                    }
                } else if (object instanceof IContainer) {
                    f = (IContainer)object;
                    Object[] mem = f.members();
                    res = this.getScriptResources(mem, pm);
                    j = 0;
                    while (j < res.length) {
                        list.add(res[j]);
                        ++j;
                    }
                } else if (object instanceof IModelElement) {
                    IResource res2;
                    IModelElement elem = (IModelElement)object;
                    if (elem instanceof ISourceModule) {
                        res2 = ((ISourceModule)elem).getCorrespondingResource();
                        if (res2 != null) {
                            list.add(res2);
                        }
                    } else if (elem instanceof IType) {
                        res2 = ((IType)elem).getUnderlyingResource();
                        if (res2 != null) {
                            list.add(res2);
                        }
                    } else if (elem instanceof IMethod) {
                        res2 = ((IMethod)elem).getUnderlyingResource();
                        if (res2 != null) {
                            list.add(res2);
                        }
                    } else if (elem instanceof IParent) {
                        IParent proj = (IParent)elem;
                        res = this.getScriptResources(proj.getChildren(), pm);
                        j = 0;
                        while (j < res.length) {
                            list.add(res[j]);
                            ++j;
                        }
                    }
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            ++i;
        }
        return list.toArray(new IResource[list.size()]);
    }

    protected IResource[] findScripts(Object[] elements, IRunnableContext context) throws InterruptedException, CoreException {
        try {
            IResource[][] res = new IResource[1][];
            IRunnableWithProgress runnable = pm -> {
                pm.beginTask(LaunchingMessages.LaunchShortcut_searchingForScripts, 1);
                iResourceArray[0] = this.getScriptResources(elements, pm);
                pm.done();
            };
            context.run(true, true, runnable);
            return res[0];
        }
        catch (InvocationTargetException e) {
            throw (CoreException)e.getTargetException();
        }
    }

    protected String getScriptSelectionTitle() {
        return LaunchingMessages.LaunchShortcut_selectScriptToLaunch;
    }

    protected String getSelectionEmptyMessage() {
        return LaunchingMessages.LaunchShortcut_selectionContainsNoScript;
    }
}

