/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.dltk.debug.core.IHotCodeReplaceListener;
import org.eclipse.dltk.debug.core.model.IScriptDebugTarget;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.internal.debug.ui.HotCodeReplaceErrorDialog;
import org.eclipse.dltk.internal.debug.ui.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ScriptHotCodeReplaceListener
implements IHotCodeReplaceListener {
    public void hotCodeReplaceSucceeded(IScriptDebugTarget target) {
    }

    public void hotCodeReplaceFailed(IScriptDebugTarget target, DebugException exception) {
        String alertMessage;
        String preference;
        Status status;
        if (exception != null && !DLTKDebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.dltk.debug.ui.alert_hot_code_replace_failed") || exception == null && !DLTKDebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.dltk.debug.ui.alert_hot_code_replace_not_supported")) {
            return;
        }
        Display display = DLTKDebugUIPlugin.getStandardDisplay();
        if (display.isDisposed()) {
            return;
        }
        String launchName = target.getLaunch().getLaunchConfiguration().getName();
        if (exception == null) {
            status = new Status(2, DLTKDebugUIPlugin.getUniqueIdentifier(), 2, Messages.ScriptHotCodeReplaceListener_theTargetDoesntSupportHotCodeReplace, null);
            preference = "org.eclipse.dltk.debug.ui.alert_hot_code_replace_not_supported";
            alertMessage = Messages.ScriptHotCodeReplaceListener_doNotShowErrorWhenHotCodeReplaceIsNotSupported;
        } else {
            status = new Status(2, DLTKDebugUIPlugin.getUniqueIdentifier(), 2, exception.getMessage(), exception.getCause());
            preference = "org.eclipse.dltk.debug.ui.alert_hot_code_replace_failed";
            alertMessage = Messages.ScriptHotCodeReplaceListener_doNotShowErrorWhenHotCodeReplaceFails;
        }
        String title = Messages.ScriptHotCodeReplaceListener_hotCodeReplaceFailed;
        String message = NLS.bind((String)Messages.ScriptHotCodeReplaceListener_someCodeChangesCannotBeHotSwappedIntoARunningInterpreter, (Object)launchName);
        display.asyncExec(() -> ScriptHotCodeReplaceListener.lambda$0(display, title, message, (IStatus)status, preference, alertMessage, target));
    }

    private static /* synthetic */ void lambda$0(Display display, String string, String string2, IStatus iStatus, String string3, String string4, IScriptDebugTarget iScriptDebugTarget) {
        if (display.isDisposed()) {
            return;
        }
        Shell shell = DLTKDebugUIPlugin.getActiveWorkbenchShell();
        HotCodeReplaceErrorDialog dialog = new HotCodeReplaceErrorDialog(shell, string, string2, iStatus, string3, string4, DLTKDebugUIPlugin.getDefault().getPreferenceStore(), (IDebugTarget)iScriptDebugTarget);
        dialog.setBlockOnOpen(false);
        dialog.open();
    }
}

