/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.msft.internal.sqlserver.models;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.datatools.connectivity.sqm.core.definition.DataModelElementFactory;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.jdbc.JDBCTable;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.enablement.msft.internal.sqlserver.loaders.SQLCatalogUtils;
import org.eclipse.datatools.enablement.msft.internal.sqlserver.models.SQLServerTrigger;
import org.eclipse.datatools.enablement.msft.internal.sqlserver.models.SqlServerSchema;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.statements.SQLStatement;
import org.eclipse.datatools.modelbase.sql.statements.SQLStatementDefault;
import org.eclipse.datatools.modelbase.sql.statements.SQLStatementsPackage;
import org.eclipse.datatools.modelbase.sql.tables.SQLTablesPackage;
import org.eclipse.emf.common.util.EList;

public class SQLServer2000JdbcTable
extends JDBCTable {
    private Boolean tableTypeIdStatusLoaded = Boolean.FALSE;
    private int id;
    protected boolean triggerLoaded = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getId() {
        Boolean bl = this.tableTypeIdStatusLoaded;
        synchronized (bl) {
            if (!this.tableTypeIdStatusLoaded.booleanValue()) {
                this.loadTableIdStat();
            }
        }
        return this.id;
    }

    private synchronized void loadTableIdStat() {
        block6: {
            Connection conn = this.getConnection();
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String oldCatalog = null;
            try {
                try {
                    oldCatalog = conn.getCatalog();
                    conn.setCatalog(this.getSchema().getCatalog().getName());
                    stmt = conn.prepareStatement("SELECT o.id, o.type FROM dbo.sysobjects AS o, dbo.sysusers AS u WHERE o.uid = u.uid AND u.name = ? AND o.name = ? AND (o.type = 'U' OR o.type = 'S')");
                    stmt.setString(1, this.getSchema().getName());
                    stmt.setString(2, this.getName());
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        this.id = rs.getInt(1);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    SQLCatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                SQLCatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                throw throwable;
            }
            SQLCatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
        }
        this.tableTypeIdStatusLoaded = Boolean.TRUE;
    }

    private Schema getSchema(String schemaName) {
        Schema s2 = this.getSchema();
        if (s2.getName().equals(schemaName)) {
            return s2;
        }
        Database d = s2.getCatalog().getDatabase();
        for (Schema s2 : d.getSchemas()) {
            if (!s2.getName().equals(schemaName)) continue;
            return s2;
        }
        SqlServerSchema schema = new SqlServerSchema();
        schema.setName(schemaName);
        schema.setCatalog(s2.getCatalog());
        schema.setDatabase(d);
        return schema;
    }

    protected synchronized void loadTriggers() {
        if (this.triggerLoaded) {
            return;
        }
        EList triggerList = super.getTriggers();
        Object[] list = triggerList.toArray();
        this.clearTriggers(triggerList);
        Connection connection = this.getConnection();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            DataModelElementFactory factory = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase()).getDataModelElementFactory();
            PreparedStatement s = connection.prepareStatement("execute sp_helptrigger ?");
            s.setString(1, this.getName());
            ResultSet r = s.executeQuery();
            while (r.next()) {
                SQLServerTrigger trigger;
                String trigName = r.getString("trigger_name");
                Object element = this.findTrigger(list, trigName);
                if (element != null) {
                    trigger = (SQLServerTrigger)((Object)element);
                    ((ICatalogObject)element).refresh();
                } else {
                    trigger = new SQLServerTrigger();
                }
                trigger.setConnection(connection);
                trigger.setName(trigName);
                trigger.setSchema(this.getSchema());
                trigger.setInsertType(r.getInt("isinsert") == 1);
                trigger.setUpdateType(r.getInt("isupdate") == 1);
                trigger.setDeleteType(r.getInt("isdelete") == 1);
                String text = this.executeQuery(connection, trigName);
                SQLStatement body = (SQLStatement)factory.create(SQLStatementsPackage.eINSTANCE.getSQLStatementDefault());
                ((SQLStatementDefault)body).setSQL(text);
                trigger.getActionStatement().add((Object)body);
                triggerList.add((Object)trigger);
            }
            this.triggerLoaded = true;
            r.close();
            s.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    protected void clearTriggers(EList triggerList) {
        for (SQLServerTrigger trigger : triggerList) {
            trigger.getActionStatement().clear();
            trigger.setSchema(null);
        }
        triggerList.clear();
    }

    public EList getTriggers() {
        if (!this.triggerLoaded) {
            this.loadTriggers();
        }
        return this.triggers;
    }

    protected Object findTrigger(Object[] list, String name) {
        Object object = null;
        int i = 0;
        while (i < list.length) {
            SQLObject sqlObject = (SQLObject)list[i];
            if (sqlObject.getName().equals(name) && sqlObject.eClass() == SQLTablesPackage.eINSTANCE.getTrigger()) {
                object = list[i];
                break;
            }
            ++i;
        }
        return object;
    }

    private String executeQuery(Connection connection, String name) {
        try {
            PreparedStatement stmt = connection.prepareStatement("execute sp_helptext ?");
            stmt.setString(1, name);
            ResultSet r = stmt.executeQuery();
            StringBuffer statement = new StringBuffer();
            while (r.next()) {
                statement.append(r.getString(1));
            }
            return statement.toString();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }
}

