/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.common.ui;

import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.bpel.common.ui.ColorUtils;
import org.eclipse.bpel.common.ui.ICommonUIConstants;
import org.eclipse.bpel.common.ui.ImageUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class CommonUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.bpel.common.ui";
    private static CommonUIPlugin plugin;
    private ColorRegistry colorRegistry;
    private ImageRegistry imageRegistry;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static CommonUIPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public synchronized ImageRegistry getImageRegistry() {
        if (this.imageRegistry == null) {
            this.imageRegistry = super.getImageRegistry();
            this.initializeImages(Display.getCurrent());
        }
        return this.imageRegistry;
    }

    public synchronized ColorRegistry getColorRegistry() {
        if (this.colorRegistry == null) {
            this.colorRegistry = new ColorRegistry();
            this.registerColors(Display.getCurrent());
        }
        return this.colorRegistry;
    }

    private void createImageDescriptor(String id, URL baseURL) {
        URL url = null;
        try {
            url = new URL(baseURL, "icons/" + id);
        }
        catch (MalformedURLException malformedURLException) {}
        ImageDescriptor desc = ImageDescriptor.createFromURL(url);
        this.getImageRegistry().put(id, desc);
    }

    private void initializeImages(Display display) {
        URL baseURL = this.getBundle().getEntry("/");
        Field[] fields = ICommonUIConstants.class.getFields();
        int i = 0;
        while (i < fields.length) {
            String name;
            Field f = fields[i];
            if (f.getType() == String.class && ((name = f.getName()).startsWith("ICON_") || name.startsWith("CURSOR_"))) {
                try {
                    String value = (String)f.get(null);
                    this.createImageDescriptor(value, baseURL);
                }
                catch (Exception e) {
                    CommonUIPlugin.log(e);
                }
            }
            ++i;
        }
        ImageRegistry registry = this.getImageRegistry();
        ImageDescriptor desc = registry.getDescriptor("obj/tray_expand.png");
        registry.remove("collapseTray");
        registry.remove("expandTray");
        registry.put("collapseTray", desc.createImage());
        ImageData data = ImageUtils.flip(desc.getImageData());
        registry.put("expandTray", new Image((Device)display, data));
    }

    private void registerColors(Display display) {
        RGB light = display.getSystemColor(22).getRGB();
        RGB dark = ColorUtils.getShadeRGB(light, -0.09019605f);
        RGB shadow = ColorUtils.getShadeRGB(light, -0.2f);
        RGB scrollBtn = ColorUtils.getShadeRGB(light, -0.1921568f);
        ColorRegistry registry = this.getColorRegistry();
        registry.put("light_background", light);
        registry.put("dark_background", dark);
        registry.put("dark_shadow", shadow);
        registry.put("tool_selected_1", light);
        registry.put("tool_selected_2", dark);
        registry.put("scroll_button", scrollBtn);
        registry.put("tool_selected_border", display.getSystemColor(25).getRGB());
        RGB canvas = display.getSystemColor(25).getRGB();
        registry.put("canvas", canvas);
        registry.put("text", display.getSystemColor(24).getRGB());
        registry.put("trayBackground", ColorUtils.getLightShade(light, 2, 3));
        Color selectionColor = Display.getCurrent().getSystemColor(26);
        this.colorRegistry.put("selectionHandlerCorner", ColorUtils.getLightShade(selectionColor.getRGB(), 2, 3));
    }

    public IStatus createErrorStatus(String message, Exception e, boolean writeToLog) {
        Status status = new Status(4, PLUGIN_ID, 0, message, (Throwable)e);
        if (writeToLog) {
            plugin.getLog().log((IStatus)status);
        }
        return status;
    }

    public static void log(Exception e, int severity) {
        String m;
        Object status = null;
        status = e instanceof CoreException ? ((CoreException)((Object)e)).getStatus() : new Status(severity, PLUGIN_ID, 0, (m = e.getMessage()) == null ? "<no message>" : m, (Throwable)e);
        System.out.println(String.valueOf(e.getClass().getName()) + ": " + status);
        CommonUIPlugin.getDefault().getLog().log(status);
    }

    public static void log(Exception e) {
        CommonUIPlugin.log(e, 4);
    }

    public static IConfigurationElement[] getConfigurationElements(String extensionPointId) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, extensionPointId);
        if (extensionPoint == null) {
            return new IConfigurationElement[0];
        }
        return extensionPoint.getConfigurationElements();
    }
}

