/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sparqlbuilder.graphpattern;

import java.util.function.Consumer;
import org.eclipse.rdf4j.sparqlbuilder.constraint.Expression;
import org.eclipse.rdf4j.sparqlbuilder.constraint.Values;
import org.eclipse.rdf4j.sparqlbuilder.core.QueryElement;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.GraphName;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.GraphPatterns;

public interface GraphPattern
extends QueryElement {
    default public GraphPattern and(GraphPattern ... patterns) {
        return GraphPatterns.and(this).and(patterns);
    }

    default public GraphPattern values(Consumer<Values.VariablesBuilder> valuesConfigurer) {
        Values.Builder valuesBuilder = (Values.Builder)Values.builder();
        valuesConfigurer.accept(valuesBuilder);
        return GraphPatterns.and(this).and(valuesBuilder.build());
    }

    default public GraphPattern union(GraphPattern ... patterns) {
        return GraphPatterns.union(this).union(patterns);
    }

    default public GraphPattern optional() {
        return this.optional(true);
    }

    default public GraphPattern optional(boolean isOptional) {
        return this.and(new GraphPattern[0]).optional(isOptional);
    }

    default public GraphPattern filter(Expression<?> constraint) {
        return this.and(new GraphPattern[0]).filter(constraint);
    }

    default public GraphPattern filterExists(GraphPattern ... patterns) {
        return this.filterExists(true, patterns);
    }

    default public GraphPattern filterNotExists(GraphPattern ... patterns) {
        return this.filterExists(false, patterns);
    }

    default public GraphPattern filterExists(boolean exists, GraphPattern ... patterns) {
        return this.and(GraphPatterns.filterExists(exists, patterns));
    }

    default public GraphPattern minus(GraphPattern ... patterns) {
        return this.and(GraphPatterns.minus(patterns));
    }

    default public GraphPattern from(GraphName name) {
        return this.and(new GraphPattern[0]).from(name);
    }

    default public boolean isEmpty() {
        return true;
    }
}

