/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.algebra;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import org.eclipse.rdf4j.common.order.AvailableStatementOrder;
import org.eclipse.rdf4j.federated.algebra.FedXTupleExpr;
import org.eclipse.rdf4j.federated.structures.QueryInfo;
import org.eclipse.rdf4j.federated.util.QueryAlgebraUtil;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.query.algebra.AbstractQueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Var;

public class PassThroughTupleExpr
extends AbstractQueryModelNode
implements FedXTupleExpr {
    private static final long serialVersionUID = 24797808099470499L;
    private final TupleExpr parsedQuery;
    private final TupleQueryResultHandler resultHandler;
    private boolean successfullyPassedThrough = false;

    public PassThroughTupleExpr(TupleExpr parsedQuery, TupleQueryResultHandler resultHandler) {
        this.parsedQuery = parsedQuery;
        this.resultHandler = resultHandler;
    }

    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
        this.parsedQuery.visit(visitor);
    }

    public void replaceChildNode(QueryModelNode current, QueryModelNode replacement) {
        throw new UnsupportedOperationException();
    }

    public TupleQueryResultHandler getResultHandler() {
        return this.resultHandler;
    }

    public TupleExpr getExpr() {
        return this.parsedQuery;
    }

    public boolean isPassedThrough() {
        return this.successfullyPassedThrough;
    }

    public void setPassedThrough(boolean flag) {
        this.successfullyPassedThrough = flag;
    }

    public Set<String> getBindingNames() {
        return this.parsedQuery.getBindingNames();
    }

    public Set<String> getAssuredBindingNames() {
        return this.parsedQuery.getAssuredBindingNames();
    }

    public PassThroughTupleExpr clone() {
        return new PassThroughTupleExpr(this.parsedQuery, this.resultHandler);
    }

    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        visitor.meetOther((QueryModelNode)this.parsedQuery);
    }

    @Override
    public List<String> getFreeVars() {
        return Lists.newArrayList(QueryAlgebraUtil.getFreeVars(this.parsedQuery));
    }

    @Override
    public QueryInfo getQueryInfo() {
        throw new UnsupportedOperationException("Not supported to retrieve query info on this marker node");
    }

    public Set<Var> getSupportedOrders(AvailableStatementOrder tripleSource) {
        return this.parsedQuery.getSupportedOrders(tripleSource);
    }

    public void setOrder(Var var) {
        this.parsedQuery.setOrder(var);
    }

    public Var getOrder() {
        return this.parsedQuery.getOrder();
    }
}

