/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ValidationSettings;
import org.eclipse.rdf4j.sail.shacl.ast.Cache;
import org.eclipse.rdf4j.sail.shacl.ast.PropertyShape;
import org.eclipse.rdf4j.sail.shacl.ast.Severity;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclProperties;
import org.eclipse.rdf4j.sail.shacl.ast.Shape;
import org.eclipse.rdf4j.sail.shacl.ast.SparqlFragment;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.ValidationApproach;
import org.eclipse.rdf4j.sail.shacl.ast.ValidationQuery;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.EmptyNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ShiftToPropertyShape;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Unique;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationReportNode;
import org.eclipse.rdf4j.sail.shacl.results.ValidationResult;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.RdfsSubClassOfReasoner;
import org.eclipse.rdf4j.sail.shacl.wrapper.shape.ShapeSource;

public class NodeShape
extends Shape {
    public NodeShape() {
    }

    public NodeShape(NodeShape nodeShape) {
        super(nodeShape);
    }

    public static NodeShape getInstance(ShaclProperties properties, ShapeSource shapeSource, Shape.ParseSettings parseSettings, Cache cache) {
        NodeShape shape = (NodeShape)cache.get(properties.getId());
        if (shape == null) {
            shape = new NodeShape();
            cache.put(properties.getId(), shape);
            shape.populate(properties, shapeSource, parseSettings, cache);
        }
        return shape;
    }

    @Override
    public void populate(ShaclProperties properties, ShapeSource connection, Shape.ParseSettings parseSettings, Cache cache) {
        super.populate(properties, connection, parseSettings, cache);
        if (properties.getMinCount() != null) {
            throw new IllegalStateException("NodeShapes do not support sh:MinCount in " + this.getId());
        }
        if (properties.getMaxCount() != null) {
            throw new IllegalStateException("NodeShapes do not support sh:MaxCount in " + this.getId());
        }
        if (properties.isUniqueLang()) {
            throw new IllegalStateException("NodeShapes do not support sh:uniqueLang in " + this.getId());
        }
        if (properties.getQualifiedValueShape() != null) {
            throw new IllegalStateException("NodeShapes do not support sh:qualifiedValueShape in " + this.getId());
        }
        this.constraintComponents = this.getConstraintComponents(properties, connection, parseSettings, cache);
    }

    @Override
    protected NodeShape shallowClone() {
        return new NodeShape(this);
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection) {
        super.toModel(subject, predicate, model, cycleDetection);
        model.add(this.getId(), RDF.TYPE, SHACL.NODE_SHAPE, new Resource[0]);
        if (subject != null) {
            if (predicate == null) {
                model.add(subject, SHACL.NODE, this.getId(), new Resource[0]);
            } else {
                model.add(subject, predicate, this.getId(), new Resource[0]);
            }
        }
        this.constraintComponents.forEach(c -> c.toModel(this.getId(), null, model, cycleDetection));
    }

    @Override
    public ValidationQuery generateSparqlValidationQuery(ConnectionsGroup connectionsGroup, ValidationSettings validationSettings, boolean negatePlan, boolean negateChildren, ConstraintComponent.Scope scope) {
        if (this.deactivated) {
            return ValidationQuery.Deactivated.getInstance();
        }
        ValidationQuery validationQuery = this.constraintComponents.stream().map(c -> {
            ValidationQuery validationQuery1 = c.generateSparqlValidationQuery(connectionsGroup, validationSettings, negatePlan, negateChildren, ConstraintComponent.Scope.nodeShape);
            if (!(c instanceof PropertyShape)) {
                return validationQuery1.withConstraintComponent((ConstraintComponent)c);
            }
            return validationQuery1;
        }).reduce((a, b) -> ValidationQuery.union(a, b, false)).orElseThrow(IllegalStateException::new);
        if (this.produceValidationReports) {
            assert (this.constraintComponents.size() == 1);
            assert (!(this.constraintComponents.get(0) instanceof PropertyShape));
            validationQuery = validationQuery.withShape(this);
            validationQuery = validationQuery.withSeverity(Severity.orDefault(this.severity));
            validationQuery.makeCurrentStateValidationReport();
        }
        if (scope == ConstraintComponent.Scope.propertyShape) {
            validationQuery.shiftToPropertyShape();
        }
        return validationQuery;
    }

    @Override
    public PlanNode generateTransactionalValidationPlan(ConnectionsGroup connectionsGroup, ValidationSettings validationSettings, PlanNodeProvider overrideTargetNode, ConstraintComponent.Scope scope) {
        if (this.isDeactivated()) {
            return EmptyNode.getInstance();
        }
        PlanNode union = EmptyNode.getInstance();
        for (ConstraintComponent constraintComponent : this.constraintComponents) {
            PlanNode validationPlanNode = constraintComponent.generateTransactionalValidationPlan(connectionsGroup, validationSettings, overrideTargetNode, ConstraintComponent.Scope.nodeShape);
            if (this.produceValidationReports) {
                assert (!(constraintComponent instanceof PropertyShape));
                assert (this.constraintComponents.size() == 1);
                validationPlanNode = new ValidationReportNode(validationPlanNode, t -> new ValidationResult(t.getActiveTarget(), t.getActiveTarget(), this, constraintComponent, this.getSeverity(), t.getScope(), t.getContexts(), this.getContexts()), connectionsGroup);
            }
            if (scope == ConstraintComponent.Scope.propertyShape) {
                validationPlanNode = Unique.getInstance(new ShiftToPropertyShape(validationPlanNode, connectionsGroup), true, connectionsGroup);
            }
            union = UnionNode.getInstance(connectionsGroup, union, validationPlanNode);
        }
        return union;
    }

    @Override
    public ValidationApproach getPreferredValidationApproach(ConnectionsGroup connectionsGroup) {
        return this.constraintComponents.stream().map(constraintComponent -> constraintComponent.getPreferredValidationApproach(connectionsGroup)).reduce(ValidationApproach::reducePreferred).orElse(ValidationApproach.Transactional);
    }

    @Override
    public SourceConstraintComponent getConstraintComponent() {
        return SourceConstraintComponent.NodeConstraintComponent;
    }

    @Override
    public PlanNode getAllTargetsPlan(ConnectionsGroup connectionsGroup, Resource[] dataGraph, ConstraintComponent.Scope scope, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider) {
        PlanNode planNode = this.constraintComponents.stream().map(c -> c.getAllTargetsPlan(connectionsGroup, dataGraph, ConstraintComponent.Scope.nodeShape, new StatementMatcher.StableRandomVariableProvider())).distinct().reduce((nodes, nodes2) -> UnionNode.getInstanceDedupe(connectionsGroup, nodes, nodes2)).orElse(EmptyNode.getInstance());
        if (connectionsGroup.getStats().hasRemoved()) {
            PlanNode planNodeEffectiveTarget = this.getTargetChain().getEffectiveTarget(ConstraintComponent.Scope.nodeShape, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider).getPlanNode(connectionsGroup, dataGraph, ConstraintComponent.Scope.nodeShape, true, null);
            planNode = UnionNode.getInstanceDedupe(connectionsGroup, planNode, planNodeEffectiveTarget);
        }
        if (scope == ConstraintComponent.Scope.propertyShape) {
            planNode = Unique.getInstance(new ShiftToPropertyShape(planNode, connectionsGroup), true, connectionsGroup);
        }
        planNode = Unique.getInstance(planNode, false, connectionsGroup);
        return planNode;
    }

    @Override
    public ConstraintComponent deepClone() {
        NodeShape nodeShape = new NodeShape(this);
        nodeShape.constraintComponents = this.constraintComponents.stream().map(ConstraintComponent::deepClone).collect(Collectors.toList());
        return nodeShape;
    }

    @Override
    public SparqlFragment buildSparqlValidNodes_rsx_targetShape(StatementMatcher.Variable<Value> subject, StatementMatcher.Variable<Value> object, RdfsSubClassOfReasoner rdfsSubClassOfReasoner, ConstraintComponent.Scope scope, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider) {
        List<SparqlFragment> sparqlFragments = this.constraintComponents.stream().map(shape -> shape.buildSparqlValidNodes_rsx_targetShape(subject, object, rdfsSubClassOfReasoner, ConstraintComponent.Scope.nodeShape, stableRandomVariableProvider)).collect(Collectors.toList());
        if (SparqlFragment.isFilterCondition(sparqlFragments)) {
            return SparqlFragment.and(sparqlFragments);
        }
        return SparqlFragment.join(sparqlFragments);
    }
}

