/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.manager;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.http.client.HttpClient;
import org.eclipse.rdf4j.http.client.RDF4JProtocolSession;
import org.eclipse.rdf4j.http.client.SharedHttpClientSessionManager;
import org.eclipse.rdf4j.http.protocol.Protocol;
import org.eclipse.rdf4j.http.protocol.UnauthorizedException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.config.RepositoryConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.repository.config.RepositoryConfigUtil;
import org.eclipse.rdf4j.repository.http.HTTPRepository;
import org.eclipse.rdf4j.repository.manager.RepositoryInfo;
import org.eclipse.rdf4j.repository.manager.RepositoryManager;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;

public class RemoteRepositoryManager
extends RepositoryManager {
    private volatile SharedHttpClientSessionManager client;
    private final String serverURL;
    private String username;
    private String password;

    public static RemoteRepositoryManager getInstance(String serverURL) throws RepositoryException {
        RemoteRepositoryManager manager = new RemoteRepositoryManager(serverURL);
        manager.init();
        return manager;
    }

    public static RemoteRepositoryManager getInstance(String serverURL, String username, String password) throws RepositoryException {
        RemoteRepositoryManager manager = new RemoteRepositoryManager(serverURL);
        manager.setUsernameAndPassword(username, password);
        manager.init();
        return manager;
    }

    public RemoteRepositoryManager(String serverURL) {
        this.serverURL = serverURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SharedHttpClientSessionManager getSharedHttpClientSessionManager() {
        SharedHttpClientSessionManager result = this.client;
        if (result == null) {
            RemoteRepositoryManager remoteRepositoryManager = this;
            synchronized (remoteRepositoryManager) {
                result = this.client;
                if (result == null) {
                    result = this.client = new SharedHttpClientSessionManager();
                }
            }
        }
        return result;
    }

    @Override
    public HttpClient getHttpClient() {
        SharedHttpClientSessionManager nextClient = this.client;
        if (nextClient == null) {
            return null;
        }
        return nextClient.getHttpClient();
    }

    @Override
    public void setHttpClient(HttpClient protocolSession) {
        this.getSharedHttpClientSessionManager().setHttpClient(protocolSession);
    }

    @Override
    public void shutDown() {
        try {
            super.shutDown();
        }
        finally {
            SharedHttpClientSessionManager toCloseClient = this.client;
            this.client = null;
            if (toCloseClient != null) {
                toCloseClient.shutDown();
            }
        }
    }

    public void setUsernameAndPassword(String username, String password) {
        this.username = username;
        this.password = password;
    }

    @Override
    public URL getLocation() throws MalformedURLException {
        return new URL(this.serverURL);
    }

    public String getServerURL() {
        return this.serverURL;
    }

    @Override
    protected Repository createRepository(String id) throws RepositoryConfigException, RepositoryException {
        HTTPRepository result = null;
        if (this.hasRepositoryConfig(id)) {
            result = new HTTPRepository(this.serverURL, id);
            result.setHttpClientSessionManager(this.getSharedHttpClientSessionManager());
            result.setUsernameAndPassword(this.username, this.password);
            result.init();
        }
        return result;
    }

    @Override
    public RepositoryConfig getRepositoryConfig(String id) throws RepositoryException {
        Model model = this.getModelFactory().createEmptyModel();
        try (RDF4JProtocolSession protocolSession = this.getSharedHttpClientSessionManager().createRDF4JProtocolSession(this.serverURL);){
            protocolSession.setUsernameAndPassword(this.username, this.password);
            int serverProtocolVersion = Integer.parseInt(protocolSession.getServerProtocol());
            protocolSession.setRepository(Protocol.getRepositoryLocation(this.serverURL, id));
            protocolSession.getRepositoryConfig(new StatementCollector(model));
        }
        catch (IOException | UnauthorizedException | QueryEvaluationException ue) {
            throw new RepositoryException(ue);
        }
        return RepositoryConfigUtil.getRepositoryConfig(model, id);
    }

    @Override
    public Collection<RepositoryInfo> getAllRepositoryInfos() throws RepositoryException {
        ArrayList<RepositoryInfo> result = new ArrayList<RepositoryInfo>();
        try (RDF4JProtocolSession protocolSession = this.getSharedHttpClientSessionManager().createRDF4JProtocolSession(this.serverURL);){
            protocolSession.setUsernameAndPassword(this.username, this.password);
            try (TupleQueryResult responseFromServer = protocolSession.getRepositoryList();){
                while (responseFromServer.hasNext()) {
                    BindingSet bindingSet = (BindingSet)responseFromServer.next();
                    RepositoryInfo repInfo = new RepositoryInfo();
                    String id = Literals.getLabel(bindingSet.getValue("id"), null);
                    Value uri = bindingSet.getValue("uri");
                    String description = Literals.getLabel(bindingSet.getValue("title"), null);
                    boolean readable = Literals.getBooleanValue(bindingSet.getValue("readable"), false);
                    boolean writable = Literals.getBooleanValue(bindingSet.getValue("writable"), false);
                    if (uri instanceof IRI) {
                        try {
                            repInfo.setLocation(new URL(uri.toString()));
                        }
                        catch (MalformedURLException e) {
                            this.logger.warn("Server reported malformed repository URL: {}", (Object)uri);
                        }
                    }
                    repInfo.setId(id);
                    repInfo.setDescription(description);
                    repInfo.setReadable(readable);
                    repInfo.setWritable(writable);
                    result.add(repInfo);
                }
            }
        }
        catch (IOException | QueryEvaluationException ioe) {
            this.logger.warn("Unable to retrieve list of repositories", (Throwable)ioe);
            throw new RepositoryException(ioe);
        }
        catch (UnauthorizedException ue) {
            this.logger.warn("Not authorized to retrieve list of repositories", (Throwable)ue);
            throw new RepositoryException(ue);
        }
        catch (RepositoryException re) {
            this.logger.warn("Unable to retrieve list of repositories", (Throwable)re);
            throw re;
        }
        return result;
    }

    @Override
    public void addRepositoryConfig(RepositoryConfig config) throws RepositoryException, RepositoryConfigException {
        try (RDF4JProtocolSession protocolSession = this.getSharedHttpClientSessionManager().createRDF4JProtocolSession(this.serverURL);){
            protocolSession.setUsernameAndPassword(this.username, this.password);
            int serverProtocolVersion = Integer.parseInt(protocolSession.getServerProtocol());
            if (serverProtocolVersion < 9) {
                throw new RepositoryException("Remote Server RDF4J Protocol version not compatible with this version of RDF4J");
            }
            if (this.hasRepositoryConfig(config.getID())) {
                protocolSession.updateRepository(config);
            } else {
                protocolSession.createRepository(config);
            }
        }
        catch (IOException | NumberFormatException | UnauthorizedException | QueryEvaluationException e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    public boolean removeRepository(String repositoryID) throws RepositoryException, RepositoryConfigException {
        boolean existingRepo = this.hasRepositoryConfig(repositoryID);
        if (existingRepo) {
            try (RDF4JProtocolSession protocolSession = this.getSharedHttpClientSessionManager().createRDF4JProtocolSession(this.serverURL);){
                protocolSession.setUsernameAndPassword(this.username, this.password);
                protocolSession.deleteRepository(repositoryID);
            }
            catch (IOException e) {
                this.logger.warn("error while deleting remote repository", (Throwable)e);
                throw new RepositoryConfigException(e);
            }
        }
        return existingRepo;
    }
}

