/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.algebra;

import java.util.Set;
import org.eclipse.rdf4j.common.order.AvailableStatementOrder;
import org.eclipse.rdf4j.federated.algebra.QueryRef;
import org.eclipse.rdf4j.federated.endpoint.Endpoint;
import org.eclipse.rdf4j.federated.structures.QueryInfo;
import org.eclipse.rdf4j.query.algebra.AbstractQueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Var;

public class SingleSourceQuery
extends AbstractQueryModelNode
implements TupleExpr,
QueryRef {
    private static final long serialVersionUID = 5745172129911897271L;
    private final TupleExpr parsedQuery;
    private final transient Endpoint source;
    private final transient QueryInfo queryInfo;

    public SingleSourceQuery(TupleExpr parsedQuery, Endpoint source, QueryInfo queryInfo) {
        this.parsedQuery = parsedQuery;
        this.source = source;
        this.queryInfo = queryInfo;
    }

    public Endpoint getSource() {
        return this.source;
    }

    public String getQueryString() {
        return this.queryInfo.getQuery();
    }

    @Override
    public QueryInfo getQueryInfo() {
        return this.queryInfo;
    }

    @Override
    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        visitor.meetOther(this);
    }

    @Override
    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
        this.parsedQuery.visit(visitor);
    }

    @Override
    public void replaceChildNode(QueryModelNode current, QueryModelNode replacement) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSignature() {
        return super.getSignature() + " @" + this.source.getId();
    }

    @Override
    public Set<String> getBindingNames() {
        return this.parsedQuery.getBindingNames();
    }

    @Override
    public Set<String> getAssuredBindingNames() {
        return this.parsedQuery.getAssuredBindingNames();
    }

    @Override
    public SingleSourceQuery clone() {
        return (SingleSourceQuery)super.clone();
    }

    @Override
    public Set<Var> getSupportedOrders(AvailableStatementOrder tripleSource) {
        return this.parsedQuery.getSupportedOrders(tripleSource);
    }

    @Override
    public void setOrder(Var var) {
        this.parsedQuery.setOrder(var);
    }

    @Override
    public Var getOrder() {
        return this.parsedQuery.getOrder();
    }
}

