/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation.iterator;

import java.util.ArrayList;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;

public class IndependentJoingroupBindingsIteration
extends LookAheadIteration<BindingSet> {
    protected final BindingSet bindings;
    protected final CloseableIteration<BindingSet> iter;
    protected ArrayList<BindingSet> result = null;
    protected int currentIdx = 0;

    public IndependentJoingroupBindingsIteration(CloseableIteration<BindingSet> iter, BindingSet bindings) {
        this.bindings = bindings;
        this.iter = iter;
    }

    @Override
    protected BindingSet getNextElement() throws QueryEvaluationException {
        if (this.result == null) {
            this.result = this.computeResult();
        }
        if (this.currentIdx >= this.result.size()) {
            return null;
        }
        return this.result.get(this.currentIdx++);
    }

    protected ArrayList<BindingSet> computeResult() throws QueryEvaluationException {
        ArrayList<Binding> a_res = new ArrayList<Binding>();
        ArrayList<Binding> b_res = new ArrayList<Binding>();
        while (this.iter.hasNext()) {
            BindingSet bIn = (BindingSet)this.iter.next();
            if (bIn.size() != 1) {
                throw new RuntimeException("For this optimization a bindingset needs to have exactly one binding, it has " + bIn.size() + ": " + bIn);
            }
            Binding b = bIn.getBinding(bIn.getBindingNames().iterator().next());
            int bIndex = Integer.parseInt(b.getName().substring(b.getName().lastIndexOf(95) + 1));
            if (bIndex == 0) {
                a_res.add(b);
                continue;
            }
            if (bIndex == 1) {
                b_res.add(b);
                continue;
            }
            throw new RuntimeException("Unexpected binding value.");
        }
        ArrayList<BindingSet> res = new ArrayList<BindingSet>(a_res.size() * b_res.size());
        for (Binding a : a_res) {
            for (Binding b : b_res) {
                QueryBindingSet newB = new QueryBindingSet(this.bindings.size() + 2);
                newB.addAll(this.bindings);
                newB.addBinding(a.getName().substring(0, a.getName().lastIndexOf(95)), a.getValue());
                newB.addBinding(b.getName().substring(0, b.getName().lastIndexOf(95)), b.getValue());
                res.add(newB);
            }
        }
        return res;
    }

    @Override
    protected void handleClose() throws QueryEvaluationException {
        this.iter.close();
    }
}

