/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lmdb;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.StampedLock;
import org.apache.commons.io.FileUtils;
import org.eclipse.rdf4j.sail.lmdb.LmdbUtil;
import org.eclipse.rdf4j.sail.lmdb.TxnManager;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.lmdb.LMDB;
import org.lwjgl.util.lmdb.MDBStat;
import org.lwjgl.util.lmdb.MDBVal;

class PersistentSet<T extends Serializable>
extends AbstractSet<T> {
    private final Path dbDir;
    private final long env;
    private final int dbi;
    private TxnManager txnManager;
    private long writeTxn;
    private PointerBuffer writeTxnPp = PointerBuffer.allocateDirect((int)1);
    private long mapSize = 0x100000L;
    private long pageSize;
    private int size;

    public PersistentSet(File cacheDir) throws IOException {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer pp = stack.mallocPointer(1);
            LmdbUtil.E(LMDB.mdb_env_create((PointerBuffer)pp));
            this.env = pp.get(0);
            this.txnManager = new TxnManager(this.env, TxnManager.Mode.ABORT);
            LmdbUtil.E(LMDB.mdb_env_set_maxdbs((long)this.env, (int)2));
            LmdbUtil.E(LMDB.mdb_env_set_mapsize((long)this.env, (long)this.mapSize));
            int flags = 0x250000;
            this.dbDir = Files.createTempDirectory(cacheDir.toPath(), "set", new FileAttribute[0]);
            LmdbUtil.E(LMDB.mdb_env_open((long)this.env, (CharSequence)this.dbDir.toAbsolutePath().toString(), (int)flags, (int)436));
            this.dbi = LmdbUtil.openDatabase(this.env, "elements", 262144, null);
            MDBStat stat = MDBStat.malloc((MemoryStack)stack);
            LmdbUtil.readTransaction(this.env, (stack2, txn) -> {
                LmdbUtil.E(LMDB.mdb_stat((long)txn, (int)this.dbi, (MDBStat)stat));
                this.pageSize = stat.ms_psize();
                return null;
            });
        }
    }

    public synchronized void close() throws IOException {
        if (this.writeTxn != 0L) {
            LMDB.mdb_txn_abort((long)this.writeTxn);
            this.writeTxn = 0L;
        }
        this.writeTxnPp.free();
        LMDB.mdb_env_close((long)this.env);
        FileUtils.deleteDirectory((File)this.dbDir.toFile());
    }

    protected synchronized void commit() throws IOException {
        if (this.writeTxn != 0L) {
            LmdbUtil.E(LMDB.mdb_txn_commit((long)this.writeTxn));
            this.writeTxn = 0L;
        }
    }

    @Override
    public synchronized void clear() {
        if (this.writeTxn != 0L) {
            LMDB.mdb_txn_abort((long)this.writeTxn);
            this.writeTxn = 0L;
        }
        try {
            LmdbUtil.E(LMDB.mdb_txn_begin((long)this.env, (long)0L, (int)0, (PointerBuffer)this.writeTxnPp));
            this.writeTxn = this.writeTxnPp.get(0);
            LMDB.mdb_drop((long)this.writeTxn, (int)this.dbi, (boolean)false);
            this.commit();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.size = 0;
    }

    @Override
    public Iterator<T> iterator() {
        try {
            this.commit();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new ElementIterator(this.dbi);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean add(T element) {
        try {
            return this.update(element, true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean remove(Object element) {
        try {
            return this.update(element, false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean update(Object element, boolean add) throws IOException {
        try (MemoryStack stack = MemoryStack.stackPush();){
            if (this.writeTxn == 0L) {
                LmdbUtil.E(LMDB.mdb_txn_begin((long)this.env, (long)0L, (int)0, (PointerBuffer)this.writeTxnPp));
                this.writeTxn = this.writeTxnPp.get(0);
            }
            if (LmdbUtil.requiresResize(this.mapSize, this.pageSize, this.writeTxn, 0L)) {
                StampedLock lock = this.txnManager.lock();
                long stamp = lock.writeLock();
                try {
                    this.txnManager.deactivate();
                    LmdbUtil.E(LMDB.mdb_txn_commit((long)this.writeTxn));
                    this.mapSize = LmdbUtil.autoGrowMapSize(this.mapSize, this.pageSize, 0L);
                    LmdbUtil.E(LMDB.mdb_env_set_mapsize((long)this.env, (long)this.mapSize));
                    LmdbUtil.E(LMDB.mdb_txn_begin((long)this.env, (long)0L, (int)0, (PointerBuffer)this.writeTxnPp));
                    this.writeTxn = this.writeTxnPp.get(0);
                }
                finally {
                    try {
                        this.txnManager.activate();
                    }
                    finally {
                        lock.unlockWrite(stamp);
                    }
                }
            }
            MDBVal keyVal = MDBVal.malloc((MemoryStack)stack);
            MDBVal dataVal = MDBVal.calloc((MemoryStack)stack);
            byte[] data = this.write((Serializable)element);
            ByteBuffer keyBuf = stack.malloc(data.length);
            keyBuf.put(data);
            keyBuf.flip();
            keyVal.mv_data(keyBuf);
            if (add) {
                if (LMDB.mdb_put((long)this.writeTxn, (int)this.dbi, (MDBVal)keyVal, (MDBVal)dataVal, (int)16) == 0) {
                    ++this.size;
                    boolean bl = true;
                    return bl;
                }
            } else if (LMDB.mdb_del((long)this.writeTxn, (int)this.dbi, (MDBVal)keyVal, (MDBVal)dataVal) == 0) {
                --this.size;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    protected byte[] write(T element) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeObject(element);
        out.close();
        return baos.toByteArray();
    }

    protected T read(ByteBuffer buffer) throws IOException {
        try {
            return (T)((Serializable)new ObjectInputStream(new ByteBufferBackedInputStream(buffer)).readObject());
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException(cnfe);
        }
    }

    public class ByteBufferBackedInputStream
    extends InputStream {
        final ByteBuffer buf;

        public ByteBufferBackedInputStream(ByteBuffer buf) {
            this.buf = buf;
        }

        @Override
        public int read() throws IOException {
            if (!this.buf.hasRemaining()) {
                return -1;
            }
            return this.buf.get() & 0xFF;
        }

        @Override
        public int read(byte[] bytes, int off, int len) throws IOException {
            if (!this.buf.hasRemaining()) {
                return -1;
            }
            len = Math.min(len, this.buf.remaining());
            this.buf.get(bytes, off, len);
            return len;
        }
    }

    protected class ElementIterator
    implements Iterator<T> {
        private final MDBVal keyData = MDBVal.malloc();
        private final MDBVal valueData = MDBVal.malloc();
        private final long cursor;
        private final StampedLock txnLock;
        private TxnManager.Txn txnRef;
        private long txnRefVersion;
        private T next;
        private T current;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ElementIterator(int dbi) {
            try {
                this.txnRef = PersistentSet.this.txnManager.createReadTxn();
                this.txnLock = this.txnRef.lock();
                long stamp = this.txnLock.readLock();
                try {
                    this.txnRefVersion = this.txnRef.version();
                    try (MemoryStack stack = MemoryStack.stackPush();){
                        PointerBuffer pp = stack.mallocPointer(1);
                        LmdbUtil.E(LMDB.mdb_cursor_open((long)this.txnRef.get(), (int)dbi, (PointerBuffer)pp));
                        this.cursor = pp.get(0);
                    }
                }
                finally {
                    this.txnLock.unlockRead(stamp);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.next == null && this.txnRef != null) {
                try {
                    this.next = this.computeNext();
                }
                catch (Exception e) {
                    this.next = null;
                }
                if (this.next == null) {
                    this.close();
                }
            }
            return this.next != null;
        }

        @Override
        public T next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.current = this.next;
            this.next = null;
            return this.current;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T computeNext() throws IOException {
            long stamp = this.txnLock.readLock();
            try {
                Object t;
                block13: {
                    if (this.txnRefVersion != this.txnRef.version()) {
                        LMDB.mdb_cursor_renew((long)this.txnRef.get(), (long)this.cursor);
                        MemoryStack stack = MemoryStack.stackPush();
                        this.keyData.mv_data(stack.bytes(PersistentSet.this.write(this.current)));
                        if (LMDB.mdb_cursor_get((long)this.cursor, (MDBVal)this.keyData, (MDBVal)this.valueData, (int)15) == 0 || LMDB.mdb_cursor_get((long)this.cursor, (MDBVal)this.keyData, (MDBVal)this.valueData, (int)17) != 0) break block13;
                        Object t2 = PersistentSet.this.read(this.keyData.mv_data());
                        return t2;
                        finally {
                            if (stack != null) {
                                stack.close();
                            }
                        }
                    }
                }
                if (LMDB.mdb_cursor_get((long)this.cursor, (MDBVal)this.keyData, (MDBVal)this.valueData, (int)8) == 0) {
                    t = PersistentSet.this.read(this.keyData.mv_data());
                    return t;
                }
                this.close();
                t = null;
                return t;
            }
            finally {
                this.txnLock.unlockRead(stamp);
            }
        }

        public void close() {
            if (this.txnRef != null) {
                this.keyData.close();
                this.valueData.close();
                long stamp = this.txnLock.readLock();
                try {
                    LMDB.mdb_cursor_close((long)this.cursor);
                    this.txnRef.close();
                    this.txnRef = null;
                }
                finally {
                    this.txnLock.unlockRead(stamp);
                }
            }
        }

        @Override
        public void remove() {
            PersistentSet.this.remove(this.current);
        }
    }
}

