/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.ntriples;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.io.input.BOMInputStream;
import org.eclipse.rdf4j.common.text.ASCIIUtil;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFParser;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.eclipse.rdf4j.rio.helpers.NTriplesUtil;
import org.eclipse.rdf4j.rio.ntriples.NTriplesParserSettings;

public class NTriplesParser
extends AbstractRDFParser {
    protected BufferedReader reader;
    protected char[] lineChars;
    protected int currentIndex;
    protected long lineNo;
    protected Resource subject;
    protected IRI predicate;
    protected Value object;

    public NTriplesParser() {
    }

    public NTriplesParser(ValueFactory valueFactory) {
        super(valueFactory);
    }

    @Override
    public RDFFormat getRDFFormat() {
        return RDFFormat.NTRIPLES;
    }

    @Override
    public synchronized void parse(InputStream in, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        if (in == null) {
            throw new IllegalArgumentException("Input stream can not be 'null'");
        }
        try {
            this.parse(new BufferedReader(new InputStreamReader((InputStream)new BOMInputStream(in, false), StandardCharsets.UTF_8)), baseURI);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void parse(Reader reader, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        this.clear();
        try {
            if (reader == null) {
                throw new IllegalArgumentException("Reader can not be 'null'");
            }
            if (this.rdfHandler != null) {
                this.rdfHandler.startRDF();
            }
            this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
            this.lineNo = 0L;
            this.reportLocation(this.lineNo, 1L);
            while (this.readLine()) {
                this.parseStatement();
            }
        }
        finally {
            this.clear();
        }
        if (this.rdfHandler != null) {
            this.rdfHandler.endRDF();
        }
    }

    protected void parseStatement() throws RDFParseException, RDFHandlerException {
        boolean ignoredAnError = false;
        try {
            this.skipWhitespace(false);
            if (!this.shouldParseLine()) {
                return;
            }
            this.parseSubject();
            this.skipWhitespace(true);
            this.parsePredicate();
            this.skipWhitespace(true);
            this.parseObject();
            this.skipWhitespace(true);
            this.assertLineTerminates();
        }
        catch (RDFParseException e) {
            if (!this.getParserConfig().get(NTriplesParserSettings.FAIL_ON_INVALID_LINES).booleanValue() || this.getParserConfig().isNonFatalError(NTriplesParserSettings.FAIL_ON_INVALID_LINES)) {
                this.reportError(e, NTriplesParserSettings.FAIL_ON_INVALID_LINES);
                ignoredAnError = true;
            }
            throw e;
        }
        this.handleStatement(ignoredAnError);
    }

    protected void skipWhitespace(boolean throwEOF) {
        while (this.currentIndex < this.lineChars.length && (this.lineChars[this.currentIndex] == ' ' || this.lineChars[this.currentIndex] == '\t')) {
            ++this.currentIndex;
        }
        if (this.currentIndex >= this.lineChars.length && throwEOF) {
            this.throwEOFException();
        }
    }

    protected boolean shouldParseLine() {
        if (this.currentIndex < this.lineChars.length - 1) {
            if (this.lineChars[this.currentIndex] != '#') {
                return true;
            }
            if (this.rdfHandler != null) {
                this.rdfHandler.handleComment(new String(this.lineChars, this.currentIndex + 1, this.lineChars.length - this.currentIndex - 1));
            }
        }
        return false;
    }

    protected void parseSubject() {
        if (this.lineChars[this.currentIndex] == '<') {
            this.subject = this.parseIRI();
        } else if (this.lineChars[this.currentIndex] == '_') {
            this.subject = this.parseNode();
        } else {
            throw new RDFParseException("Expected '<' or '_', found: " + new String(Character.toChars(this.lineChars[this.currentIndex])), this.lineNo, (long)this.lineChars[this.currentIndex]);
        }
    }

    protected void parsePredicate() {
        if (this.lineChars[this.currentIndex] != '<') {
            throw new RDFParseException("Expected '<', found: " + new String(Character.toChars(this.lineChars[this.currentIndex])), this.lineNo, (long)this.lineChars[this.currentIndex]);
        }
        this.predicate = this.parseIRI();
    }

    protected void parseObject() {
        if (this.lineChars[this.currentIndex] == '<') {
            this.object = this.parseIRI();
        } else if (this.lineChars[this.currentIndex] == '_') {
            this.object = this.parseNode();
        } else if (this.lineChars[this.currentIndex] == '\"') {
            this.parseLiteral();
        } else {
            throw new RDFParseException("Expected '<' or '_', found: " + new String(Character.toChars(this.lineChars[this.currentIndex])), this.lineNo, (long)this.lineChars[this.currentIndex]);
        }
    }

    protected void assertLineTerminates() throws RDFParseException {
        if (!NTriplesUtil.isDot(this.lineChars[this.currentIndex])) {
            if (this.lineChars[this.currentIndex] != '#') {
                this.reportFatalError("Content after '.' is not allowed");
            } else {
                return;
            }
        }
        if (this.lineChars.length - 1 > this.currentIndex) {
            ++this.currentIndex;
            this.skipWhitespace(false);
            if (this.currentIndex >= this.lineChars.length) {
                return;
            }
            if (this.lineChars[this.currentIndex] != ' ' && this.lineChars[this.currentIndex] != '\t' && this.lineChars[this.currentIndex] != '#') {
                throw new RDFParseException("line must end with '.'", this.lineNo, (long)this.currentIndex);
            }
        }
    }

    protected void handleStatement(boolean ignoredAnError) {
        if (this.rdfHandler != null && !ignoredAnError) {
            this.rdfHandler.handleStatement(this.valueFactory.createStatement(this.subject, this.predicate, this.object));
        }
        this.subject = null;
        this.predicate = null;
        this.object = null;
    }

    protected IRI parseIRI() {
        if (this.lineChars[this.currentIndex] != '<') {
            this.reportError("Supplied char should be a '<', is: " + new String(Character.toChars(this.lineChars[this.currentIndex])), NTriplesParserSettings.FAIL_ON_INVALID_LINES);
        }
        int startIndex = this.currentIndex + 1;
        this.moveToIRIEndIndex();
        IRI iri = this.createURI(new String(this.lineChars, startIndex, this.currentIndex - startIndex));
        ++this.currentIndex;
        return iri;
    }

    protected Resource parseNode() {
        if (this.lineChars[this.currentIndex] != '_') {
            this.reportError("Supplied char should be a '_', is: " + new String(Character.toChars(this.lineChars[this.currentIndex])), NTriplesParserSettings.FAIL_ON_INVALID_LINES);
        }
        int startIndex = this.currentIndex + 2;
        this.moveToBNodeEndIndex();
        return this.createNode(new String(this.lineChars, startIndex, this.currentIndex - startIndex));
    }

    private void parseLiteral() {
        String label = this.parseLabel();
        this.incrementIndexOrThrowEOF();
        if (this.currentIndex < this.lineChars.length - 1 && this.lineChars[this.currentIndex] == '^') {
            this.parseLiteralWithDatatype(label);
        } else if (this.lineChars[this.currentIndex] == '@') {
            this.parseLangLiteral(label);
        } else {
            this.object = this.createLiteral(label, null, (IRI)null, this.lineNo, (long)this.lineChars[this.currentIndex]);
        }
    }

    private String parseLabel() {
        int startIndex = this.currentIndex;
        this.incrementIndexOrThrowEOF();
        while (this.lineChars[this.currentIndex] != '\"') {
            if (this.lineChars[this.currentIndex] == '\\') {
                ++this.currentIndex;
            }
            this.incrementIndexOrThrowEOF();
        }
        try {
            return NTriplesUtil.unescapeString(new String(this.lineChars, startIndex + 1, this.currentIndex - startIndex - 1));
        }
        catch (IllegalArgumentException e) {
            throw new RDFParseException("Illegal unicode escape sequence", this.lineNo, -1L);
        }
    }

    private void parseLiteralWithDatatype(String label) {
        if (this.lineChars[this.currentIndex + 1] != '^') {
            this.reportError("Expected '^', found: " + new String(Character.toChars(this.lineChars[this.currentIndex + 1])), NTriplesParserSettings.FAIL_ON_INVALID_LINES);
        }
        this.currentIndex += 2;
        if (this.currentIndex >= this.lineChars.length || this.lineChars[this.currentIndex] != '<') {
            this.reportError("Expected '<', found: " + new String(Character.toChars(this.lineChars[this.currentIndex])), NTriplesParserSettings.FAIL_ON_INVALID_LINES);
        }
        this.object = this.createLiteral(label, null, this.parseIRI(), this.lineNo, (long)this.lineChars[this.currentIndex]);
    }

    private void parseLangLiteral(String label) {
        this.incrementIndexOrThrowEOF();
        if (!ASCIIUtil.isLetter(this.lineChars[this.currentIndex])) {
            this.reportError("Expected a letter, found: " + new String(Character.toChars(this.lineChars[this.currentIndex])), NTriplesParserSettings.FAIL_ON_INVALID_LINES);
        }
        int startIndex = this.currentIndex;
        while (this.currentIndex < this.lineChars.length && !NTriplesUtil.isDot(this.lineChars[this.currentIndex]) && this.lineChars[this.currentIndex] != '^' && this.lineChars[this.currentIndex] != ' ' && this.lineChars[this.currentIndex] != '\t') {
            ++this.currentIndex;
        }
        if (this.currentIndex >= this.lineChars.length) {
            this.throwEOFException();
        }
        this.object = this.createLiteral(label, new String(this.lineChars, startIndex, this.currentIndex - startIndex), (IRI)null, this.lineNo, (long)this.lineChars[this.currentIndex]);
    }

    private void moveToIRIEndIndex() throws RDFParseException {
        ++this.currentIndex;
        while (this.currentIndex < this.lineChars.length && this.lineChars[this.currentIndex] != '>') {
            if (this.lineChars[this.currentIndex] == ' ') {
                this.reportError("IRI included an unencoded space: " + new String(Character.toChars(this.lineChars[this.currentIndex])), BasicParserSettings.VERIFY_URI_SYNTAX);
            }
            if (this.lineChars[this.currentIndex] == '\\') {
                this.incrementIndexOrThrowEOF();
                if (this.lineChars[this.currentIndex] != 'u' && this.lineChars[this.currentIndex] != 'U') {
                    this.reportError("IRI includes string escapes: '\\" + this.lineChars[this.currentIndex] + "'", BasicParserSettings.VERIFY_URI_SYNTAX);
                }
            }
            ++this.currentIndex;
        }
        if (this.currentIndex >= this.lineChars.length) {
            this.throwEOFException();
        }
    }

    private void moveToBNodeEndIndex() throws RDFParseException {
        this.incrementIndexOrThrowEOF();
        if (this.lineChars[this.currentIndex] != ':') {
            this.reportError("Expected ':', found: " + new String(Character.toChars(this.lineChars[this.currentIndex])), NTriplesParserSettings.FAIL_ON_INVALID_LINES);
        }
        ++this.currentIndex;
        if (!ASCIIUtil.isLetterOrNumber(this.lineChars[this.currentIndex]) && !NTriplesUtil.isUnderscore(this.lineChars[this.currentIndex])) {
            this.reportError("Expected a letter or number or underscore, found: " + new String(Character.toChars(this.lineChars[this.currentIndex])), NTriplesParserSettings.FAIL_ON_INVALID_LINES);
        }
        while (this.currentIndex < this.lineChars.length && NTriplesUtil.isValidCharacterForBNodeLabel(this.lineChars[this.currentIndex]) && (!NTriplesUtil.isDot(this.lineChars[this.currentIndex]) || this.currentIndex + 1 < this.lineChars.length && NTriplesUtil.isValidCharacterForBNodeLabel(this.lineChars[this.currentIndex + 1]))) {
            ++this.currentIndex;
        }
        if (this.currentIndex == this.lineChars.length) {
            if (NTriplesUtil.isDot(this.lineChars[this.currentIndex - 1])) {
                --this.currentIndex;
            } else {
                this.throwEOFException();
            }
        }
    }

    private void incrementIndexOrThrowEOF() {
        ++this.currentIndex;
        if (this.currentIndex >= this.lineChars.length) {
            this.throwEOFException();
        }
    }

    private boolean readLine() throws IOException {
        String line = this.reader.readLine();
        if (line != null) {
            this.lineChars = line.toCharArray();
            ++this.lineNo;
            this.currentIndex = 0;
            this.reportLocation(this.lineNo, 1L);
            return true;
        }
        this.lineChars = null;
        this.currentIndex = -1;
        return false;
    }

    @Override
    protected IRI createURI(String uri) throws RDFParseException {
        try {
            uri = NTriplesUtil.unescapeString(uri);
        }
        catch (IllegalArgumentException e) {
            this.reportError(e.getMessage(), NTriplesParserSettings.FAIL_ON_INVALID_LINES);
        }
        return super.createURI(uri);
    }

    @Override
    protected void reportWarning(String msg) {
        this.reportWarning(msg, this.lineNo, -1L);
    }

    @Override
    protected void reportError(String msg, RioSetting<Boolean> setting) throws RDFParseException {
        this.reportError(msg, this.lineNo, -1L, setting);
    }

    @Override
    protected void reportError(Exception e, RioSetting<Boolean> setting) throws RDFParseException {
        this.reportError(e, this.lineNo, -1L, setting);
    }

    @Override
    protected void reportFatalError(String msg) throws RDFParseException {
        this.reportFatalError(msg, this.lineNo, -1L);
    }

    @Override
    protected void reportFatalError(Exception e) throws RDFParseException {
        this.reportFatalError(e, this.lineNo, -1L);
    }

    protected void throwEOFException() throws RDFParseException {
        throw new RDFParseException("Unexpected end of file");
    }

    @Override
    protected void clear() {
        this.currentIndex = -1;
        this.lineChars = null;
        super.clear();
    }

    @Override
    public Collection<RioSetting<?>> getSupportedSettings() {
        HashSet result = new HashSet(super.getSupportedSettings());
        result.add(NTriplesParserSettings.FAIL_ON_INVALID_LINES);
        return result;
    }
}

