/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValuesBackedNode
implements PlanNode {
    private static final Logger logger = LoggerFactory.getLogger(ValuesBackedNode.class);
    private final SortedSet<Value> values;
    private final List<ValidationTuple> tuples;
    private final ConstraintComponent.Scope scope;
    boolean printed = false;
    private ValidationExecutionLogger validationExecutionLogger;

    public ValuesBackedNode(SortedSet<Value> values, ConstraintComponent.Scope scope, Resource[] contexts) {
        this.tuples = values.stream().map(c -> new ValidationTuple((Value)c, scope, false, contexts)).collect(Collectors.toList());
        this.values = values;
        this.scope = scope;
    }

    @Override
    public CloseableIteration<? extends ValidationTuple> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            final Iterator<ValidationTuple> iterator;
            {
                this.iterator = ValuesBackedNode.this.tuples.iterator();
            }

            @Override
            protected void init() {
            }

            @Override
            public void localClose() {
            }

            @Override
            public boolean localHasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public ValidationTuple loggingNext() {
                return this.iterator.next();
            }
        };
    }

    @Override
    public int depth() {
        return 0;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
    }

    @Override
    public String getId() {
        return "" + System.identityHashCode(this);
    }

    public String toString() {
        return "ValuesBackedNode{values=" + this.values + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValuesBackedNode that = (ValuesBackedNode)o;
        return this.values.equals(that.values) && this.scope == that.scope;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.values, this.scope});
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
    }

    @Override
    public boolean producesSorted() {
        return true;
    }

    @Override
    public boolean requiresSorted() {
        return false;
    }
}

