/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.iterator;

import java.util.NoSuchElementException;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryEvaluationStep;

public class JoinIterator
extends LookAheadIteration<BindingSet> {
    private final CloseableIteration<BindingSet> leftIter;
    private CloseableIteration<BindingSet> rightIter;
    private final QueryEvaluationStep preparedRight;

    public JoinIterator(QueryEvaluationStep leftPrepared, QueryEvaluationStep rightPrepared, BindingSet bindings) throws QueryEvaluationException {
        this.leftIter = leftPrepared.evaluate(bindings);
        this.rightIter = new EmptyIteration();
        this.preparedRight = rightPrepared;
    }

    protected BindingSet getNextElement() throws QueryEvaluationException {
        try {
            while (this.rightIter.hasNext() || this.leftIter.hasNext()) {
                if (this.rightIter.hasNext()) {
                    return (BindingSet)this.rightIter.next();
                }
                this.rightIter.close();
                if (!this.leftIter.hasNext()) continue;
                this.rightIter = this.preparedRight.evaluate((BindingSet)this.leftIter.next());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return null;
    }

    protected void handleClose() throws QueryEvaluationException {
        try {
            super.handleClose();
        }
        finally {
            try {
                this.leftIter.close();
            }
            finally {
                this.rightIter.close();
            }
        }
    }
}

