/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.results.lazy;

import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.impl.BooleanLiteral;
import org.eclipse.rdf4j.model.impl.DynamicModel;
import org.eclipse.rdf4j.model.impl.DynamicModelFactory;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.DASH;
import org.eclipse.rdf4j.model.vocabulary.OWL;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDF4J;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.model.vocabulary.RSX;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.RioConfig;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.WriterConfig;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;
import org.eclipse.rdf4j.sail.shacl.results.ValidationReport;
import org.eclipse.rdf4j.sail.shacl.results.ValidationResult;
import org.eclipse.rdf4j.sail.shacl.results.lazy.ValidationResultIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InternalUseOnly
public class LazyValidationReport
extends ValidationReport {
    private static final Logger logger = LoggerFactory.getLogger(LazyValidationReport.class);
    private List<ValidationResultIterator> validationResultIterators;
    private final long limit;

    public LazyValidationReport(List<ValidationResultIterator> validationResultIterators, long limit) {
        this.validationResultIterators = validationResultIterators;
        this.limit = limit;
    }

    private void evaluateLazyAspect() {
        try {
            if (this.validationResultIterators != null) {
                long counter = 0L;
                for (ValidationResultIterator validationResultIterator : this.validationResultIterators) {
                    while (validationResultIterator.hasNext()) {
                        if (this.limit >= 0L && counter >= this.limit) {
                            this.truncated = true;
                            break;
                        }
                        ++counter;
                        this.validationResult.add(validationResultIterator.next());
                    }
                    this.conforms = this.conforms && validationResultIterator.conforms();
                    this.truncated = this.truncated || validationResultIterator.isTruncated();
                }
                this.validationResultIterators = null;
            }
        }
        catch (Exception e) {
            logger.warn("Error evaluating lazy validation report", (Throwable)e);
            throw e;
        }
    }

    @Override
    public Model asModel(Model model) {
        try {
            this.evaluateLazyAspect();
            model.add(this.getId(), SHACL.CONFORMS, Values.literal(this.conforms), new Resource[0]);
            model.add(this.getId(), RDF.TYPE, SHACL.VALIDATION_REPORT, new Resource[0]);
            model.add(this.getId(), RDF4J.TRUNCATED, BooleanLiteral.valueOf(this.truncated), new Resource[0]);
            HashSet<Resource> rdfListDedupe = new HashSet<Resource>();
            for (ValidationResult result : this.validationResult) {
                model.add(this.getId(), SHACL.RESULT, result.getId(), new Resource[0]);
                result.asModel(model, rdfListDedupe);
            }
            return model;
        }
        catch (Exception e) {
            logger.warn("Error converting validation report to model", (Throwable)e);
            throw e;
        }
    }

    @Override
    public Model asModel() {
        DynamicModel emptyModel = new DynamicModelFactory().createEmptyModel();
        emptyModel.setNamespace(SHACL.NS);
        emptyModel.setNamespace(RSX.NS);
        emptyModel.setNamespace(DASH.NS);
        emptyModel.setNamespace(RDF.NS);
        emptyModel.setNamespace(RDFS.NS);
        emptyModel.setNamespace(OWL.NS);
        emptyModel.setNamespace(XSD.NS);
        emptyModel.setNamespace(RDF4J.NS);
        return this.asModel(emptyModel);
    }

    @Override
    public boolean conforms() {
        this.evaluateLazyAspect();
        return this.conforms;
    }

    @Override
    public List<ValidationResult> getValidationResult() {
        this.evaluateLazyAspect();
        return this.validationResult;
    }

    @Override
    public String toString() {
        StringWriter stringWriter = new StringWriter();
        RioConfig writerConfig = ((WriterConfig)new WriterConfig().set((RioSetting)BasicWriterSettings.PRETTY_PRINT, (Object)true)).set((RioSetting)BasicWriterSettings.INLINE_BLANK_NODES, (Object)true);
        Rio.write((Iterable<Statement>)this.asModel(), (Writer)stringWriter, RDFFormat.TURTLE, (WriterConfig)writerConfig);
        return stringWriter.toString().replaceAll("(?m)^(@prefix)(.*)(\\.)$", "").trim();
    }

    @Override
    public boolean isTruncated() {
        this.evaluateLazyAspect();
        return this.truncated;
    }
}

