/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.helpers;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.common.concurrent.locks.Lock;
import org.eclipse.rdf4j.common.concurrent.locks.diagnostics.ConcurrentCleaner;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.common.transaction.IsolationLevel;
import org.eclipse.rdf4j.common.transaction.IsolationLevels;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.UnknownSailTransactionStateException;
import org.eclipse.rdf4j.sail.UpdateContext;
import org.eclipse.rdf4j.sail.helpers.AbstractSail;
import org.eclipse.rdf4j.sail.helpers.CleanerIteration;
import org.eclipse.rdf4j.sail.helpers.SailBaseIteration;
import org.eclipse.rdf4j.sail.helpers.TupleExprWrapperIteration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSailConnection
implements SailConnection {
    private static boolean assertsEnabled = false;
    private static final ConcurrentCleaner cleaner;
    private static final int BLOCK_SIZE = 1000;
    private static final Logger logger;
    private final boolean debugEnabled = AbstractSail.debugEnabled();
    private final AbstractSail sailBase;
    private volatile boolean txnActive;
    private volatile boolean txnPrepared;
    private final LongAdder blockClose = new LongAdder();
    private final LongAdder unblockClose = new LongAdder();
    private boolean isOpen = true;
    private static final VarHandle IS_OPEN;
    private Thread owner;
    @Deprecated(since="4.1.0")
    protected final ReentrantLock updateLock = new ReentrantLock();
    @Deprecated(since="4.1.0", forRemoval=true)
    protected final ReentrantReadWriteLock connectionLock = new ReentrantReadWriteLock();
    @InternalUseOnly
    protected boolean useConnectionLock = true;
    private final LongAdder iterationsOpened = new LongAdder();
    private final LongAdder iterationsClosed = new LongAdder();
    private final Map<SailBaseIteration<?, ?>, Throwable> activeIterationsDebug;
    private final Map<UpdateContext, Collection<Statement>> removed = new IdentityHashMap<UpdateContext, Collection<Statement>>(0);
    private final Map<UpdateContext, Collection<Statement>> added = new IdentityHashMap<UpdateContext, Collection<Statement>>(0);
    private static final BNode wildContext;
    private IsolationLevel transactionIsolationLevel;
    private volatile boolean statementsAdded;
    private volatile boolean statementsRemoved;

    public AbstractSailConnection(AbstractSail sailBase) {
        this.sailBase = sailBase;
        this.txnActive = false;
        this.activeIterationsDebug = this.debugEnabled ? new ConcurrentHashMap() : Collections.emptyMap();
        this.owner = Thread.currentThread();
    }

    @Override
    public final boolean isOpen() throws SailException {
        return IS_OPEN.getAcquire(this);
    }

    protected void verifyIsOpen() throws SailException {
        if (!IS_OPEN.getAcquire(this)) {
            throw new IllegalStateException("Connection has been closed");
        }
    }

    protected void verifyIsActive() throws SailException {
        if (!this.isActive()) {
            throw new SailException("No active transaction");
        }
    }

    @Override
    public void begin() throws SailException {
        this.begin(this.sailBase.getDefaultIsolationLevel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void begin(IsolationLevel isolationLevel) throws SailException {
        IsolationLevel compatibleLevel;
        if (isolationLevel == null) {
            isolationLevel = this.sailBase.getDefaultIsolationLevel();
        }
        if ((compatibleLevel = IsolationLevels.getCompatibleIsolationLevel(isolationLevel, this.sailBase.getSupportedIsolationLevels())) == null) {
            throw new UnknownSailTransactionStateException("Isolation level " + isolationLevel + " not compatible with this Sail");
        }
        this.transactionIsolationLevel = compatibleLevel;
        if (this.useConnectionLock) {
            this.connectionLock.readLock().lock();
        }
        this.blockClose.increment();
        try {
            this.verifyIsOpen();
            this.updateLock.lock();
            try {
                if (this.isActive()) {
                    throw new SailException("a transaction is already active on this connection.");
                }
                this.startTransactionInternal();
                this.txnActive = true;
            }
            finally {
                this.updateLock.unlock();
            }
        }
        finally {
            this.unblockClose.increment();
            if (this.useConnectionLock) {
                this.connectionLock.readLock().unlock();
            }
        }
        this.startUpdate(null);
    }

    protected IsolationLevel getTransactionIsolation() {
        return this.transactionIsolationLevel;
    }

    @Override
    public boolean isActive() throws UnknownSailTransactionStateException {
        return this.transactionActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws SailException {
        Thread deadlockPreventionThread = this.startDeadlockPreventionThread();
        if (!IS_OPEN.compareAndSet(this, true, false)) {
            return;
        }
        if (this.useConnectionLock) {
            this.connectionLock.writeLock().lock();
        }
        try {
            long sumBlocking;
            long sumDone;
            while ((sumDone = this.unblockClose.sum()) != (sumBlocking = this.blockClose.sum())) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new SailException("Connection was interrupted while waiting on active operations before it could be closed.");
                }
                LockSupport.parkNanos(Duration.ofMillis(10L).toNanos());
            }
            try {
                this.forceCloseActiveOperations();
                if (this.txnActive) {
                    logger.warn("Rolling back transaction due to connection close", this.debugEnabled ? new Throwable() : null);
                    try {
                        this.rollbackInternal();
                    }
                    finally {
                        this.txnActive = false;
                        this.txnPrepared = false;
                    }
                }
                this.closeInternal();
                if (this.isActiveOperation()) {
                    throw new SailException("Connection closed before all iterations were closed.");
                }
            }
            finally {
                this.sailBase.connectionClosed(this);
            }
        }
        finally {
            try {
                if (deadlockPreventionThread != null) {
                    deadlockPreventionThread.interrupt();
                }
            }
            finally {
                if (this.useConnectionLock) {
                    this.connectionLock.writeLock().unlock();
                }
            }
        }
    }

    private Thread startDeadlockPreventionThread() {
        Thread deadlockPreventionThread = null;
        if (Thread.currentThread() != this.owner) {
            if (logger.isInfoEnabled()) {
                logger.info("Closing connection from a different thread than the one that opened it. Connections should not be shared between threads. Opened by {} closed by {}", new Object[]{this.owner, Thread.currentThread(), new Throwable("Throwable used for stacktrace")});
            }
            deadlockPreventionThread = new Thread(() -> {
                try {
                    Thread.sleep(this.sailBase.connectionTimeOut / 2L);
                    this.owner.interrupt();
                    this.owner.join(1000L);
                    if (this.owner.isAlive()) {
                        logger.error("Interrupted thread {} but thread is still alive after 1000 ms!", (Object)this.owner);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            });
            deadlockPreventionThread.setDaemon(true);
            deadlockPreventionThread.start();
        }
        return deadlockPreventionThread;
    }

    @Override
    public final CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluate(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        this.flushPendingUpdates();
        if (this.useConnectionLock) {
            this.connectionLock.readLock().lock();
        }
        this.blockClose.increment();
        try {
            this.verifyIsOpen();
            CloseableIteration<? extends BindingSet, QueryEvaluationException> iteration = null;
            try {
                iteration = this.evaluateInternal(tupleExpr, dataset, bindings, includeInferred);
                if (assertsEnabled) {
                    iteration = new TupleExprWrapperIteration<BindingSet, QueryEvaluationException>(iteration, tupleExpr);
                }
                CloseableIteration<? extends BindingSet, QueryEvaluationException> closeableIteration = this.registerIteration(iteration);
                return closeableIteration;
            }
            catch (Throwable t) {
                if (iteration != null) {
                    iteration.close();
                }
                throw t;
            }
        }
        finally {
            this.unblockClose.increment();
            if (this.useConnectionLock) {
                this.connectionLock.readLock().unlock();
            }
        }
    }

    @Override
    public final CloseableIteration<? extends Resource, SailException> getContextIDs() throws SailException {
        this.flushPendingUpdates();
        if (this.useConnectionLock) {
            this.connectionLock.readLock().lock();
        }
        this.blockClose.increment();
        try {
            this.verifyIsOpen();
            CloseableIteration<? extends Resource, SailException> closeableIteration = this.registerIteration(this.getContextIDsInternal());
            return closeableIteration;
        }
        finally {
            this.unblockClose.increment();
            if (this.useConnectionLock) {
                this.connectionLock.readLock().unlock();
            }
        }
    }

    @Override
    public final CloseableIteration<? extends Statement, SailException> getStatements(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws SailException {
        this.flushPendingUpdates();
        if (this.useConnectionLock) {
            this.connectionLock.readLock().lock();
        }
        this.blockClose.increment();
        try {
            this.verifyIsOpen();
            CloseableIteration<? extends Statement, SailException> iteration = null;
            try {
                iteration = this.getStatementsInternal(subj, pred, obj, includeInferred, contexts);
                CloseableIteration<? extends Statement, SailException> closeableIteration = this.registerIteration(iteration);
                return closeableIteration;
            }
            catch (Throwable t) {
                if (iteration != null) {
                    iteration.close();
                }
                throw t;
            }
        }
        finally {
            this.unblockClose.increment();
            if (this.useConnectionLock) {
                this.connectionLock.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean hasStatement(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws SailException {
        this.flushPendingUpdates();
        if (this.useConnectionLock) {
            this.connectionLock.readLock().lock();
        }
        this.blockClose.increment();
        try {
            this.verifyIsOpen();
            boolean bl = this.hasStatementInternal(subj, pred, obj, includeInferred, contexts);
            return bl;
        }
        finally {
            this.unblockClose.increment();
            if (this.useConnectionLock) {
                this.connectionLock.readLock().unlock();
            }
        }
    }

    protected boolean hasStatementInternal(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource[] contexts) {
        try (CloseableIteration<? extends Statement, SailException> iteration = this.getStatementsInternal(subj, pred, obj, includeInferred, contexts);){
            boolean bl = iteration.hasNext();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long size(Resource ... contexts) throws SailException {
        this.flushPendingUpdates();
        if (this.useConnectionLock) {
            this.connectionLock.readLock().lock();
        }
        this.blockClose.increment();
        try {
            this.verifyIsOpen();
            long l = this.sizeInternal(contexts);
            return l;
        }
        finally {
            this.unblockClose.increment();
            if (this.useConnectionLock) {
                this.connectionLock.readLock().unlock();
            }
        }
    }

    protected final boolean transactionActive() {
        return this.txnActive;
    }

    @Deprecated(since="2.7.0")
    protected void autoStartTransaction() throws SailException {
        this.verifyIsActive();
    }

    @Override
    public void flush() throws SailException {
        if (this.isActive()) {
            this.endUpdate(null);
            this.startUpdate(null);
        }
    }

    @Override
    public final void prepare() throws SailException {
        if (this.isActive()) {
            this.endUpdate(null);
        }
        if (this.useConnectionLock) {
            this.connectionLock.readLock().lock();
        }
        this.blockClose.increment();
        try {
            this.verifyIsOpen();
            this.updateLock.lock();
            try {
                if (this.txnActive) {
                    this.prepareInternal();
                    this.txnPrepared = true;
                }
            }
            finally {
                this.updateLock.unlock();
            }
        }
        finally {
            this.unblockClose.increment();
            if (this.useConnectionLock) {
                this.connectionLock.readLock().unlock();
            }
        }
    }

    @Override
    public final void commit() throws SailException {
        if (this.isActive()) {
            this.endUpdate(null);
        }
        if (this.useConnectionLock) {
            this.connectionLock.readLock().lock();
        }
        this.blockClose.increment();
        try {
            this.verifyIsOpen();
            this.updateLock.lock();
            try {
                if (this.txnActive) {
                    if (!this.txnPrepared) {
                        this.prepareInternal();
                    }
                    this.commitInternal();
                    this.txnActive = false;
                    this.txnPrepared = false;
                }
            }
            finally {
                this.updateLock.unlock();
            }
        }
        finally {
            this.unblockClose.increment();
            if (this.useConnectionLock) {
                this.connectionLock.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void rollback() throws SailException {
        block18: {
            Map<UpdateContext, Collection<Statement>> map = this.added;
            synchronized (map) {
                this.added.clear();
            }
            map = this.removed;
            synchronized (map) {
                this.removed.clear();
            }
            if (this.useConnectionLock) {
                this.connectionLock.readLock().lock();
            }
            this.blockClose.increment();
            try {
                this.verifyIsOpen();
                this.updateLock.lock();
                try {
                    if (this.txnActive) {
                        try {
                            this.rollbackInternal();
                            break block18;
                        }
                        finally {
                            this.txnActive = false;
                            this.txnPrepared = false;
                        }
                    }
                    logger.warn("Cannot rollback transaction on connection because transaction is not active", this.debugEnabled ? new Throwable() : null);
                }
                finally {
                    this.updateLock.unlock();
                }
            }
            finally {
                this.unblockClose.increment();
                if (this.useConnectionLock) {
                    this.connectionLock.readLock().unlock();
                }
            }
        }
    }

    @Override
    public final void addStatement(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        if (this.pendingRemovals()) {
            this.flushPendingUpdates();
        }
        this.addStatement(null, subj, pred, obj, contexts);
        this.statementsAdded = true;
    }

    @Override
    public final void removeStatements(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        if (this.pendingAdds()) {
            this.flushPendingUpdates();
        }
        this.removeStatement(null, subj, pred, obj, contexts);
        this.statementsRemoved = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startUpdate(UpdateContext op) throws SailException {
        if (op != null) {
            this.flushPendingUpdates();
        }
        Map<UpdateContext, Collection<Statement>> map = this.removed;
        synchronized (map) {
            assert (!this.removed.containsKey(op));
            this.removed.put(op, new LinkedList());
        }
        map = this.added;
        synchronized (map) {
            assert (!this.added.containsKey(op));
            this.added.put(op, new LinkedList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStatement(UpdateContext op, Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        this.verifyIsOpen();
        this.verifyIsActive();
        Map<UpdateContext, Collection<Statement>> map = this.added;
        synchronized (map) {
            assert (this.added.containsKey(op));
            Collection<Statement> pending = this.added.get(op);
            if (contexts == null || contexts.length == 0) {
                pending.add(this.sailBase.getValueFactory().createStatement(subj, pred, obj));
            } else {
                for (Resource ctx : contexts) {
                    pending.add(this.sailBase.getValueFactory().createStatement(subj, pred, obj, ctx));
                }
            }
            if (pending.size() % 1000 == 0 && !this.isActiveOperation()) {
                this.endUpdate(op);
                this.startUpdate(op);
            }
        }
        this.statementsAdded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStatement(UpdateContext op, Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        this.verifyIsOpen();
        this.verifyIsActive();
        Map<UpdateContext, Collection<Statement>> map = this.removed;
        synchronized (map) {
            assert (this.removed.containsKey(op));
            Collection<Statement> pending = this.removed.get(op);
            if (contexts == null) {
                pending.add(new WildStatement(subj, pred, obj));
            } else if (contexts.length == 0) {
                pending.add(new WildStatement(subj, pred, obj, wildContext));
            } else {
                for (Resource ctx : contexts) {
                    pending.add(new WildStatement(subj, pred, obj, ctx));
                }
            }
            if (pending.size() % 1000 == 0 && !this.isActiveOperation()) {
                this.endUpdate(op);
                this.startUpdate(op);
            }
        }
        this.statementsRemoved = true;
    }

    @Override
    public final void endUpdate(UpdateContext op) throws SailException {
        if (this.useConnectionLock) {
            this.connectionLock.readLock().lock();
        }
        this.blockClose.increment();
        try {
            this.verifyIsOpen();
            this.updateLock.lock();
            try {
                this.verifyIsActive();
                this.endUpdateInternal(op);
            }
            finally {
                this.updateLock.unlock();
            }
        }
        finally {
            this.unblockClose.increment();
            if (this.useConnectionLock) {
                this.connectionLock.readLock().unlock();
            }
            if (op != null) {
                this.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endUpdateInternal(UpdateContext op) throws SailException {
        Collection<Statement> model;
        Object object = this.removed;
        synchronized (object) {
            model = this.removed.remove(op);
        }
        if (model != null) {
            for (Statement st : model) {
                Resource ctx = st.getContext();
                if (wildContext.equals(ctx)) {
                    this.removeStatementsInternal(st.getSubject(), st.getPredicate(), st.getObject(), new Resource[0]);
                    continue;
                }
                this.removeStatementsInternal(st.getSubject(), st.getPredicate(), st.getObject(), ctx);
            }
        }
        object = this.added;
        synchronized (object) {
            model = this.added.remove(op);
        }
        if (model != null) {
            for (Statement st : model) {
                this.addStatementInternal(st.getSubject(), st.getPredicate(), st.getObject(), st.getContext());
            }
        }
    }

    @Override
    public final void clear(Resource ... contexts) throws SailException {
        this.flushPendingUpdates();
        if (this.useConnectionLock) {
            this.connectionLock.readLock().lock();
        }
        this.blockClose.increment();
        try {
            this.verifyIsOpen();
            this.updateLock.lock();
            try {
                this.verifyIsActive();
                this.clearInternal(contexts);
                this.statementsRemoved = true;
            }
            finally {
                this.updateLock.unlock();
            }
        }
        finally {
            this.unblockClose.increment();
            if (this.useConnectionLock) {
                this.connectionLock.readLock().unlock();
            }
        }
    }

    @Override
    public final CloseableIteration<? extends Namespace, SailException> getNamespaces() throws SailException {
        if (this.useConnectionLock) {
            this.connectionLock.readLock().lock();
        }
        this.blockClose.increment();
        try {
            this.verifyIsOpen();
            CloseableIteration<? extends Namespace, SailException> closeableIteration = this.registerIteration(this.getNamespacesInternal());
            return closeableIteration;
        }
        finally {
            this.unblockClose.increment();
            if (this.useConnectionLock) {
                this.connectionLock.readLock().unlock();
            }
        }
    }

    @Override
    public final String getNamespace(String prefix) throws SailException {
        if (prefix == null) {
            throw new NullPointerException("prefix must not be null");
        }
        if (this.useConnectionLock) {
            this.connectionLock.readLock().lock();
        }
        this.blockClose.increment();
        try {
            this.verifyIsOpen();
            String string = this.getNamespaceInternal(prefix);
            return string;
        }
        finally {
            this.unblockClose.increment();
            if (this.useConnectionLock) {
                this.connectionLock.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setNamespace(String prefix, String name) throws SailException {
        if (prefix == null) {
            throw new NullPointerException("prefix must not be null");
        }
        if (name == null) {
            throw new NullPointerException("name must not be null");
        }
        if (this.useConnectionLock) {
            this.connectionLock.readLock().lock();
        }
        this.blockClose.increment();
        try {
            this.verifyIsOpen();
            this.updateLock.lock();
            try {
                this.verifyIsActive();
                this.setNamespaceInternal(prefix, name);
            }
            finally {
                this.updateLock.unlock();
            }
        }
        finally {
            this.unblockClose.increment();
            if (this.useConnectionLock) {
                this.connectionLock.readLock().unlock();
            }
        }
    }

    @Override
    public final void removeNamespace(String prefix) throws SailException {
        if (prefix == null) {
            throw new NullPointerException("prefix must not be null");
        }
        if (this.useConnectionLock) {
            this.connectionLock.readLock().lock();
        }
        this.blockClose.increment();
        try {
            this.verifyIsOpen();
            this.updateLock.lock();
            try {
                this.verifyIsActive();
                this.removeNamespaceInternal(prefix);
            }
            finally {
                this.updateLock.unlock();
            }
        }
        finally {
            this.unblockClose.increment();
            if (this.useConnectionLock) {
                this.connectionLock.readLock().unlock();
            }
        }
    }

    @Override
    public final void clearNamespaces() throws SailException {
        if (this.useConnectionLock) {
            this.connectionLock.readLock().lock();
        }
        this.blockClose.increment();
        try {
            this.verifyIsOpen();
            this.updateLock.lock();
            try {
                this.verifyIsActive();
                this.clearNamespacesInternal();
            }
            finally {
                this.updateLock.unlock();
            }
        }
        finally {
            this.unblockClose.increment();
            if (this.useConnectionLock) {
                this.connectionLock.readLock().unlock();
            }
        }
    }

    @Override
    public boolean pendingRemovals() {
        return this.statementsRemoved;
    }

    protected boolean pendingAdds() {
        return this.statementsAdded;
    }

    protected void setStatementsAdded() {
        this.statementsAdded = true;
    }

    protected void setStatementsRemoved() {
        this.statementsRemoved = true;
    }

    @Deprecated(forRemoval=true)
    protected Lock getSharedConnectionLock() throws SailException {
        return new JavaLock(this.connectionLock.readLock());
    }

    @Deprecated(forRemoval=true)
    protected Lock getExclusiveConnectionLock() throws SailException {
        return new JavaLock(this.connectionLock.writeLock());
    }

    @Deprecated(forRemoval=true)
    protected Lock getTransactionLock() throws SailException {
        return new JavaLock(this.updateLock);
    }

    @InternalUseOnly
    public Thread getOwner() {
        return this.owner;
    }

    protected <T, E extends Exception> CloseableIteration<T, E> registerIteration(CloseableIteration<T, E> iter) {
        if (iter instanceof EmptyIteration) {
            return iter;
        }
        this.iterationsOpened.increment();
        if (this.debugEnabled) {
            SailBaseIteration<T, E> result = new SailBaseIteration<T, E>(iter, this);
            this.activeIterationsDebug.put(result, new Throwable("Unclosed iteration"));
            return result;
        }
        return new CleanerIteration<T, E>(new SailBaseIteration<T, E>(iter, this), cleaner);
    }

    protected void iterationClosed(SailBaseIteration<?, ?> iter) {
        if (this.debugEnabled) {
            this.activeIterationsDebug.remove(iter);
        }
        this.iterationsClosed.increment();
    }

    protected abstract void closeInternal() throws SailException;

    protected abstract CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluateInternal(TupleExpr var1, Dataset var2, BindingSet var3, boolean var4) throws SailException;

    protected abstract CloseableIteration<? extends Resource, SailException> getContextIDsInternal() throws SailException;

    protected abstract CloseableIteration<? extends Statement, SailException> getStatementsInternal(Resource var1, IRI var2, Value var3, boolean var4, Resource ... var5) throws SailException;

    protected abstract long sizeInternal(Resource ... var1) throws SailException;

    protected abstract void startTransactionInternal() throws SailException;

    protected void prepareInternal() throws SailException {
    }

    protected abstract void commitInternal() throws SailException;

    protected abstract void rollbackInternal() throws SailException;

    protected abstract void addStatementInternal(Resource var1, IRI var2, Value var3, Resource ... var4) throws SailException;

    protected abstract void removeStatementsInternal(Resource var1, IRI var2, Value var3, Resource ... var4) throws SailException;

    protected abstract void clearInternal(Resource ... var1) throws SailException;

    protected abstract CloseableIteration<? extends Namespace, SailException> getNamespacesInternal() throws SailException;

    protected abstract String getNamespaceInternal(String var1) throws SailException;

    protected abstract void setNamespaceInternal(String var1, String var2) throws SailException;

    protected abstract void removeNamespaceInternal(String var1) throws SailException;

    protected abstract void clearNamespacesInternal() throws SailException;

    protected boolean isActiveOperation() {
        long opened;
        long closed = this.iterationsClosed.sum();
        return closed != (opened = this.iterationsOpened.sum());
    }

    protected AbstractSail getSailBase() {
        return this.sailBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceCloseActiveOperations() throws SailException {
        Thread deadlockPreventionThread = this.startDeadlockPreventionThread();
        try {
            for (int i = 0; i < 10 && this.isActiveOperation() && !this.debugEnabled; ++i) {
                System.gc();
                try {
                    Thread.sleep(1L);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new SailException(e);
                }
            }
            if (this.debugEnabled) {
                IdentityHashMap activeIterationsCopy = new IdentityHashMap(this.activeIterationsDebug);
                this.activeIterationsDebug.clear();
                if (!activeIterationsCopy.isEmpty()) {
                    for (Map.Entry<SailBaseIteration<?, ?>, Throwable> entry : activeIterationsCopy.entrySet()) {
                        try {
                            logger.warn("Unclosed iteration", entry.getValue());
                            entry.getKey().close();
                        }
                        catch (Exception e) {
                            if (e instanceof InterruptedException) {
                                Thread.currentThread().interrupt();
                                throw new SailException(e);
                            }
                            logger.warn("Exception occurred while closing unclosed iterations.", (Throwable)e);
                        }
                    }
                    Map.Entry entry = (Map.Entry)activeIterationsCopy.entrySet().stream().findAny().orElseThrow();
                    throw new SailException("Connection closed before all iterations were closed: " + ((SailBaseIteration)entry.getKey()).toString(), (Throwable)entry.getValue());
                }
            }
        }
        finally {
            if (deadlockPreventionThread != null) {
                deadlockPreventionThread.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushPendingUpdates() throws SailException {
        if ((this.statementsAdded || this.statementsRemoved) && this.isActive() && this.isActive()) {
            AbstractSailConnection abstractSailConnection = this;
            synchronized (abstractSailConnection) {
                if ((this.statementsAdded || this.statementsRemoved) && this.isActive()) {
                    this.flush();
                    this.statementsAdded = false;
                    this.statementsRemoved = false;
                }
            }
        }
    }

    static {
        if (!$assertionsDisabled) {
            assertsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        cleaner = new ConcurrentCleaner();
        logger = LoggerFactory.getLogger(AbstractSailConnection.class);
        wildContext = SimpleValueFactory.getInstance().createBNode();
        try {
            IS_OPEN = MethodHandles.lookup().in(AbstractSailConnection.class).findVarHandle(AbstractSailConnection.class, "isOpen", Boolean.TYPE);
        }
        catch (ReflectiveOperationException e) {
            throw new Error(e);
        }
    }

    private static class JavaLock
    implements Lock {
        private final java.util.concurrent.locks.Lock javaLock;
        private boolean isActive = true;

        public JavaLock(java.util.concurrent.locks.Lock javaLock) {
            this.javaLock = javaLock;
            javaLock.lock();
        }

        @Override
        public synchronized boolean isActive() {
            return this.isActive;
        }

        @Override
        public synchronized void release() {
            if (this.isActive) {
                this.javaLock.unlock();
                this.isActive = false;
            }
        }
    }

    private static class WildStatement
    implements Statement {
        private static final long serialVersionUID = 3363010521961228565L;
        private final Resource subject;
        private final IRI predicate;
        private final Value object;
        private final Resource context;

        public WildStatement(Resource subject, IRI predicate, Value object) {
            this(subject, predicate, object, null);
        }

        public WildStatement(Resource subject, IRI predicate, Value object, Resource context) {
            this.subject = subject;
            this.predicate = predicate;
            this.object = object;
            this.context = context;
        }

        @Override
        public Resource getSubject() {
            return this.subject;
        }

        @Override
        public IRI getPredicate() {
            return this.predicate;
        }

        @Override
        public Value getObject() {
            return this.object;
        }

        @Override
        public Resource getContext() {
            return this.context;
        }

        public String toString() {
            return "(" + this.getSubject() + ", " + this.getPredicate() + ", " + this.getObject() + ") [" + this.getContext() + "]";
        }
    }
}

