/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.AbstractBindingSet;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MutableBindingSet;
import org.eclipse.rdf4j.query.impl.SimpleBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InternalUseOnly
public class ArrayBindingSet
extends AbstractBindingSet
implements MutableBindingSet {
    private static final long serialVersionUID = -1L;
    private static final Logger logger = LoggerFactory.getLogger(ArrayBindingSet.class);
    private final String[] bindingNames;
    private final boolean[] whichBindingsHaveBeenSet;
    private final Value[] values;
    List<String> sortedBindingNames = null;

    public ArrayBindingSet(String ... names) {
        this.bindingNames = names;
        this.values = new Value[names.length];
        this.whichBindingsHaveBeenSet = new boolean[names.length];
    }

    public ArrayBindingSet(BindingSet toCopy, Set<String> names, String[] namesArray) {
        assert (!(toCopy instanceof ArrayBindingSet));
        this.bindingNames = namesArray;
        this.whichBindingsHaveBeenSet = new boolean[this.bindingNames.length];
        this.values = new Value[this.bindingNames.length];
        for (int i = 0; i < this.bindingNames.length; ++i) {
            Binding binding = toCopy.getBinding(this.bindingNames[i]);
            if (binding == null) continue;
            this.values[i] = binding.getValue();
            this.whichBindingsHaveBeenSet[i] = true;
        }
    }

    public ArrayBindingSet(ArrayBindingSet toCopy, String ... names) {
        this.bindingNames = names;
        this.values = Arrays.copyOf(toCopy.values, toCopy.values.length);
        this.whichBindingsHaveBeenSet = Arrays.copyOf(toCopy.whichBindingsHaveBeenSet, toCopy.whichBindingsHaveBeenSet.length);
    }

    public BiConsumer<Value, ArrayBindingSet> getDirectSetBinding(String bindingName) {
        int index = this.getIndex(bindingName);
        if (index == -1) {
            logger.error("Variable not known to ArrayBindingSet : " + bindingName);
            assert (false) : "Variable not known to ArrayBindingSet : " + bindingName;
            return null;
        }
        return (v, a) -> {
            a.values[index] = v;
            a.whichBindingsHaveBeenSet[index] = true;
        };
    }

    public BiConsumer<Value, ArrayBindingSet> getDirectAddBinding(String bindingName) {
        int index = this.getIndex(bindingName);
        if (index == -1) {
            logger.error("Variable not known to ArrayBindingSet : " + bindingName);
            assert (false) : "Variable not known to ArrayBindingSet : " + bindingName;
            return null;
        }
        return (v, a) -> {
            assert (!a.whichBindingsHaveBeenSet[index]) : "variable already bound: " + bindingName;
            a.values[index] = v;
            a.whichBindingsHaveBeenSet[index] = true;
        };
    }

    public Function<ArrayBindingSet, Binding> getDirectGetBinding(String bindingName) {
        int index = this.getIndex(bindingName);
        if (index == -1) {
            return null;
        }
        return a -> {
            Value value = a.values[index];
            if (value != null) {
                return new SimpleBinding(bindingName, value);
            }
            return null;
        };
    }

    public Function<ArrayBindingSet, Value> getDirectGetValue(String bindingName) {
        int index = this.getIndex(bindingName);
        if (index == -1) {
            return null;
        }
        return a -> a.values[index];
    }

    public Function<ArrayBindingSet, Boolean> getDirectHasBinding(String bindingName) {
        int index = this.getIndex(bindingName);
        if (index == -1) {
            return null;
        }
        return a -> a.whichBindingsHaveBeenSet[index];
    }

    private int getIndex(String bindingName) {
        int i;
        for (i = 0; i < this.bindingNames.length; ++i) {
            if (this.bindingNames[i] != bindingName) continue;
            return i;
        }
        for (i = 0; i < this.bindingNames.length; ++i) {
            if (!this.bindingNames[i].equals(bindingName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Set<String> getBindingNames() {
        int size = this.size();
        switch (size) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                for (int i = 0; i < this.bindingNames.length; ++i) {
                    if (!this.whichBindingsHaveBeenSet[i]) continue;
                    return Collections.singleton(this.bindingNames[i]);
                }
                throw new ConcurrentModificationException("An bindingset has been modified during the getBindingNames call");
            }
        }
        return new MinimallyAllocatingSet(size);
    }

    @Override
    public Value getValue(String bindingName) {
        int i;
        for (i = 0; i < this.bindingNames.length; ++i) {
            if (this.bindingNames[i] != bindingName || !this.whichBindingsHaveBeenSet[i]) continue;
            return this.values[i];
        }
        for (i = 0; i < this.bindingNames.length; ++i) {
            if (!this.bindingNames[i].equals(bindingName) || !this.whichBindingsHaveBeenSet[i]) continue;
            return this.values[i];
        }
        return null;
    }

    @Override
    public Binding getBinding(String bindingName) {
        Value value = this.getValue(bindingName);
        if (value != null) {
            return new SimpleBinding(bindingName, value);
        }
        return null;
    }

    @Override
    public boolean hasBinding(String bindingName) {
        int index = this.getIndex(bindingName);
        if (index == -1) {
            return false;
        }
        return this.whichBindingsHaveBeenSet[index];
    }

    @Override
    public Iterator<Binding> iterator() {
        return new ArrayBindingSetIterator();
    }

    @Override
    public int size() {
        int size = 0;
        for (boolean value : this.whichBindingsHaveBeenSet) {
            if (!value) continue;
            ++size;
        }
        return size;
    }

    public List<String> getSortedBindingNames() {
        if (this.sortedBindingNames == null) {
            int size = this.size();
            if (size == 1) {
                for (int i = 0; i < this.bindingNames.length; ++i) {
                    if (!this.whichBindingsHaveBeenSet[i]) continue;
                    this.sortedBindingNames = Collections.singletonList(this.bindingNames[i]);
                }
            } else {
                ArrayList<String> names = new ArrayList<String>(size);
                for (int i = 0; i < this.bindingNames.length; ++i) {
                    if (!this.whichBindingsHaveBeenSet[i]) continue;
                    names.add(this.bindingNames[i]);
                }
                names.sort(String::compareTo);
                this.sortedBindingNames = names;
            }
        }
        return this.sortedBindingNames;
    }

    @Override
    public void addBinding(Binding binding) {
        int index = this.getIndex(binding.getName());
        if (index == -1) {
            logger.error("We don't actually support adding a binding. " + binding.getName() + " : " + binding.getValue());
            assert (false) : "We don't actually support adding a binding. " + binding.getName() + " : " + binding.getValue();
            return;
        }
        assert (!this.whichBindingsHaveBeenSet[index]) : "variable already bound: " + binding.getName();
        this.values[index] = binding.getValue();
        this.whichBindingsHaveBeenSet[index] = true;
    }

    @Override
    public void setBinding(Binding binding) {
        int index = this.getIndex(binding.getName());
        if (index == -1) {
            return;
        }
        this.values[index] = binding.getValue();
        this.whichBindingsHaveBeenSet[index] = true;
    }

    @Override
    public void setBinding(String name, Value value) {
        int index = this.getIndex(name);
        if (index == -1) {
            return;
        }
        this.values[index] = value;
        this.whichBindingsHaveBeenSet[index] = value != null;
    }

    @Override
    public boolean isEmpty() {
        for (int index = 0; index < this.values.length; ++index) {
            if (!this.whichBindingsHaveBeenSet[index]) continue;
            return false;
        }
        return true;
    }

    private class ArrayBindingSetIterator
    implements Iterator<Binding> {
        private int index = 0;

        @Override
        public boolean hasNext() {
            while (this.index < ArrayBindingSet.this.values.length) {
                if (ArrayBindingSet.this.whichBindingsHaveBeenSet[this.index] && ArrayBindingSet.this.values[this.index] != null) {
                    return true;
                }
                ++this.index;
            }
            return false;
        }

        @Override
        public Binding next() {
            while (!(this.index >= ArrayBindingSet.this.values.length || ArrayBindingSet.this.whichBindingsHaveBeenSet[this.index] && ArrayBindingSet.this.values[this.index] != null)) {
                ++this.index;
            }
            try {
                String name = ArrayBindingSet.this.bindingNames[this.index];
                Value value = ArrayBindingSet.this.values[this.index++];
                if (value != null) {
                    return new SimpleBinding(name, value);
                }
                return null;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private final class MinimallyAllocatingSet
    extends AbstractSet<String> {
        private final int size;

        private MinimallyAllocatingSet(int size) {
            this.size = size;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public Iterator<String> iterator() {
            Iterator<Binding> nested = ArrayBindingSet.this.iterator();
            return new BindingToBindingNameIterator(nested);
        }

        @Override
        public boolean add(String e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends String> c) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class BindingToBindingNameIterator
    implements Iterator<String> {
        private final Iterator<Binding> nested;

        private BindingToBindingNameIterator(Iterator<Binding> nested) {
            this.nested = nested;
        }

        @Override
        public boolean hasNext() {
            return this.nested.hasNext();
        }

        @Override
        public String next() {
            return this.nested.next().getName();
        }
    }
}

