/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation.iterator;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;

public class ConsumingIteration
implements CloseableIteration<BindingSet, QueryEvaluationException> {
    private final List<BindingSet> consumed = Lists.newArrayList();
    private final CloseableIteration<BindingSet, QueryEvaluationException> innerIter;
    private int currentIndex = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsumingIteration(CloseableIteration<BindingSet, QueryEvaluationException> iter, int max) throws QueryEvaluationException {
        this.innerIter = iter;
        boolean completed = false;
        try {
            while (this.consumed.size() < max && iter.hasNext()) {
                this.consumed.add((BindingSet)iter.next());
                if (!Thread.interrupted()) continue;
                Thread.currentThread().interrupt();
                this.close();
                return;
            }
            if (!iter.hasNext()) {
                iter.close();
            }
            completed = true;
        }
        finally {
            if (!completed) {
                this.close();
            }
        }
    }

    @Override
    public boolean hasNext() throws QueryEvaluationException {
        if (Thread.interrupted()) {
            Thread.currentThread().interrupt();
            this.close();
            return false;
        }
        return this.currentIndex < this.consumed.size() || this.innerIter.hasNext();
    }

    @Override
    public BindingSet next() throws QueryEvaluationException {
        if (this.hasNext()) {
            if (this.currentIndex < this.consumed.size()) {
                BindingSet result = this.consumed.get(this.currentIndex);
                ++this.currentIndex;
                return result;
            }
            return (BindingSet)this.innerIter.next();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() throws QueryEvaluationException {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    public void close() throws QueryEvaluationException {
        this.innerIter.close();
    }
}

