/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.AbstractSimpleConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.FilterPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PatternFilter;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;

public class PatternConstraintComponent
extends AbstractSimpleConstraintComponent {
    String pattern;
    String flags;

    public PatternConstraintComponent(String pattern, String flags) {
        this.pattern = pattern;
        this.flags = flags;
        if (flags == null) {
            this.flags = "";
        }
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection) {
        model.add(subject, SHACL.PATTERN, (Value)Values.literal((String)this.pattern), new Resource[0]);
        if (this.flags != null && !this.flags.isEmpty()) {
            model.add(subject, SHACL.FLAGS, (Value)Values.literal((String)this.flags), new Resource[0]);
        }
    }

    @Override
    String getSparqlFilterExpression(StatementMatcher.Variable<Value> variable, boolean negated) {
        if (negated) {
            return "!isBlank(" + variable.asSparqlVariable() + ") && REGEX(STR(" + variable.asSparqlVariable() + "), \"" + PatternConstraintComponent.escapeRegexForSparql(this.pattern) + "\", \"" + this.flags + "\") ";
        }
        return " isBlank(" + variable.asSparqlVariable() + ") || !REGEX(STR(" + variable.asSparqlVariable() + "), \"" + PatternConstraintComponent.escapeRegexForSparql(this.pattern) + "\", \"" + this.flags + "\") ";
    }

    private static String escapeRegexForSparql(String pattern) {
        return pattern.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n");
    }

    @Override
    public SourceConstraintComponent getConstraintComponent() {
        return SourceConstraintComponent.PatternConstraintComponent;
    }

    @Override
    public ConstraintComponent deepClone() {
        return new PatternConstraintComponent(this.pattern, this.flags);
    }

    @Override
    Function<PlanNode, FilterPlanNode> getFilterAttacher() {
        return parent -> new PatternFilter((PlanNode)parent, this.pattern, this.flags);
    }

    @Override
    public List<Literal> getDefaultMessage() {
        return List.of();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatternConstraintComponent that = (PatternConstraintComponent)o;
        if (!this.pattern.equals(that.pattern)) {
            return false;
        }
        return Objects.equals(this.flags, that.flags);
    }

    public int hashCode() {
        int result = this.pattern.hashCode();
        result = 31 * result + (this.flags != null ? this.flags.hashCode() : 0);
        return result + "PatternConstraintComponent".hashCode();
    }
}

