/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ValidationSettings;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclPrefixParser;
import org.eclipse.rdf4j.sail.shacl.ast.Shape;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.ValidationApproach;
import org.eclipse.rdf4j.sail.shacl.ast.ValidationQuery;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.AbstractConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.paths.Path;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.AllTargetsPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.BulkedExternalInnerJoin;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ShiftToPropertyShape;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.SparqlConstraintSelect;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Unique;
import org.eclipse.rdf4j.sail.shacl.ast.targets.EffectiveTarget;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.wrapper.shape.ShapeSource;

public class SparqlConstraintComponent
extends AbstractConstraintComponent {
    private final Shape shape;
    public boolean produceValidationReports;
    private String select;
    private String originalSelect;
    private List<Literal> message = new ArrayList<Literal>();
    private Boolean deactivated;
    private final Set<Namespace> namespaces;
    private final Model prefixes;

    public SparqlConstraintComponent(Resource id, ShapeSource shapeSource, Shape shape) {
        super(id);
        this.shape = shape;
        try (Stream<Value> objects = shapeSource.getObjects(id, ShapeSource.Predicates.SELECT);){
            objects.forEach(literal -> {
                if (this.select != null) {
                    throw new IllegalStateException("Multiple sh:select queries found for constraint component " + id);
                }
                if (!literal.isLiteral()) {
                    throw new IllegalStateException("sh:select must be a literal for constraint component " + id);
                }
                this.originalSelect = this.select = literal.stringValue();
            });
        }
        if (this.select == null) {
            throw new IllegalStateException("No sh:select query found for constraint component " + id);
        }
        objects = shapeSource.getObjects(id, ShapeSource.Predicates.MESSAGE);
        try {
            objects.forEach(literal -> {
                if (!literal.isLiteral()) {
                    throw new IllegalStateException("sh:message must be a literal for constraint component " + id);
                }
                this.message.add((Literal)literal);
            });
        }
        finally {
            if (objects != null) {
                objects.close();
            }
        }
        objects = shapeSource.getObjects(id, ShapeSource.Predicates.DEACTIVATED);
        try {
            objects.forEach(literal -> {
                if (this.deactivated != null) {
                    throw new IllegalStateException("Multiple sh:deactivated found for constraint component " + id);
                }
                if (!literal.isLiteral()) {
                    throw new IllegalStateException("sh:deactivated must be a literal for constraint component " + id);
                }
                this.deactivated = ((Literal)literal).booleanValue();
            });
        }
        finally {
            if (objects != null) {
                objects.close();
            }
        }
        ShaclPrefixParser.Namespaces shaclNamespaces = ShaclPrefixParser.extractNamespaces(id, shapeSource);
        this.prefixes = shaclNamespaces.getModel();
        this.namespaces = shaclNamespaces.getNamespaces();
        this.select = ShaclPrefixParser.toSparqlPrefixes(this.namespaces) + "\n" + this.select;
    }

    public SparqlConstraintComponent(Resource id, Shape shape, boolean produceValidationReports, String select, String originalSelect, List<Literal> message, Boolean deactivated, Set<Namespace> namespaces, Model prefixes) {
        super(id);
        this.shape = shape;
        this.produceValidationReports = produceValidationReports;
        this.select = select;
        this.originalSelect = originalSelect;
        this.message = message;
        this.deactivated = deactivated;
        this.prefixes = prefixes;
        this.namespaces = namespaces;
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection) {
        model.add(subject, SHACL.SPARQL, this.getId(), new Resource[0]);
        model.add(this.getId(), SHACL.SELECT, Values.literal(this.originalSelect), new Resource[0]);
        model.add(this.getId(), RDF.TYPE, SHACL.SPARQL_CONSTRAINT, new Resource[0]);
        for (Literal literal : this.message) {
            model.add(this.getId(), SHACL.MESSAGE, literal, new Resource[0]);
        }
        if (this.deactivated != null) {
            model.add(this.getId(), SHACL.DEACTIVATED, Values.literal(this.deactivated), new Resource[0]);
        }
        model.addAll(this.prefixes);
    }

    @Override
    public SourceConstraintComponent getConstraintComponent() {
        return SourceConstraintComponent.SPARQLConstraintComponent;
    }

    @Override
    public PlanNode generateTransactionalValidationPlan(ConnectionsGroup connectionsGroup, ValidationSettings validationSettings, PlanNodeProvider overrideTargetNode, ConstraintComponent.Scope scope) {
        StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider = new StatementMatcher.StableRandomVariableProvider();
        EffectiveTarget effectiveTarget = this.getTargetChain().getEffectiveTarget(scope, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider);
        String select = this.select;
        if (scope == ConstraintComponent.Scope.propertyShape) {
            Path path = this.getTargetChain().getPath().get();
            String s = path.toSparqlPathString();
            select = select.replace(" $PATH ", " " + s + " ");
        }
        PlanNode allTargets = overrideTargetNode != null ? this.getPlanNodeForOverrideTargetNode(connectionsGroup, validationSettings, overrideTargetNode, scope, stableRandomVariableProvider, effectiveTarget, this.getTargetChain().getPath()) : effectiveTarget.getAllTargets(connectionsGroup, validationSettings.getDataGraph(), scope);
        return new SparqlConstraintSelect(connectionsGroup.getBaseConnection(), allTargets, select, scope, validationSettings.getDataGraph(), this.produceValidationReports, this, this.shape);
    }

    private PlanNode getPlanNodeForOverrideTargetNode(ConnectionsGroup connectionsGroup, ValidationSettings validationSettings, PlanNodeProvider overrideTargetNode, ConstraintComponent.Scope scope, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider, EffectiveTarget effectiveTarget, Optional<Path> path) {
        if (scope == ConstraintComponent.Scope.nodeShape) {
            PlanNode overrideTargetPlanNode = overrideTargetNode.getPlanNode();
            if (overrideTargetPlanNode instanceof AllTargetsPlanNode) {
                PlanNode allTargets = effectiveTarget.getAllTargets(connectionsGroup, validationSettings.getDataGraph(), scope);
                return Unique.getInstance(allTargets, true);
            }
            return effectiveTarget.extend(overrideTargetPlanNode, connectionsGroup, validationSettings.getDataGraph(), scope, EffectiveTarget.Extend.right, false, null);
        }
        PlanNode overrideTargetPlanNode = overrideTargetNode.getPlanNode();
        if (overrideTargetPlanNode instanceof AllTargetsPlanNode) {
            PlanNode allTargets = this.getTargetChain().getEffectiveTarget(ConstraintComponent.Scope.nodeShape, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider).getAllTargets(connectionsGroup, validationSettings.getDataGraph(), ConstraintComponent.Scope.nodeShape);
            allTargets = new ShiftToPropertyShape(allTargets);
            return Unique.getInstance(allTargets, true);
        }
        overrideTargetPlanNode = effectiveTarget.extend(overrideTargetPlanNode, connectionsGroup, validationSettings.getDataGraph(), scope, EffectiveTarget.Extend.right, false, null);
        PlanNode planNode = new BulkedExternalInnerJoin(overrideTargetPlanNode, connectionsGroup.getBaseConnection(), validationSettings.getDataGraph(), path.get().getTargetQueryFragment(new StatementMatcher.Variable<String>("a"), new StatementMatcher.Variable<String>("c"), connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider, Set.of()), false, null, BulkedExternalInnerJoin.getMapper("a", "c", scope, validationSettings.getDataGraph()));
        planNode = connectionsGroup.getCachedNodeFor(planNode);
        return planNode;
    }

    @Override
    public PlanNode getAllTargetsPlan(ConnectionsGroup connectionsGroup, Resource[] dataGraph, ConstraintComponent.Scope scope, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider) {
        return this.getTargetChain().getEffectiveTarget(scope, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider).getAllTargets(connectionsGroup, dataGraph, scope);
    }

    @Override
    public ConstraintComponent deepClone() {
        return new SparqlConstraintComponent(this.getId(), this.shape, this.produceValidationReports, this.select, this.originalSelect, this.message, this.deactivated, this.namespaces, this.prefixes);
    }

    @Override
    public ValidationQuery generateSparqlValidationQuery(ConnectionsGroup connectionsGroup, ValidationSettings validationSettings, boolean negatePlan, boolean negateChildren, ConstraintComponent.Scope scope) {
        return null;
    }

    @Override
    public ValidationApproach getOptimalBulkValidationApproach() {
        return ValidationApproach.Transactional;
    }

    @Override
    public List<Literal> getDefaultMessage() {
        return this.message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SparqlConstraintComponent that = (SparqlConstraintComponent)o;
        if (this.produceValidationReports != that.produceValidationReports) {
            return false;
        }
        if (!this.select.equals(that.select)) {
            return false;
        }
        if (!this.originalSelect.equals(that.originalSelect)) {
            return false;
        }
        if (!Objects.equals(this.message, that.message)) {
            return false;
        }
        return Objects.equals(this.deactivated, that.deactivated);
    }

    public int hashCode() {
        int result = this.produceValidationReports ? 1 : 0;
        result = 31 * result + this.select.hashCode();
        result = 31 * result + this.originalSelect.hashCode();
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        result = 31 * result + (this.deactivated != null ? this.deactivated.hashCode() : 0);
        return result + "SparqlConstraintComponent".hashCode();
    }
}

