/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.config;

import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.impl.BooleanLiteral;
import org.eclipse.rdf4j.model.util.Configurations;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.CONFIG;
import org.eclipse.rdf4j.model.vocabulary.RDF4J;
import org.eclipse.rdf4j.sail.config.AbstractDelegatingSailImplConfig;
import org.eclipse.rdf4j.sail.config.SailConfigException;
import org.eclipse.rdf4j.sail.config.SailImplConfig;
import org.eclipse.rdf4j.sail.shacl.config.ShaclSailSchema;

public class ShaclSailConfig
extends AbstractDelegatingSailImplConfig {
    private static final boolean USE_CONFIG = "true".equalsIgnoreCase(System.getProperty("org.eclipse.rdf4j.model.vocabulary.experimental.enableConfig"));
    public static final boolean PARALLEL_VALIDATION_DEFAULT = true;
    public static final boolean LOG_VALIDATION_PLANS_DEFAULT = false;
    public static final boolean LOG_VALIDATION_VIOLATIONS_DEFAULT = false;
    public static final boolean VALIDATION_ENABLED_DEFAULT = true;
    public static final boolean CACHE_SELECT_NODES_DEFAULT = true;
    public static final boolean GLOBAL_LOG_VALIDATION_EXECUTION_DEFAULT = false;
    public static final boolean RDFS_SUB_CLASS_REASONING_DEFAULT = true;
    public static final boolean PERFORMANCE_LOGGING_DEFAULT = false;
    public static final boolean SERIALIZABLE_VALIDATION_DEFAULT = true;
    public static final boolean ECLIPSE_RDF4J_SHACL_EXTENSIONS_DEFAULT = false;
    public static final boolean DASH_DATA_SHAPES_DEFAULT = false;
    public static final long VALIDATION_RESULTS_LIMIT_TOTAL_DEFAULT = 1000000L;
    public static final long VALIDATION_RESULTS_LIMIT_PER_CONSTRAINT_DEFAULT = 1000L;
    public static final long TRANSACTIONAL_VALIDATION_LIMIT_DEFAULT = 500000L;
    public static final Set<IRI> SHAPES_GRAPHS_DEFAULT = Set.of(RDF4J.SHACL_SHAPE_GRAPH);
    private boolean parallelValidation = true;
    private boolean logValidationPlans = false;
    private boolean logValidationViolations = false;
    private boolean validationEnabled = true;
    private boolean cacheSelectNodes = true;
    private boolean globalLogValidationExecution = false;
    private boolean rdfsSubClassReasoning = true;
    private boolean performanceLogging = false;
    private boolean serializableValidation = true;
    private boolean eclipseRdf4jShaclExtensions = false;
    private boolean dashDataShapes = false;
    private long validationResultsLimitTotal = 1000000L;
    private long validationResultsLimitPerConstraint = 1000L;
    private long transactionalValidationLimit = 500000L;
    private Set<IRI> shapesGraphs = SHAPES_GRAPHS_DEFAULT;

    public ShaclSailConfig() {
        super("rdf4j:ShaclSail");
    }

    public ShaclSailConfig(SailImplConfig delegate) {
        super("rdf4j:ShaclSail", delegate);
    }

    public boolean isLogValidationPlans() {
        return this.logValidationPlans;
    }

    public void setLogValidationPlans(boolean logValidationPlans) {
        this.logValidationPlans = logValidationPlans;
    }

    public boolean isLogValidationViolations() {
        return this.logValidationViolations;
    }

    public void setLogValidationViolations(boolean logValidationViolations) {
        this.logValidationViolations = logValidationViolations;
    }

    public boolean isGlobalLogValidationExecution() {
        return this.globalLogValidationExecution;
    }

    public void setGlobalLogValidationExecution(boolean globalLogValidationExecution) {
        this.globalLogValidationExecution = globalLogValidationExecution;
    }

    public boolean isValidationEnabled() {
        return this.validationEnabled;
    }

    public void setValidationEnabled(boolean validationEnabled) {
        this.validationEnabled = validationEnabled;
    }

    public boolean isParallelValidation() {
        return this.parallelValidation;
    }

    public void setParallelValidation(boolean parallelValidation) {
        this.parallelValidation = parallelValidation;
    }

    public boolean isCacheSelectNodes() {
        return this.cacheSelectNodes;
    }

    public void setCacheSelectNodes(boolean cacheSelectNodes) {
        this.cacheSelectNodes = cacheSelectNodes;
    }

    public boolean isRdfsSubClassReasoning() {
        return this.rdfsSubClassReasoning;
    }

    public void setRdfsSubClassReasoning(boolean rdfsSubClassReasoning) {
        this.rdfsSubClassReasoning = rdfsSubClassReasoning;
    }

    public boolean isPerformanceLogging() {
        return this.performanceLogging;
    }

    public void setPerformanceLogging(boolean performanceLogging) {
        this.performanceLogging = performanceLogging;
    }

    public boolean isSerializableValidation() {
        return this.serializableValidation;
    }

    public void setSerializableValidation(boolean serializableValidation) {
        this.serializableValidation = serializableValidation;
    }

    @Experimental
    public boolean isEclipseRdf4jShaclExtensions() {
        return this.eclipseRdf4jShaclExtensions;
    }

    @Experimental
    public void setEclipseRdf4jShaclExtensions(boolean eclipseRdf4jShaclExtensions) {
        this.eclipseRdf4jShaclExtensions = eclipseRdf4jShaclExtensions;
    }

    @Experimental
    public boolean isDashDataShapes() {
        return this.dashDataShapes;
    }

    @Experimental
    public void setDashDataShapes(boolean dashDataShapes) {
        this.dashDataShapes = dashDataShapes;
    }

    public long getValidationResultsLimitTotal() {
        return this.validationResultsLimitTotal;
    }

    public long getValidationResultsLimitPerConstraint() {
        return this.validationResultsLimitPerConstraint;
    }

    public void setValidationResultsLimitTotal(long validationResultsLimitTotal) {
        this.validationResultsLimitTotal = validationResultsLimitTotal;
    }

    public void setValidationResultsLimitPerConstraint(long validationResultsLimitPerConstraint) {
        this.validationResultsLimitPerConstraint = validationResultsLimitPerConstraint;
    }

    public long getTransactionalValidationLimit() {
        return this.transactionalValidationLimit;
    }

    public void setTransactionalValidationLimit(long transactionalValidationLimit) {
        this.transactionalValidationLimit = transactionalValidationLimit;
    }

    public Set<IRI> getShapesGraphs() {
        return this.shapesGraphs;
    }

    public void setShapesGraphs(Set<IRI> shapesGraphs) {
        this.shapesGraphs = shapesGraphs;
    }

    @Override
    public Resource export(Model m) {
        Resource implNode = super.export(m);
        m.setNamespace(CONFIG.NS);
        if (USE_CONFIG) {
            m.add(implNode, CONFIG.Shacl.parallelValidation, BooleanLiteral.valueOf(this.isParallelValidation()), new Resource[0]);
            m.add(implNode, CONFIG.Shacl.logValidationPlans, BooleanLiteral.valueOf(this.isLogValidationPlans()), new Resource[0]);
            m.add(implNode, CONFIG.Shacl.logValidationViolations, BooleanLiteral.valueOf(this.isLogValidationViolations()), new Resource[0]);
            m.add(implNode, CONFIG.Shacl.validationEnabled, BooleanLiteral.valueOf(this.isValidationEnabled()), new Resource[0]);
            m.add(implNode, CONFIG.Shacl.cacheSelectNodes, BooleanLiteral.valueOf(this.isCacheSelectNodes()), new Resource[0]);
            m.add(implNode, CONFIG.Shacl.globalLogValidationExecution, BooleanLiteral.valueOf(this.isGlobalLogValidationExecution()), new Resource[0]);
            m.add(implNode, CONFIG.Shacl.rdfsSubClassReasoning, BooleanLiteral.valueOf(this.isRdfsSubClassReasoning()), new Resource[0]);
            m.add(implNode, CONFIG.Shacl.performanceLogging, BooleanLiteral.valueOf(this.isPerformanceLogging()), new Resource[0]);
            m.add(implNode, CONFIG.Shacl.serializableValidation, BooleanLiteral.valueOf(this.isSerializableValidation()), new Resource[0]);
            m.add(implNode, CONFIG.Shacl.eclipseRdf4jShaclExtensions, BooleanLiteral.valueOf(this.isEclipseRdf4jShaclExtensions()), new Resource[0]);
            m.add(implNode, CONFIG.Shacl.dashDataShapes, BooleanLiteral.valueOf(this.isDashDataShapes()), new Resource[0]);
            m.add(implNode, CONFIG.Shacl.validationResultsLimitTotal, Values.literal(this.getValidationResultsLimitTotal()), new Resource[0]);
            m.add(implNode, CONFIG.Shacl.validationResultsLimitPerConstraint, Values.literal(this.getValidationResultsLimitPerConstraint()), new Resource[0]);
            m.add(implNode, CONFIG.Shacl.transactionalValidationLimit, Values.literal(this.getTransactionalValidationLimit()), new Resource[0]);
            for (IRI shapesGraph : this.shapesGraphs) {
                m.add(implNode, CONFIG.Shacl.shapesGraph, shapesGraph, new Resource[0]);
            }
        } else {
            m.add(implNode, ShaclSailSchema.PARALLEL_VALIDATION, BooleanLiteral.valueOf(this.isParallelValidation()), new Resource[0]);
            m.add(implNode, ShaclSailSchema.LOG_VALIDATION_PLANS, BooleanLiteral.valueOf(this.isLogValidationPlans()), new Resource[0]);
            m.add(implNode, ShaclSailSchema.LOG_VALIDATION_VIOLATIONS, BooleanLiteral.valueOf(this.isLogValidationViolations()), new Resource[0]);
            m.add(implNode, ShaclSailSchema.VALIDATION_ENABLED, BooleanLiteral.valueOf(this.isValidationEnabled()), new Resource[0]);
            m.add(implNode, ShaclSailSchema.CACHE_SELECT_NODES, BooleanLiteral.valueOf(this.isCacheSelectNodes()), new Resource[0]);
            m.add(implNode, ShaclSailSchema.GLOBAL_LOG_VALIDATION_EXECUTION, BooleanLiteral.valueOf(this.isGlobalLogValidationExecution()), new Resource[0]);
            m.add(implNode, ShaclSailSchema.RDFS_SUB_CLASS_REASONING, BooleanLiteral.valueOf(this.isRdfsSubClassReasoning()), new Resource[0]);
            m.add(implNode, ShaclSailSchema.PERFORMANCE_LOGGING, BooleanLiteral.valueOf(this.isPerformanceLogging()), new Resource[0]);
            m.add(implNode, ShaclSailSchema.SERIALIZABLE_VALIDATION, BooleanLiteral.valueOf(this.isSerializableValidation()), new Resource[0]);
            m.add(implNode, ShaclSailSchema.ECLIPSE_RDF4J_SHACL_EXTENSIONS, BooleanLiteral.valueOf(this.isEclipseRdf4jShaclExtensions()), new Resource[0]);
            m.add(implNode, ShaclSailSchema.DASH_DATA_SHAPES, BooleanLiteral.valueOf(this.isDashDataShapes()), new Resource[0]);
            m.add(implNode, ShaclSailSchema.VALIDATION_RESULTS_LIMIT_TOTAL, Values.literal(this.getValidationResultsLimitTotal()), new Resource[0]);
            m.add(implNode, ShaclSailSchema.VALIDATION_RESULTS_LIMIT_PER_CONSTRAINT, Values.literal(this.getValidationResultsLimitPerConstraint()), new Resource[0]);
            m.add(implNode, ShaclSailSchema.TRANSACTIONAL_VALIDATION_LIMIT, Values.literal(this.getTransactionalValidationLimit()), new Resource[0]);
            for (IRI shapesGraph : this.shapesGraphs) {
                m.add(implNode, ShaclSailSchema.SHAPES_GRAPH, shapesGraph, new Resource[0]);
            }
        }
        return implNode;
    }

    @Override
    public void parse(Model m, Resource implNode) throws SailConfigException {
        super.parse(m, implNode);
        try {
            Configurations.getLiteralValue(m, implNode, CONFIG.Shacl.parallelValidation, ShaclSailSchema.PARALLEL_VALIDATION).ifPresent(l -> this.setParallelValidation(l.booleanValue()));
            Configurations.getLiteralValue(m, implNode, CONFIG.Shacl.logValidationPlans, ShaclSailSchema.LOG_VALIDATION_PLANS).ifPresent(l -> this.setLogValidationPlans(l.booleanValue()));
            Configurations.getLiteralValue(m, implNode, CONFIG.Shacl.logValidationViolations, ShaclSailSchema.LOG_VALIDATION_VIOLATIONS).ifPresent(l -> this.setLogValidationViolations(l.booleanValue()));
            Configurations.getLiteralValue(m, implNode, CONFIG.Shacl.validationEnabled, ShaclSailSchema.VALIDATION_ENABLED).ifPresent(l -> this.setValidationEnabled(l.booleanValue()));
            Configurations.getLiteralValue(m, implNode, CONFIG.Shacl.cacheSelectNodes, ShaclSailSchema.CACHE_SELECT_NODES).ifPresent(l -> this.setCacheSelectNodes(l.booleanValue()));
            Configurations.getLiteralValue(m, implNode, CONFIG.Shacl.globalLogValidationExecution, ShaclSailSchema.GLOBAL_LOG_VALIDATION_EXECUTION).ifPresent(l -> this.setGlobalLogValidationExecution(l.booleanValue()));
            Configurations.getLiteralValue(m, implNode, CONFIG.Shacl.rdfsSubClassReasoning, ShaclSailSchema.RDFS_SUB_CLASS_REASONING).ifPresent(l -> this.setRdfsSubClassReasoning(l.booleanValue()));
            Configurations.getLiteralValue(m, implNode, CONFIG.Shacl.performanceLogging, ShaclSailSchema.PERFORMANCE_LOGGING).ifPresent(l -> this.setPerformanceLogging(l.booleanValue()));
            Configurations.getLiteralValue(m, implNode, CONFIG.Shacl.serializableValidation, ShaclSailSchema.SERIALIZABLE_VALIDATION).ifPresent(l -> this.setSerializableValidation(l.booleanValue()));
            Configurations.getLiteralValue(m, implNode, CONFIG.Shacl.eclipseRdf4jShaclExtensions, ShaclSailSchema.ECLIPSE_RDF4J_SHACL_EXTENSIONS).ifPresent(l -> this.setEclipseRdf4jShaclExtensions(l.booleanValue()));
            Configurations.getLiteralValue(m, implNode, CONFIG.Shacl.dashDataShapes, ShaclSailSchema.DASH_DATA_SHAPES).ifPresent(l -> this.setDashDataShapes(l.booleanValue()));
            Configurations.getLiteralValue(m, implNode, CONFIG.Shacl.validationResultsLimitTotal, ShaclSailSchema.VALIDATION_RESULTS_LIMIT_TOTAL).ifPresent(l -> this.setValidationResultsLimitTotal(l.longValue()));
            Configurations.getLiteralValue(m, implNode, CONFIG.Shacl.validationResultsLimitPerConstraint, ShaclSailSchema.VALIDATION_RESULTS_LIMIT_PER_CONSTRAINT).ifPresent(l -> this.setValidationResultsLimitPerConstraint(l.longValue()));
            Configurations.getLiteralValue(m, implNode, CONFIG.Shacl.transactionalValidationLimit, ShaclSailSchema.TRANSACTIONAL_VALIDATION_LIMIT).ifPresent(l -> this.setTransactionalValidationLimit(l.longValue()));
            this.setShapesGraphs(Configurations.getPropertyValues(m, implNode, CONFIG.Shacl.shapesGraph, ShaclSailSchema.SHAPES_GRAPH).stream().peek(v -> {
                if (!v.isIRI()) {
                    throw new IllegalArgumentException("Expected IRI but found " + v.getClass().getSimpleName() + "for value " + v.stringValue());
                }
            }).map(o -> (IRI)o).collect(Collectors.toUnmodifiableSet()));
        }
        catch (IllegalArgumentException e) {
            throw new SailConfigException("error parsing Sail configuration", e);
        }
    }
}

