/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.results.lazy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.CloseableIteratorIteration;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.ast.Severity;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.results.ValidationResult;

@InternalUseOnly
public class ValidationResultIterator
implements Iterator<ValidationResult> {
    private final long limit;
    private long counter = 0L;
    private Boolean conforms = null;
    private boolean truncated = false;
    private Iterator<ValidationResult> next = Collections.emptyIterator();
    private CloseableIteration<? extends ValidationTuple, SailException> tupleIterator;

    public ValidationResultIterator(CloseableIteration<? extends ValidationTuple, SailException> tupleIterator, long limit, Severity severity) {
        this.limit = limit;
        this.tupleIterator = tupleIterator;
        if (severity != Severity.Violation) {
            this.conforms = true;
        }
        this.getTuples();
    }

    private void calculateNext() {
        if (this.next.hasNext()) {
            return;
        }
        if (this.tupleIterator.hasNext()) {
            if (this.limit < 0L || this.counter < this.limit || this.counter == 0L && this.limit == 0L) {
                ValidationTuple invalidTuple = (ValidationTuple)this.tupleIterator.next();
                Set<ValidationTuple> invalidTuples = !invalidTuple.getCompressedTuples().isEmpty() ? invalidTuple.getCompressedTuples() : Collections.singleton(invalidTuple);
                HashSet<ValidationResult> validationResultsRet = new HashSet<ValidationResult>();
                for (ValidationTuple tuple : invalidTuples) {
                    List<ValidationResult> validationResults = tuple.getValidationResult();
                    for (ValidationResult validationResult : validationResults) {
                        if (this.conforms != null || validationResult.conforms()) continue;
                        this.conforms = false;
                    }
                    ValidationResult validationResult1 = validationResults.get(validationResults.size() - 1);
                    validationResultsRet.add(validationResult1);
                    ++this.counter;
                }
                if (this.conforms == null) {
                    this.conforms = true;
                }
                if (this.limit != 0L) {
                    this.next = validationResultsRet.iterator();
                }
            }
            if (this.limit == 0L && (this.counter > 0L || this.tupleIterator.hasNext())) {
                this.truncated = true;
            }
            if (this.limit >= 0L && this.counter >= this.limit && this.tupleIterator.hasNext()) {
                this.truncated = true;
            }
        } else if (this.conforms == null) {
            this.conforms = true;
        }
    }

    public List<ValidationTuple> getTuples() {
        ArrayList<ValidationTuple> actualList = new ArrayList<ValidationTuple>();
        long localCounter = 0L;
        while (this.tupleIterator.hasNext() && (this.limit < 0L || localCounter++ < this.limit + 1L)) {
            actualList.add((ValidationTuple)this.tupleIterator.next());
        }
        this.tupleIterator = new CloseableIteratorIteration<ValidationTuple, SailException>(actualList.iterator());
        return Collections.unmodifiableList(actualList);
    }

    public boolean conforms() {
        this.calculateNext();
        assert (this.conforms != null);
        return this.conforms;
    }

    public boolean isTruncated() {
        return this.truncated;
    }

    @Override
    public boolean hasNext() {
        this.calculateNext();
        return this.next.hasNext();
    }

    @Override
    public ValidationResult next() {
        this.calculateNext();
        if (!this.next.hasNext()) {
            throw new IllegalStateException();
        }
        return this.next.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

