/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.nativerdf.datastore;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.zip.CRC32;
import org.eclipse.rdf4j.common.io.ByteArrayUtil;
import org.eclipse.rdf4j.sail.nativerdf.datastore.DataFile;
import org.eclipse.rdf4j.sail.nativerdf.datastore.HashFile;
import org.eclipse.rdf4j.sail.nativerdf.datastore.IDFile;

public class DataStore
implements Closeable {
    private final DataFile dataFile;
    private final IDFile idFile;
    private final HashFile hashFile;

    public DataStore(File dataDir, String filePrefix) throws IOException {
        this(dataDir, filePrefix, false);
    }

    public DataStore(File dataDir, String filePrefix, boolean forceSync) throws IOException {
        this.dataFile = new DataFile(new File(dataDir, filePrefix + ".dat"), forceSync);
        this.idFile = new IDFile(new File(dataDir, filePrefix + ".id"), forceSync);
        this.hashFile = new HashFile(new File(dataDir, filePrefix + ".hash"), forceSync);
    }

    public byte[] getData(int id) throws IOException {
        assert (id > 0) : "id must be larger than 0, is: " + id;
        long offset = this.idFile.getOffset(id);
        if (offset != 0L) {
            return this.dataFile.getData(offset);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getID(byte[] queryData) throws IOException {
        int id;
        assert (queryData != null) : "queryData must not be null";
        int hash = this.getDataHash(queryData);
        try (HashFile.IDIterator iter = this.hashFile.getIDIterator(hash);){
            while ((id = iter.next()) >= 0) {
                long offset = this.idFile.getOffset(id);
                byte[] data = this.dataFile.getData(offset);
                if (!Arrays.equals(queryData, data)) continue;
                break;
            }
        }
        return id;
    }

    public int getMaxID() throws IOException {
        return this.idFile.getMaxID();
    }

    public int storeData(byte[] data) throws IOException {
        assert (data != null) : "data must not be null";
        int id = this.getID(data);
        if (id == -1) {
            long offset = this.dataFile.storeData(data);
            id = this.idFile.storeOffset(offset);
            this.hashFile.storeID(this.getDataHash(data), id);
        }
        return id;
    }

    public void sync() throws IOException {
        this.hashFile.sync();
        this.idFile.sync();
        this.dataFile.sync();
    }

    public void clear() throws IOException {
        try {
            this.hashFile.clear();
        }
        finally {
            try {
                this.idFile.clear();
            }
            finally {
                this.dataFile.clear();
            }
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.hashFile.close();
        }
        finally {
            try {
                this.idFile.close();
            }
            finally {
                this.dataFile.close();
            }
        }
    }

    private int getDataHash(byte[] data) {
        CRC32 crc32 = new CRC32();
        crc32.update(data);
        return (int)crc32.getValue();
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Usage: java org.eclipse.rdf4j.sesame.sailimpl.nativerdf.datastore.DataStore <data-dir> <file-prefix>");
            return;
        }
        System.out.println("Dumping DataStore contents...");
        File dataDir = new File(args[0]);
        try (DataStore dataStore = new DataStore(dataDir, args[1]);){
            DataFile.DataIterator iter = dataStore.dataFile.iterator();
            while (iter.hasNext()) {
                byte[] data = iter.next();
                System.out.println(ByteArrayUtil.toHexString(data));
            }
        }
    }
}

