/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.collection.factory.impl;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import org.eclipse.rdf4j.collection.factory.api.BindingSetKey;
import org.eclipse.rdf4j.collection.factory.api.CollectionFactory;
import org.eclipse.rdf4j.collection.factory.impl.DefaultBindingSetKey;
import org.eclipse.rdf4j.common.exception.RDF4JException;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;

public class DefaultCollectionFactory
implements CollectionFactory {
    @Override
    public <T> List<T> createList() {
        return new ArrayList();
    }

    @Override
    public List<Value> createValueList() {
        return new ArrayList<Value>();
    }

    @Override
    public <T> Set<T> createSet() {
        return new HashSet();
    }

    @Override
    public Set<Value> createValueSet() {
        return new HashSet<Value>();
    }

    @Override
    public Set<BindingSet> createSetOfBindingSets() {
        return new HashSet<BindingSet>();
    }

    @Override
    public <K, V> Map<K, V> createMap() {
        return new HashMap();
    }

    @Override
    public <V> Map<Value, V> createValueKeyedMap() {
        return new HashMap();
    }

    @Override
    public <T> Queue<T> createQueue() {
        return new ArrayDeque();
    }

    @Override
    public Queue<Value> createValueQueue() {
        return new ArrayDeque<Value>();
    }

    @Override
    public void close() throws RDF4JException {
    }

    @Override
    public <E> Map<BindingSetKey, E> createGroupByMap() {
        return new LinkedHashMap();
    }

    @Override
    public BindingSetKey createBindingSetKey(BindingSet bindingSet, List<Function<BindingSet, Value>> getValues, ToIntFunction<BindingSet> hashOfBindingSetCalculator) {
        ArrayList<Value> values = new ArrayList<Value>(getValues.size());
        for (int i = 0; i < getValues.size(); ++i) {
            values.add(getValues.get(i).apply(bindingSet));
        }
        return new DefaultBindingSetKey(values, hashOfBindingSetCalculator.applyAsInt(bindingSet));
    }
}

