/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.optimizer;

import java.util.List;
import java.util.Set;
import org.eclipse.rdf4j.federated.algebra.ExclusiveGroup;
import org.eclipse.rdf4j.federated.algebra.ExclusiveStatement;
import org.eclipse.rdf4j.federated.algebra.ExclusiveTupleExpr;
import org.eclipse.rdf4j.federated.algebra.FedXService;
import org.eclipse.rdf4j.federated.algebra.NJoin;
import org.eclipse.rdf4j.federated.algebra.NUnion;
import org.eclipse.rdf4j.federated.algebra.StatementSourcePattern;
import org.eclipse.rdf4j.federated.optimizer.FedXCostModel;
import org.eclipse.rdf4j.federated.util.QueryAlgebraUtil;
import org.eclipse.rdf4j.federated.util.QueryStringUtil;
import org.eclipse.rdf4j.query.algebra.ArbitraryLengthPath;
import org.eclipse.rdf4j.query.algebra.BindingSetAssignment;
import org.eclipse.rdf4j.query.algebra.Extension;
import org.eclipse.rdf4j.query.algebra.Projection;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFedXCostModel
implements FedXCostModel {
    public static DefaultFedXCostModel INSTANCE = new DefaultFedXCostModel();
    private static final Logger log = LoggerFactory.getLogger(DefaultFedXCostModel.class);

    @Override
    public double estimateCost(TupleExpr tupleExpr, Set<String> joinVars) {
        if (tupleExpr instanceof StatementSourcePattern) {
            return this.estimateCost((StatementSourcePattern)tupleExpr, joinVars);
        }
        if (tupleExpr instanceof ExclusiveStatement) {
            return this.estimateCost((ExclusiveStatement)tupleExpr, joinVars);
        }
        if (tupleExpr instanceof ExclusiveGroup) {
            return this.estimateCost((ExclusiveGroup)tupleExpr, joinVars);
        }
        if (tupleExpr instanceof NJoin) {
            return this.estimateCost((NJoin)tupleExpr, joinVars);
        }
        if (tupleExpr instanceof NUnion) {
            return this.estimateCost((NUnion)tupleExpr, joinVars);
        }
        if (tupleExpr instanceof FedXService) {
            return this.estimateCost((FedXService)tupleExpr, joinVars);
        }
        if (tupleExpr instanceof Projection) {
            return this.estimateCost((Projection)tupleExpr, joinVars);
        }
        if (tupleExpr instanceof BindingSetAssignment) {
            return 0.0;
        }
        if (tupleExpr instanceof Extension) {
            return 0.0;
        }
        if (tupleExpr instanceof ArbitraryLengthPath) {
            return this.estimateCost((ArbitraryLengthPath)tupleExpr, joinVars);
        }
        log.debug("No cost estimation for " + tupleExpr.getClass().getSimpleName() + " available.");
        return 1000.0;
    }

    private double estimateCost(ExclusiveGroup group, Set<String> joinVars) {
        if (joinVars.size() > 0) {
            int count = 0;
            for (String var : group.getFreeVars()) {
                if (joinVars.contains(var)) continue;
                ++count;
            }
            return 100 + count / group.getExclusiveExpressions().size();
        }
        boolean hasSelectiveStatement = false;
        for (ExclusiveTupleExpr stmt : group.getExclusiveExpressions()) {
            if (stmt.getFreeVarCount() > 1) continue;
            hasSelectiveStatement = true;
        }
        double additionalCost = 0.0;
        additionalCost += this.computeAdditionPatternCost(group.getExclusiveExpressions());
        if (!hasSelectiveStatement) {
            additionalCost += 4.0;
        }
        return 0.0 + additionalCost + (double)(group.getFreeVarCount() / group.getExclusiveExpressions().size());
    }

    private double computeAdditionPatternCost(List<ExclusiveTupleExpr> stmts) {
        String s = null;
        for (ExclusiveTupleExpr st : stmts) {
            if (!(st instanceof ExclusiveStatement)) {
                return 0.5;
            }
            String currentVar = QueryStringUtil.toString(((ExclusiveStatement)st).getSubjectVar());
            if (!currentVar.equals(s) && s != null) {
                return 0.5;
            }
            s = currentVar;
        }
        return 0.0;
    }

    private double estimateCost(ExclusiveStatement owned, Set<String> joinVars) {
        int count = 100;
        if (owned.getFreeVarCount() <= 1 && joinVars.isEmpty()) {
            count = 3;
        }
        for (String var : owned.getFreeVars()) {
            if (joinVars.contains(var)) continue;
            ++count;
        }
        return count;
    }

    private double estimateCost(FedXService service, Set<String> joinVars) {
        int additionalCost = 0;
        if (!service.getService().getServiceRef().hasValue()) {
            additionalCost += 1000;
        }
        if (service.getNumberOfTriplePatterns() <= 1) {
            additionalCost = joinVars.isEmpty() && service.getFreeVarCount() <= 1 ? 3 : (additionalCost += 100);
        }
        return 0 + additionalCost + service.getFreeVarCount();
    }

    private double estimateCost(Projection projection, Set<String> joinVars) {
        return 0 + projection.getBindingNames().size();
    }

    private double estimateCost(StatementSourcePattern stmt, Set<String> joinVars) {
        int count = 100;
        for (String var : stmt.getFreeVars()) {
            if (joinVars.contains(var)) continue;
            ++count;
        }
        return count;
    }

    private double estimateCost(NUnion nunion, Set<String> joinVars) {
        double min = Double.MAX_VALUE;
        for (TupleExpr t : nunion.getArgs()) {
            double cost = this.estimateCost(t, joinVars);
            if (!(cost < min)) continue;
            min = cost;
        }
        return min + (double)nunion.getNumberOfArguments() - 1.0;
    }

    private double estimateCost(NJoin join, Set<String> joinVars) {
        double cost = this.estimateCost(join.getArg(0), joinVars);
        return cost + (double)join.getNumberOfArguments() - 1.0;
    }

    private double estimateCost(ArbitraryLengthPath path, Set<String> joinVars) {
        int count = 100;
        for (String var : QueryAlgebraUtil.getFreeVars(path.getPathExpression())) {
            if (joinVars.contains(var)) continue;
            ++count;
        }
        return count;
    }
}

