/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.parser.sparql;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.parser.sparql.AbstractASTVisitor;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTDeleteData;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTIRI;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTInsertData;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTOperationContainer;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTPrefixDecl;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTQName;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTServiceGraphPattern;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTUnparsedQuadDataBlock;
import org.eclipse.rdf4j.query.parser.sparql.ast.VisitorException;

@InternalUseOnly
public class PrefixDeclProcessor {
    /*
     * WARNING - void declaration
     */
    public static Map<String, String> process(ASTOperationContainer qc, Map<String, String> customDefaultPrefixes) throws MalformedQueryException {
        void var6_15;
        List<ASTPrefixDecl> prefixDeclList = qc.getPrefixDeclList();
        LinkedHashMap<String, String> prefixMap = new LinkedHashMap<String, String>();
        for (ASTPrefixDecl aSTPrefixDecl : prefixDeclList) {
            String string = aSTPrefixDecl.getPrefix();
            String iri = aSTPrefixDecl.getIRI().getValue();
            if (prefixMap.containsKey(string)) {
                throw new MalformedQueryException("Multiple prefix declarations for prefix '" + string + "'");
            }
            prefixMap.put(string, iri);
        }
        int preDefaultPrefixes = 0;
        for (Map.Entry<String, String> entry : customDefaultPrefixes.entrySet()) {
            preDefaultPrefixes += PrefixDeclProcessor.insertDefaultPrefix(prefixMap, entry.getKey(), entry.getValue());
        }
        int n = preDefaultPrefixes + PrefixDeclProcessor.insertDefaultPrefix(prefixMap, "rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#") + PrefixDeclProcessor.insertDefaultPrefix(prefixMap, "rdfs", "http://www.w3.org/2000/01/rdf-schema#") + PrefixDeclProcessor.insertDefaultPrefix(prefixMap, "rdf4j", "http://rdf4j.org/schema/rdf4j#") + PrefixDeclProcessor.insertDefaultPrefix(prefixMap, "sesame", "http://www.openrdf.org/schema/sesame#") + PrefixDeclProcessor.insertDefaultPrefix(prefixMap, "owl", "http://www.w3.org/2002/07/owl#") + PrefixDeclProcessor.insertDefaultPrefix(prefixMap, "xsd", "http://www.w3.org/2001/XMLSchema#") + PrefixDeclProcessor.insertDefaultPrefix(prefixMap, "fn", "http://www.w3.org/2005/xpath-functions#");
        Object var6_12 = null;
        if (qc.getOperation() instanceof ASTInsertData) {
            ASTInsertData insertData = (ASTInsertData)qc.getOperation();
            ASTUnparsedQuadDataBlock aSTUnparsedQuadDataBlock = insertData.jjtGetChild(ASTUnparsedQuadDataBlock.class);
        } else if (qc.getOperation() instanceof ASTDeleteData) {
            ASTDeleteData deleteData = (ASTDeleteData)qc.getOperation();
            ASTUnparsedQuadDataBlock aSTUnparsedQuadDataBlock = deleteData.jjtGetChild(ASTUnparsedQuadDataBlock.class);
        }
        if (var6_15 != null) {
            String prefixes = PrefixDeclProcessor.createPrefixesInSPARQLFormat(prefixMap);
            var6_15.setAddedDefaultPrefixes(n);
            var6_15.setDataBlock(prefixes + var6_15.getDataBlock());
        } else {
            QNameProcessor visitor = new QNameProcessor(prefixMap);
            try {
                qc.jjtAccept(visitor, null);
            }
            catch (VisitorException e) {
                throw new MalformedQueryException(e);
            }
        }
        return prefixMap;
    }

    private static int insertDefaultPrefix(Map<String, String> prefixMap, String prefix, String namespace) {
        if (!prefixMap.containsKey(prefix) && !prefixMap.containsValue(namespace)) {
            prefixMap.put(prefix, namespace);
            return 1;
        }
        return 0;
    }

    private static String createPrefixesInSPARQLFormat(Map<String, String> prefixMap) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : prefixMap.entrySet()) {
            sb.append("PREFIX");
            String prefix = entry.getKey();
            if (prefix != null) {
                sb.append(" ").append(prefix);
            }
            sb.append(":");
            sb.append(" <").append(entry.getValue()).append("> \n");
        }
        return sb.toString();
    }

    private static class QNameProcessor
    extends AbstractASTVisitor {
        private final Map<String, String> prefixMap;

        public QNameProcessor(Map<String, String> prefixMap) {
            this.prefixMap = prefixMap;
        }

        @Override
        public Object visit(ASTQName qnameNode, Object data) throws VisitorException {
            String qname = qnameNode.getValue();
            int colonIdx = qname.indexOf(58);
            assert (colonIdx >= 0) : "colonIdx should be >= 0: " + colonIdx;
            String prefix = qname.substring(0, colonIdx);
            String localName = qname.substring(colonIdx + 1);
            String namespace = this.prefixMap.get(prefix);
            if (namespace == null) {
                throw new VisitorException("QName '" + qname + "' uses an undefined prefix");
            }
            localName = this.processEscapes(localName);
            ASTIRI iriNode = new ASTIRI(44);
            iriNode.setValue(namespace + localName);
            qnameNode.jjtReplaceWith(iriNode);
            return null;
        }

        private String processEscapes(String localName) {
            StringBuilder unescaped = new StringBuilder();
            Pattern escapedCharPattern = Pattern.compile("\\\\[_~.\\-!$&'()*+,;=:/?#@%]");
            Matcher m = escapedCharPattern.matcher(localName);
            boolean result = m.find();
            while (result) {
                String escaped = m.group();
                m.appendReplacement(unescaped, escaped.substring(1));
                result = m.find();
            }
            m.appendTail(unescaped);
            return unescaped.toString();
        }

        @Override
        public Object visit(ASTServiceGraphPattern node, Object data) throws VisitorException {
            node.setPrefixDeclarations(this.prefixMap);
            return super.visit(node, data);
        }
    }
}

