/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.algebra;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.rdf4j.federated.algebra.ExclusiveTupleExprRenderer;
import org.eclipse.rdf4j.federated.algebra.StatementSource;
import org.eclipse.rdf4j.federated.algebra.StatementTupleExpr;
import org.eclipse.rdf4j.federated.structures.QueryInfo;
import org.eclipse.rdf4j.federated.util.QueryAlgebraUtil;
import org.eclipse.rdf4j.federated.util.QueryStringUtil;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.algebra.ArbitraryLengthPath;
import org.eclipse.rdf4j.query.algebra.TupleExpr;

public class ExclusiveArbitraryLengthPath
extends ArbitraryLengthPath
implements ExclusiveTupleExprRenderer {
    private static final long serialVersionUID = 5743134085306940200L;
    private final StatementSource owner;
    private final QueryInfo queryInfo;
    private final List<String> freeVars;

    public ExclusiveArbitraryLengthPath(ArbitraryLengthPath path, StatementSource owner, QueryInfo queryInfo) {
        super(path.getScope(), path.getSubjectVar(), path.getPathExpression(), path.getObjectVar(), path.getContextVar(), path.getMinLength());
        this.owner = owner;
        this.queryInfo = queryInfo;
        this.freeVars = this.computeFreeVars();
    }

    private List<String> computeFreeVars() {
        if (this.getPathExpression() instanceof StatementTupleExpr) {
            return ((StatementTupleExpr)this.getPathExpression()).getFreeVars();
        }
        ArrayList freeVars = Lists.newArrayList();
        if (!this.getSubjectVar().hasValue()) {
            freeVars.add(this.getSubjectVar().getName());
        }
        if (!this.getObjectVar().hasValue()) {
            freeVars.add(this.getObjectVar().getName());
        }
        return freeVars;
    }

    @Override
    public StatementSource getOwner() {
        return this.owner;
    }

    public ExclusiveArbitraryLengthPath clone() {
        return new ExclusiveArbitraryLengthPath(super.clone(), this.owner, this.queryInfo);
    }

    @Override
    public String toQueryString(Set<String> varNames, BindingSet bindings) {
        return QueryStringUtil.toString(this, varNames, bindings);
    }

    @Override
    public TupleExpr toQueryAlgebra(Set<String> varNames, BindingSet bindings) {
        return QueryAlgebraUtil.toTupleExpr(this, varNames, bindings);
    }

    @Override
    public List<String> getFreeVars() {
        return this.freeVars;
    }

    @Override
    public QueryInfo getQueryInfo() {
        return this.queryInfo;
    }
}

